/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Label;
import com.starbase.starteam.commandline.AutoEOLOption;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.ProcessItem;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Platform;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class Add
extends CommonCommand {
    private Label[] m_cachedLabels = null;
    private Vector m_addedFiles = null;
    private boolean m_markProcessFixed = true;
    private Item m_processItem = null;

    String description() {
        return Res.getString(ResIDs.ADD_FILE_DESCRIPTION);
    }

    String name() {
        return "add";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return true;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        Object object = new Object();
        Object object2 = new Object();
        commonSpec.addOption(new Option("ELock", false, object));
        commonSpec.addOption(new Option("UNLock", false, object));
        commonSpec.addOption(new Option("NELLock", false, object));
        commonSpec.addOption(new Option("ReadOnly", false, object2, object));
        commonSpec.addOption(new Option("ReadWrite", false, object2, object));
        commonSpec.addOption(new Option("Desc", false));
        commonSpec.addOption(new Option("VersionLabel", 0, Integer.MAX_VALUE));
        commonSpec.addOption(new AutoEOLOption("AutoEOL"));
        Object object3 = new Object();
        commonSpec.addOption(new Option("ProcessChangeRequest", false, object3));
        commonSpec.addOption(new Option("ProcessRequirement", false, object3));
        commonSpec.addOption(new Option("ProcessTask", false, object3));
        commonSpec.addOption(new Option("ProcessActiveItem", false, object3));
        commonSpec.addOption(new Option("ProcessMarkItem", false, null, object3));
        commonSpec.removeViewConfigOptions();
        commonSpec.removeOption("StatusFilter");
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private String getDescription() {
        String string = this.getStringOption("Desc");
        if (string == null) {
            return "";
        }
        return string;
    }

    private String getComment() {
        return Res.getString(ResIDs.ADD_FILE_COMMENT);
    }

    private int getRequestedLockStatus() {
        if (this.getIsOptionOn("ELock")) {
            return 1;
        }
        if (this.getIsOptionOn("UNLock")) {
            return 0;
        }
        if (this.getIsOptionOn("NELLock")) {
            return 2;
        }
        return 3;
    }

    private boolean getAutoEOL() {
        if (this.getIsOptionOn("AutoEOL")) {
            return this.getBooleanOption("AutoEOL");
        }
        return false;
    }

    private boolean getReadOnly() {
        return this.getIsOptionOn("ReadOnly");
    }

    private boolean getReadWrite() {
        return this.getIsOptionOn("ReadWrite");
    }

    private boolean isProcessOn() {
        return this.getIsOptionOn("ProcessChangeRequest") || this.getIsOptionOn("ProcessRequirement") || this.getIsOptionOn("ProcessTask") || this.getIsOptionOn("ProcessActiveItem");
    }

    private Item getProcessItem() throws IOException {
        Item item = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.getIsOptionOn("ProcessActiveItem")) {
            item = ProcessItem.getProcessItem(this.getView());
            if (item == null) {
                throw new IOException(Res.getString(ResIDs.ADD_FILE_ACTIVE_PROCESS_NOT_SET));
            }
        } else if (this.getIsOptionOn("ProcessChangeRequest")) {
            string = this.getStringOption("ProcessChangeRequest");
            string3 = this.getView().getServer().getTypeNames().CHANGEREQUEST;
            string2 = this.getView().getServer().getPropertyNames().CR_CHANGE_NUMBER;
        } else if (this.getIsOptionOn("ProcessRequirement")) {
            string = this.getStringOption("ProcessRequirement");
            string3 = this.getView().getServer().getTypeNames().REQUIREMENT;
            string2 = "RequirementNumber";
        } else if (this.getIsOptionOn("ProcessTask")) {
            string = this.getStringOption("ProcessTask");
            string3 = this.getView().getServer().getTypeNames().TASK;
            string2 = this.getView().getServer().getPropertyNames().TASK_NUMBER;
        }
        if (string != null) {
            int n = string.lastIndexOf("/");
            String string4 = null;
            int n2 = -1;
            if (n >= 0) {
                string4 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Folder folder = null;
            if (stringTokenizer.hasMoreTokens()) {
                String string5;
                Folder folder2 = this.getView().getRootFolder();
                if (this.folderNameMatch(folder2, string5 = stringTokenizer.nextToken())) {
                    folder = this.findFolder(folder2, stringTokenizer);
                } else {
                    throw new IOException(Res.formatKey(ResIDs.ADD_FILE_FOLDER_NOT_FOUND_ERROR_MSG, new Object[]{string5, this.getView().getName()}));
                }
            }
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                throw new IOException(Res.getString(ResIDs.ADD_FILE_BAD_PROCESS_ITEM_ERROR_MSG));
            }
            item = this.getItem(folder, string3, string2, n2);
        }
        return item;
    }

    private Item getItem(Folder folder, String string, String string2, int n) {
        if (folder == null) {
            return null;
        }
        folder.populateNow(string, new String[]{string2}, 0);
        Item[] itemArray = folder.getItems(string);
        Object var6_6 = null;
        if (itemArray != null) {
            int n2 = 0;
            while (n2 < itemArray.length) {
                Integer n3 = (Integer)itemArray[n2].get(string2);
                if (n == n3) {
                    return itemArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    void processOneFile(Folder folder, File file) throws IOException {
        this.message(Res.formatKey(ResIDs.ADD_FILE_FILE_IN_PROJECT_ERROR_MSG, new Object[]{file.getName()}));
    }

    private String[] getLabelNames() {
        return this.getStringOptionList("VersionLabel");
    }

    protected void preOperation() throws IOException {
        String[] stringArray;
        if (ProcessItem.requiresProcessRules(this.getView().getProject()) && !this.isProcessOn()) {
            throw new IOException(Res.getString(ResIDs.ADD_FILE_PROCESS_ITEM_NOT_SPECIFIED_ERROR_MSG));
        }
        if (this.isProcessOn()) {
            this.m_addedFiles = new Vector();
            this.m_processItem = this.getProcessItem();
            if (this.m_processItem == null) {
                throw new IOException(Res.getString(ResIDs.ADD_FILE_PROCESS_ITEM_NOT_FOUND_ERROR_MSG));
            }
            if (!ProcessItem.getValidProcessItemState(this.m_processItem)) {
                throw new IOException(Res.getString(ResIDs.ADD_FILE_BAD_PROCESS_ITEM_STATE));
            }
        }
        if ((stringArray = this.getLabelNames()) != null) {
            this.m_cachedLabels = new Label[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                Label label = this.findLabel(stringArray[n]);
                if (label == null) {
                    throw new IOException(Res.formatKey(ResIDs.ADD_FILE_LABEL_MISSING_ERROR_MSG, new Object[]{stringArray[n]}));
                }
                this.m_cachedLabels[n] = label;
                ++n;
            }
        }
    }

    protected void postOperation() throws IOException {
        if (this.getIsOptionOn("ProcessMarkItem") && this.m_markProcessFixed) {
            ProcessItem.markProcessItemFixed(this.m_processItem);
            this.m_processItem.discard();
            this.message(Res.formatKey(ResIDs.ADD_FILE_PROCESS_ITEM_UPDATED, new Object[]{ProcessItem.getProcessItemName(this.m_processItem)}));
        }
        if (this.isProcessOn()) {
            int n = 0;
            while (n < this.m_addedFiles.size()) {
                File file = (File)this.m_addedFiles.elementAt(n);
                ProcessItem.linkProcessItem(file, this.m_processItem);
                this.message(Res.formatKey(ResIDs.ADD_FILE_PROCESS_ITEM_LINKED_MSG, new Object[]{file.getName(), ProcessItem.getProcessItemName(this.m_processItem)}));
                ++n;
            }
        }
    }

    private void applyLabels(File file) throws IOException {
        if (this.m_cachedLabels != null) {
            int n = 0;
            while (n < this.m_cachedLabels.length) {
                Label label = this.m_cachedLabels[n];
                if (label != null) {
                    label.attachItem(file, file.getObjectID(), file.getCreatedTime(), false);
                    label.update();
                }
                ++n;
            }
        }
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        boolean bl;
        File file;
        java.io.File file2;
        block4: {
            file2 = new java.io.File(folder.getFilePath(string));
            file = null;
            file = new File(folder);
            bl = false;
            try {
                file.add(file2, string, this.getDescription(), this.getComment(), this.getRequestedLockStatus(), this.getAutoEOL(), true);
                bl = true;
                this.message(Res.formatKey(ResIDs.ADD_FILE_FILE_ADDED_MSG, new Object[]{string}));
                if (!this.isProcessOn()) break block4;
                this.m_addedFiles.addElement(file);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!bl) {
                    this.m_markProcessFixed = false;
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (!bl) {
            this.m_markProcessFixed = false;
        }
        this.applyLabels(file);
        this.fixLocalRW(file2, this.getRequestedLockStatus());
    }

    private String fixLocalRW(java.io.File file, int n) throws IOException {
        if (n == 3) {
            return "";
        }
        if (this.getReadOnly()) {
            Platform.setFileWritable(file, false);
            return Res.getString(ResIDs.ADD_FILE_READ_ONLY_SET_MSG);
        }
        if (this.getReadWrite()) {
            Platform.setFileWritable(file, true);
            return Res.getString(ResIDs.ADD_FILE_READ_WRITE_SET_MSG);
        }
        return "";
    }

    void processNoFiles() throws IOException {
    }

    Add() {
    }
}

