/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.ExcludeOption;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

class AddFolder
extends CommonCommand {
    private String m_folderExcludeList = null;

    String description() {
        return Res.getString(ResIDs.ADD_FOLDER_DESCRIPTION);
    }

    String name() {
        return "add-folder";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return true;
    }

    private String getFolderName() {
        return this.getStringOption("FolderName");
    }

    private String getFolderDescription() {
        String string = this.getStringOption("FolderDescription");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private int getFolderExclude() throws RuntimeException {
        String string = this.getStringOption("FolderExclude");
        if ("inherit".equals(string.toLowerCase())) {
            return 2;
        }
        if ("local".equals(string.toLowerCase())) {
            return 1;
        }
        if ("none".equals(string.toLowerCase())) {
            return 0;
        }
        throw new RuntimeException(Res.formatKey(ResIDs.BAD_EXCLUDE_FLAG_ERROR_MSG, new Object[]{string}));
    }

    protected void preOperation() throws IOException {
        this.m_folderExcludeList = this.getFolderExcludeList();
    }

    private String getExcludeListFile() {
        return this.getStringOption("FolderExcludeFile");
    }

    private String getFolderExcludeList() throws IOException {
        if (this.getIsOptionOn("FolderExcludeList")) {
            return this.getStringOption("FolderExcludeList");
        }
        if (this.getIsOptionOn("FolderExcludeFile")) {
            String string = this.getExcludeListFromFile(this.getExcludeListFile());
            return string;
        }
        return null;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        commonSpec.addOption(new Option("FolderName", true));
        commonSpec.addOption(new Option("FolderDescription", false));
        commonSpec.addOption(new ExcludeOption("FolderExclude", false));
        Object object = new Object();
        commonSpec.addOption(new Option("FolderExcludeList", false, object));
        commonSpec.addOption(new Option("FolderExcludeFile", false, object));
        commonSpec.removeOption("StatusFilter");
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    void processLocalFile(Folder folder, String string) throws IOException {
    }

    void processOneFile(Folder folder, File file) throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getExcludeListFromFile(String string) throws IOException {
        String string2;
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new IOException(Res.formatKey(ResIDs.EXCLUDE_FILE_MISSING_ERROR_MSG, new Object[]{string}));
        }
        if (file.isDirectory()) {
            throw new IOException(Res.formatKey(ResIDs.EXCLUDE_FILE_IS_DIRECTORY_ERROR_MSG, new Object[]{string}));
        }
        if (!file.canRead()) {
            throw new IOException(Res.formatKey(ResIDs.EXCLUDE_FILE_NOT_READABLE_ERROR_MSG, new Object[]{string}));
        }
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            string2 = stringBuffer.toString();
            Object var6_7 = null;
            if (bufferedReader == null) return string2;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return string2;
    }

    private Folder findSpecifiedFolder(Folder folder, String string) {
        boolean bl = this.getIsOptionOn("CaseSensitiveFolders");
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            Folder folder2 = folderArray[n];
            if (bl ? string.equals(folder2.getName()) : string.equalsIgnoreCase(folder2.getName())) {
                return folder2;
            }
            ++n;
        }
        return null;
    }

    protected void processFolder(Folder folder, boolean bl) throws IOException {
        String string = this.getFolderName();
        this.message(Res.formatKey(ResIDs.FOLDER_INFORMATION_MSG, new Object[]{folder.getName(), folder.getPath()}));
        Folder folder2 = this.createFolder(folder, string, true);
        if (bl) {
            if (folder2 == null) {
                throw new IOException(Res.formatKey(ResIDs.FOLDER_NOT_FOUND_ERROR_MSG, new Object[]{string}));
            }
            this.processSubFolders(folder2);
        }
    }

    protected Folder createFolder(Folder folder, String string, boolean bl) throws IOException {
        Folder folder2 = this.findSpecifiedFolder(folder, string);
        if (folder2 != null) {
            this.message(Res.formatKey(ResIDs.FOLDER_SKIPPED_MSG, new Object[]{string}));
        } else {
            folder2 = new Folder(folder);
            folder2.setName(string);
            folder2.setDefaultPathFragment(string);
            folder2.setDescription(this.getFolderDescription());
            folder2.update();
            if (bl) {
                boolean bl2 = false;
                if (this.getIsOptionOn("FolderExclude")) {
                    int n = this.getFolderExclude();
                    folder2.setExcludeFlags(n);
                    bl2 = true;
                }
                if (this.m_folderExcludeList != null) {
                    folder2.setExcludeList(this.m_folderExcludeList);
                    bl2 = true;
                }
                if (bl2) {
                    folder2.update();
                }
            }
            this.message(Res.formatKey(ResIDs.FOLDER_ADDED_MSG, new Object[]{string}));
        }
        return folder2;
    }

    private void processSubFolders(Folder folder) throws IOException {
        String[] stringArray;
        java.io.File file = new java.io.File(folder.getPath());
        this.message(Res.formatKey(ResIDs.FOLDER_INFORMATION_MSG, new Object[]{folder.getName(), folder.getPath()}));
        if (file.isDirectory() && (stringArray = file.list()).length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                java.io.File file2 = new java.io.File(folder.getPath(), stringArray[n]);
                if (file2.isDirectory()) {
                    this.createFolder(folder, stringArray[n], false);
                }
                ++n;
            }
            Folder[] folderArray = folder.getSubFolders();
            int n2 = 0;
            while (n2 < folderArray.length) {
                this.processSubFolders(folderArray[n2]);
                ++n2;
            }
        }
    }

    void processNoFiles() {
    }

    AddFolder() {
    }
}

