/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.diff.BasicCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.StarTeamMerge;
import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.Status;
import com.starbase.starteam.commandline.CommandLineQuitException;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.EOLSpecifierOption;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.PositiveIntegerOption;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.SimpleStringOption;
import com.starbase.starteam.commandline.TimeOption;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import com.starbase.util.StreamUtils;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Date;

class CheckOut
extends CommonCommand {
    private java.io.File m_sync_file = null;
    private java.io.File m_your_file = null;
    private java.io.File m_merged_file = null;
    private Label m_label = null;
    private boolean m_forceCO;
    private boolean m_promptCO;
    private boolean m_FNCO;
    private boolean m_timeStampNow;
    private boolean m_readOnly = false;
    private boolean m_readWrite = false;
    private boolean m_updateStatus;
    private boolean m_eol = false;
    private String m_eolString = null;
    private int m_lockStatus;
    private int m_requestedVersion;
    private OLEDate m_date;
    private boolean m_checkouttime;
    private boolean m_checkoutversion;
    private boolean m_checkoutlabel;
    private boolean m_doMerge = false;
    private String m_hook = null;
    private Object m_checkoutSpec = null;
    private boolean m_dryRun = false;
    private boolean m_alwaysPrompt = false;
    private boolean m_neverPrompt = false;
    private boolean m_conflictPrompt = false;

    String description() {
        return Res.getString(ResIDs.CHECK_OUT_DESCRIPTION);
    }

    String name() {
        return "co";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean isDryRun() {
        return this.m_dryRun;
    }

    boolean isAlwaysPrompt() {
        return this.m_alwaysPrompt;
    }

    boolean isNeverPrompt() {
        return this.m_neverPrompt;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        Object object = new Object();
        Object object2 = new Object();
        Object object3 = new Object();
        commonSpec.addOption(new Option("ELock", false, object));
        commonSpec.addOption(new Option("UNLock", false, object));
        commonSpec.addOption(new Option("NELLock", false, object));
        commonSpec.addOption(new Option("ReadOnly", false, object2, object));
        commonSpec.addOption(new Option("ReadWrite", false, object2, object));
        commonSpec.addOption(new PositiveIntegerOption("VersionNumber", false, false, object3));
        commonSpec.addOption(new TimeOption("VersionDate", false, object3));
        commonSpec.addOption(new Option("VersionLabel", false, object3));
        commonSpec.addOption(new SimpleStringOption("NeedsCheckout", false));
        Object object4 = new Object();
        commonSpec.addOption(new Option("ForceOut", false, object4));
        commonSpec.addOption(new Option("PromptForCOAction", false, object4));
        commonSpec.addOption(new Option("TimeStamp", false));
        commonSpec.addOption(new EOLSpecifierOption("EOLSpecifier"));
        commonSpec.addOption(new Option("NoStatusUpdate", false));
        commonSpec.addOption(new Option("MergeOnCheckout", false, object4));
        commonSpec.addOption(new Option("MergeHook", false));
        Object object5 = new Object();
        commonSpec.addOption(new Option("MergeDryRun", false, object5));
        commonSpec.addOption(new Option("MergeAlwaysPrompt", false, object5));
        commonSpec.addOption(new Option("MergeNeverPrompt", false, object5));
        commonSpec.addOption(new Option("MergeConflictPrompt", false, object5));
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    protected boolean parseArguments(String[] stringArray) {
        boolean bl = super.parseArguments(stringArray);
        if (bl && !this.getIsOptionOn("MergeOnCheckout") && (this.getIsOptionOn("MergeDryRun") || this.getIsOptionOn("MergeAlwaysPrompt") || this.getIsOptionOn("MergeNeverPrompt") || this.getIsOptionOn("MergeConflictPrompt"))) {
            this.message("");
            this.message(Res.getString(ResIDs.CHECK_OUT_INVALID_SPEC_ERROR_MSG));
            this.message(Res.formatKey(ResIDs.CHECK_OUT_PARAMETER_HELP_MSG, new Object[]{Option.OPTION_PREFIX, Option.getName("MergeOnCheckout")}));
            this.message("    " + Option.OPTION_PREFIX + Option.getName("MergeDryRun"));
            this.message("    " + Option.OPTION_PREFIX + Option.getName("MergeAlwaysPrompt"));
            this.message("    " + Option.OPTION_PREFIX + Option.getName("MergeNeverPrompt"));
            this.message("    " + Option.OPTION_PREFIX + Option.getName("MergeConflictPrompt"));
            this.message("");
            this.showUsage();
            throw new CommandLineQuitException();
        }
        return bl;
    }

    protected void preOperation() throws IOException {
        String string;
        this.m_eol = false;
        this.m_eolString = Platform.getEOL();
        if (this.getIsOptionOn("EOLSpecifier")) {
            string = this.getStringOption("EOLSpecifier");
            if (string.equals("off")) {
                this.m_eol = false;
            } else {
                this.m_eol = true;
                if (!string.equals("default")) {
                    this.m_eolString = string;
                    this.getServer().getClientContext().setEOL(string);
                }
            }
        }
        this.m_checkoutSpec = null;
        if (this.getIsOptionOn("VersionLabel")) {
            string = this.getStringOption("VersionLabel");
            Label label = this.findLabel(string);
            if (label == null) {
                throw new IOException(Res.formatKey(ResIDs.CHECK_OUT_LABEL_MISSING_ERROR_MSG, new Object[]{string}));
            }
            this.m_label = label;
            this.m_checkoutSpec = this.m_label;
        }
        this.m_forceCO = this.getIsOptionOn("ForceOut");
        this.m_promptCO = this.getIsOptionOn("PromptForCOAction");
        this.m_FNCO = this.getIsOptionOn("NeedsCheckout");
        this.m_timeStampNow = this.getIsOptionOn("TimeStamp");
        this.m_readOnly = this.getIsOptionOn("ReadOnly");
        this.m_readWrite = this.getIsOptionOn("ReadWrite");
        this.m_updateStatus = !this.getIsOptionOn("NoStatusUpdate");
        this.m_lockStatus = 3;
        if (this.getIsOptionOn("ELock")) {
            this.m_lockStatus = 1;
        }
        if (this.getIsOptionOn("UNLock")) {
            this.m_lockStatus = 0;
        }
        if (this.getIsOptionOn("NELLock")) {
            this.m_lockStatus = 2;
        }
        this.m_requestedVersion = -1;
        if (this.getIsOptionOn("VersionNumber")) {
            this.m_requestedVersion = this.getIntegerOption("VersionNumber");
            this.m_checkoutSpec = new Integer(this.m_requestedVersion);
        }
        this.m_date = null;
        if (this.getIsOptionOn("VersionDate")) {
            this.m_date = new OLEDate(this.getTimeOption("VersionDate").getTime());
            this.m_checkoutSpec = new Date(this.m_date.getLongValue());
        }
        this.m_checkouttime = this.getIsOptionOn("VersionDate");
        this.m_checkoutversion = this.getIsOptionOn("VersionNumber");
        this.m_checkoutlabel = this.getIsOptionOn("VersionLabel");
        this.m_doMerge = this.getIsOptionOn("MergeOnCheckout");
        this.m_dryRun = this.getIsOptionOn("MergeDryRun");
        this.m_alwaysPrompt = this.getIsOptionOn("MergeAlwaysPrompt");
        this.m_neverPrompt = this.getIsOptionOn("MergeNeverPrompt");
        if (this.getIsOptionOn("MergeHook")) {
            this.m_hook = this.getStringOption("MergeHook");
        }
    }

    private boolean getForceCheckout() {
        return this.m_forceCO;
    }

    private boolean getPromptForCheckout() {
        return this.m_promptCO;
    }

    private boolean getFNCO() {
        return this.m_FNCO;
    }

    private boolean getTimeStampNow() {
        return this.m_timeStampNow;
    }

    private boolean getReadOnly() {
        return this.m_readOnly;
    }

    private boolean getReadWrite() {
        return this.m_readWrite;
    }

    private boolean getUpdateStatus() {
        return this.m_updateStatus;
    }

    private boolean getAutoEOL() {
        return this.m_eol;
    }

    private int getRequestedLockStatus() {
        return this.m_lockStatus;
    }

    private int getRequestedVersion() {
        return this.m_requestedVersion;
    }

    private OLEDate getCheckoutDate() {
        return this.m_date;
    }

    private boolean checkoutTime() {
        return this.m_checkouttime;
    }

    private boolean checkoutViewVersion() {
        return this.m_checkoutversion;
    }

    private boolean checkoutLabel() {
        return this.m_checkoutlabel;
    }

    private boolean checkoutTip() {
        return !this.checkoutTime() && !this.checkoutViewVersion() && !this.checkoutLabel();
    }

    boolean ignoreUserFileList() {
        return false;
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        this.message(Res.formatKey(ResIDs.CHECK_OUT_NOT_IN_VIEW_ERROR_MSG, new Object[]{string}));
    }

    void processOneFile(Folder folder, File file) throws IOException {
        String string = file.getFullName();
        java.io.File file2 = new java.io.File(string);
        String string2 = file.getName();
        int n = this.getRequestedLockStatus();
        boolean bl = this.checkoutTip();
        if (this.handleMerge(file)) {
            this.doMerge(file);
        } else if (this.confirmStatusForCheckout(folder, file, this.getForceCheckout(), this.getPromptForCheckout(), this.getFNCO(), bl)) {
            boolean bl2 = false;
            boolean bl3 = this.getUpdateStatus();
            if (this.checkoutTime()) {
                bl2 = file.checkoutByDate(null, new OLEDate(this.getCheckoutDate()), n, this.getTimeStampNow(), this.getAutoEOL(), bl3);
            } else if (this.checkoutViewVersion()) {
                bl2 = file.checkoutByVersion(null, this.getRequestedVersion(), n, this.getTimeStampNow(), this.getAutoEOL(), bl3);
            } else if (this.checkoutLabel()) {
                bl2 = file.checkoutByLabelID(null, this.m_label.getID(), n, this.getTimeStampNow(), this.getAutoEOL(), bl3);
            } else {
                file.checkout(n, this.getTimeStampNow(), this.getAutoEOL(), bl3);
                bl2 = true;
            }
            if (bl2) {
                this.message(Res.formatKey(ResIDs.CHECK_OUT_CHECKED_OUT_MSG, new Object[]{string2}));
                this.fixLocalRW(file2, n);
            } else {
                this.message(Res.formatKey(ResIDs.CHECK_OUT_SKIPPED_MSG, new Object[]{string2}));
            }
        } else {
            this.message(Res.formatKey(ResIDs.CHECK_OUT_SKIPPED_MSG, new Object[]{string2}));
        }
    }

    private String fixLocalRW(java.io.File file, int n) throws IOException {
        if (n == 3) {
            return "";
        }
        if (this.getReadOnly()) {
            Platform.setFileWritable(file, false);
            return Res.getString(ResIDs.CHECK_OUT_READ_ONLY_SET_MSG);
        }
        if (this.getReadWrite()) {
            Platform.setFileWritable(file, true);
            return Res.getString(ResIDs.CHECK_OUT_READ_WRITE_SET_MSG);
        }
        return "";
    }

    void processNoFiles() {
    }

    private String wontCheckoutMsg(int n) {
        switch (n) {
            case 1: {
                return Res.formatKey(ResIDs.CHECK_OUT_FILE_STATUS_IS_MERGE_MSG, new Object[]{Option.getName("ForceOut"), Option.getName("MergeOnCheckout")});
            }
            case 3: {
                return Res.formatKey(ResIDs.CHECK_OUT_FILE_STATUS_IS_MODIFIED_MSG, new Object[]{Option.getName("ForceOut")});
            }
            case 6: {
                return Res.formatKey(ResIDs.CHECK_OUT_FILE_STATUS_IS_UNKNOWN_MSG, new Object[]{Option.getName("ForceOut")});
            }
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return null;
    }

    boolean confirmStatusForCheckout(Folder folder, File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        int n = file.getStatus();
        switch (n) {
            case 2: 
            case 5: {
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                if (bl3) {
                    return false;
                }
                if (bl) {
                    return true;
                }
                if (bl2) {
                    return this.prompt(Res.formatKey(ResIDs.CHECK_OUT_STATUS_PROMPT_MSG, new Object[]{file.getName(), Status.name(n)}));
                }
                this.confirm(Res.formatKey(ResIDs.CHECK_OUT_FAILED_CONFIRM_MSG, new Object[]{file.getName(), this.wontCheckoutMsg(n)}));
                return false;
            }
            case 0: {
                if (bl3) {
                    return false;
                }
                if (!bl4) {
                    return true;
                }
                return bl;
            }
        }
        return false;
    }

    private boolean handleMerge(File file) throws IOException {
        return this.m_doMerge && file.getStatus() == 1;
    }

    private void doMerge(File file) throws IOException {
        block12: {
            try {
                this.cleanTempFiles();
                String string = file.getFullName();
                String string2 = file.getName();
                this.m_your_file = new java.io.File(this.getTempFileName(string, "yrs"));
                File file2 = this.checkoutBySpec(this.m_your_file, file);
                this.m_sync_file = new java.io.File(this.getTempFileName(string, "cmn"));
                this.m_merged_file = new java.io.File(this.getTempFileName(string, "mrg"));
                File file3 = this.checkoutSync(this.m_sync_file, file2);
                int n = this.performMerge(new java.io.File(file.getFullName()), Res.formatKey(ResIDs.CHECK_OUT_LOCAL_TITLE, new Object[]{string2}), this.m_sync_file, Res.formatKey(ResIDs.CHECK_OUT_COMMON_TITLE, new Object[]{string2, new Integer(file3.getViewVersion())}), this.m_your_file, Res.formatKey(ResIDs.CHECK_OUT_COMMON_TITLE, new Object[]{string2, new Integer(file2.getViewVersion())}), this.m_merged_file);
                if (n != 0 && n != 1) {
                    throw new RuntimeException(Res.formatKey(ResIDs.CHECK_OUT_ERROR_PERFORMING_MERGE_MSG, new Object[]{new Integer(n)}));
                }
                boolean bl = false;
                boolean bl2 = false;
                String string3 = file.getName();
                if (this.isDryRun()) {
                    bl = false;
                    bl2 = false;
                    this.message(Res.formatKey(ResIDs.CHECK_OUT_NOT_CHECKED_OUT_ERROR_MSG, new Object[]{string3, n == 0 ? Res.getString(ResIDs.CHECK_OUT_NO_MERGE_CONFLICTS) : Res.getString(ResIDs.CHECK_OUT_MERGE_HAS_CONFLICTS)}));
                } else if (this.isAlwaysPrompt()) {
                    bl2 = true;
                } else if (this.isNeverPrompt()) {
                    bl2 = false;
                    bl = true;
                } else if (n == 1) {
                    bl2 = true;
                } else {
                    bl2 = false;
                    bl = true;
                }
                if (bl2) {
                    bl = this.prompt(Res.formatKey(ResIDs.CHECK_OUT_PROMPT_SAVE_CHANGES_MSG, new Object[]{string3, n == 0 ? Res.getString(ResIDs.CHECK_OUT_HAS_NO_MERGE_CONFLICTS) : Res.getString(ResIDs.CHECK_OUT_HAS_MERGE_CONFLICTS)}));
                }
                if (!bl) break block12;
                this.copyFile(this.m_merged_file, new java.io.File(file.getFullName()));
                file2.updateStatusAfterMerge();
                this.message(Res.formatKey(ResIDs.CHECK_OUT_CHECKED_OUT_MERGE_MSG, new Object[]{string3, n == 0 ? Res.getString(ResIDs.CHECK_OUT_NO_MERGE_CONFLICTS_RESULT) : Res.getString(ResIDs.CHECK_OUT_MERGE_CONFLICTS_RESULT)}));
            }
            catch (Throwable throwable) {
                Object var3_11 = null;
                this.cleanTempFiles();
                throw throwable;
            }
        }
        Object var3_10 = null;
        this.cleanTempFiles();
    }

    private void deleteFile(java.io.File file) {
        try {
            if (file != null) {
                file.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanTempFiles() {
        this.deleteFile(this.m_your_file);
        this.m_your_file = null;
        this.deleteFile(this.m_sync_file);
        this.m_sync_file = null;
        this.deleteFile(this.m_merged_file);
        this.m_merged_file = null;
    }

    private File checkoutSync(java.io.File file, File file2) throws IOException {
        File file3 = file2.findMergeVersion();
        if (file3 == null) {
            file3 = file2;
        }
        boolean bl = false;
        boolean bl2 = true;
        file3.checkoutTo(file, 3, bl2, this.getAutoEOL(), bl);
        return file3;
    }

    private File checkoutBySpec(java.io.File file, File file2) throws IOException {
        int n;
        File file3 = null;
        Object object = this.m_checkoutSpec;
        if (object == null) {
            file3 = file2;
        } else if (object instanceof Integer) {
            n = (Integer)object;
            file3 = (File)file2.getFromHistoryByVersion(n);
            if (file3 == null) {
                throw new IOException(Res.formatKey(ResIDs.CHECK_OUT_REVISION_DOES_NOT_EXIST_ERROR_MSG, new Object[]{new Integer(n), file2.getName()}));
            }
        } else if (object instanceof Label) {
            Label label = (Label)object;
            file3 = (File)file2.getFromHistoryByLabelID(label.getID());
            if (file3 == null) {
                throw new IOException(Res.formatKey(ResIDs.CHECK_OUT_LABEL_NOT_ASSOCIATED_ERROR_MSG, new Object[]{label.getName(), file2.getName()}));
            }
        } else if (object instanceof Date) {
            OLEDate oLEDate = new OLEDate(((Date)object).getTime());
            file3 = (File)file2.getFromHistoryByDate(oLEDate);
            if (file3 == null) {
                throw new IOException(Res.formatKey(ResIDs.CHECK_OUT_NO_REVISION_OF_FILE_EXISTS_AS_OF_DATE_ERROR_MSG, new Object[]{file2.getName(), oLEDate.toString()}));
            }
        } else {
            throw new RuntimeException(Res.formatKey(ResIDs.CHECK_OUT_UNEXPECTED_SOURCE_SPEC_ERROR_MSG, new Object[]{object}));
        }
        n = 0;
        boolean bl = true;
        file3.checkoutTo(file, 3, bl, this.getAutoEOL(), n != 0);
        return file3;
    }

    private String getTempFileName(String string, String string2) throws IOException {
        int n = 10;
        String string3 = string + "." + string2;
        java.io.File file = new java.io.File(string3);
        if (!file.exists()) {
            return string3;
        }
        String string4 = null;
        int n2 = 1;
        while (n2 <= n) {
            String string5 = string3 + "." + n2;
            file = new java.io.File(string5);
            if (!file.exists()) {
                string4 = string5;
                break;
            }
            ++n2;
        }
        if (string4 != null) {
            return string4;
        }
        throw new IOException(Res.formatKey(ResIDs.CHECK_OUT_UNABLE_TO_CREATE_TEMP_FILE_ERROR_MSG, new Object[]{string3}));
    }

    private int performMerge(java.io.File file, String string, java.io.File file2, String string2, java.io.File file3, String string3, java.io.File file4) throws IOException {
        if (this.m_hook == null) {
            return this.internalMerge(file, string, file2, string2, file3, string3, file4);
        }
        String[] stringArray = new String[]{this.m_hook, file.getAbsolutePath(), file2.getAbsolutePath(), file3.getAbsolutePath()};
        return this.callHook(stringArray, file4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int internalMerge(java.io.File file, String string, java.io.File file2, String string2, java.io.File file3, String string3, java.io.File file4) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        int n = 2;
        try {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file4));
                boolean bl = StarTeamMerge.merge(file, file2, file3, new BasicCompare(), bufferedOutputStream, string, string2, string3, false, false, this.m_eolString);
                n = bl ? 1 : 0;
            }
            catch (DiffException diffException) {
                Assert.internalError("CheckOut.internalMerge()", diffException);
                Object var11_13 = null;
                if (bufferedOutputStream == null) return n;
                bufferedOutputStream.close();
                return n;
            }
            Object var11_12 = null;
            if (bufferedOutputStream == null) return n;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (bufferedOutputStream == null) throw throwable;
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedOutputStream.close();
        return n;
    }

    private int callHook(String[] stringArray, java.io.File file) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtils.bufferedTransfer(process.getInputStream(), fileOutputStream, 2048);
        try {
            int n = process.waitFor();
            if (n != 0 && n != 1) {
                StringWriter stringWriter = new StringWriter();
                InputStream inputStream = process.getErrorStream();
                int n2 = inputStream.read();
                while (n2 != -1) {
                    stringWriter.write(n2);
                    n2 = inputStream.read();
                }
                stringWriter.flush();
                throw new RuntimeException(Res.formatKey(ResIDs.CHECK_OUT_ERROR_CALLING_ERROR_MSG, new Object[]{stringArray[0], stringWriter.toString()}));
            }
            return n;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(Res.formatKey(ResIDs.CHECK_OUT_CALL_INTERRUPTED_MSG, new Object[]{stringArray[0]}));
        }
    }

    private void copyFile(java.io.File file, java.io.File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            StreamUtils.bufferedTransfer(fileInputStream, fileOutputStream, 2048);
        }
        finally {
            Object var6_5 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    CheckOut() {
    }
}

