/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.ParseException;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Platform;
import java.util.Enumeration;
import java.util.Vector;

class CommandLineSpec {
    private static final String ONE_SPACE_STRING = " ";
    private String m_sErrorMsg = null;
    private Vector m_Parameters = new Vector();
    private Vector m_OptionList = new Vector();
    private boolean m_bAllowParams = true;
    private boolean m_bRequireParams = true;
    private Vector m_options = new Vector();
    private Vector m_values = new Vector();
    private Vector m_uniqueOptions = new Vector();

    Enumeration getUniqueOptions() {
        return this.m_uniqueOptions.elements();
    }

    Vector getOptionValues(Option option) {
        Vector vector = new Vector();
        Enumeration enumeration = this.m_options.elements();
        Enumeration enumeration2 = this.m_values.elements();
        while (enumeration.hasMoreElements()) {
            Option option2 = (Option)enumeration.nextElement();
            Object e = enumeration2.nextElement();
            if (!option2.equals(option)) continue;
            vector.addElement(e);
        }
        return vector;
    }

    Vector getOptionValues(Vector vector) {
        Vector vector2 = new Vector();
        Enumeration enumeration = this.m_options.elements();
        Enumeration enumeration2 = this.m_values.elements();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            Object e = enumeration2.nextElement();
            if (!vector.contains(option)) continue;
            vector2.addElement(e);
        }
        return vector2;
    }

    private void addOptionValue(Option option, Object object) {
        if (!this.m_uniqueOptions.contains(option)) {
            this.m_uniqueOptions.addElement(option);
        }
        this.m_options.addElement(option);
        this.m_values.addElement(object);
    }

    private void clearOptions() {
        this.m_options.removeAllElements();
        this.m_values.removeAllElements();
        this.m_uniqueOptions.removeAllElements();
    }

    final void addOption(Option option) {
        this.m_OptionList.addElement(option);
    }

    final void removeOption(String string) {
        Option option = this.findPossibleOption(Option.getName(string));
        this.m_OptionList.removeElement(option);
    }

    final Option findSpecifiedOption(String string) {
        Enumeration enumeration = this.getUniqueOptions();
        Option option = null;
        while (enumeration.hasMoreElements()) {
            Option option2 = (Option)enumeration.nextElement();
            if (!option2.matches(string)) continue;
            option = option2;
            break;
        }
        return option;
    }

    final String[] getParameters() {
        int n = this.m_Parameters.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.m_Parameters.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    final String errorMessage() {
        return this.m_sErrorMsg;
    }

    void setErrorMsg(String string) {
        this.m_sErrorMsg = string;
    }

    final String getOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            if (option.getHidden()) continue;
            stringBuffer.append("    ");
            stringBuffer.append(option.usage());
            stringBuffer.append(Platform.getEOL());
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean parse(String[] stringArray) {
        this.resetParse();
        int n = stringArray.length;
        int n2 = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            while (n > 0 && this.isOption(stringArray[n2])) {
                string = stringArray[n2];
                string2 = string.substring(1);
                Option option = this.findPossibleOption(string2);
                if (option == null) {
                    throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_UNKNOWN_OPTION_ERROR_MSG, new Object[]{string}));
                }
                if (option.hasProperty()) {
                    if (--n == 0) throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_REQUIRES_ARG_ERROR_MSG, new Object[]{option.usage()}));
                    if (this.isOption(string3 = stringArray[++n2])) throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_REQUIRES_ARG_ERROR_MSG, new Object[]{option.usage()}));
                    Object object = option.getPropertyValue(string3);
                    if (object == null) throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_INVALID_OPTION_ERROR_MSG, new Object[]{string3, option.usage()}));
                    this.saveOption(option, object);
                } else {
                    this.saveOption(option, null);
                }
                ++n2;
                --n;
            }
            if (n > 0) {
                while (n > 0) {
                    if (this.hasOptionPrefix(stringArray[n2])) {
                        throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_UNKNOWN_OPTION_ERROR_MSG, new Object[]{stringArray[n2]}));
                    }
                    this.addNonOption(stringArray[n2]);
                    ++n2;
                    --n;
                }
                if (!this.m_bAllowParams) {
                    throw new ParseException(Res.getString(ResIDs.COMMAND_LINE_SPEC_PARAMETERS_NOT_USED_ERROR_MSG));
                }
            } else if (this.m_bRequireParams) {
                throw new ParseException(Res.getString(ResIDs.COMMAND_LINE_SPEC_PARAMETERS_REQUIRED_ERROR_MSG));
            }
            this.anyMissing();
            return true;
        }
        catch (ParseException parseException) {
            this.m_sErrorMsg = parseException.getMessage();
            return false;
        }
    }

    private final void saveOption(Option option, Object object) {
        this.addOptionValue(option, object);
    }

    private final void addNonOption(String string) {
        this.m_Parameters.addElement(string);
    }

    private final void resetParse() {
        this.m_sErrorMsg = null;
        this.clearOptions();
        this.m_Parameters.removeAllElements();
    }

    Option findPossibleOption(String string) {
        Option option = null;
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Option option2 = (Option)e;
            if (!option2.matches(string)) continue;
            option = option2;
            break;
        }
        return option;
    }

    private final void anyMissing() throws ParseException {
        Object object;
        Object object2;
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = (Option)object2;
            if (!((Option)object).isRequired() || this.getOptionValues((Option)object).size() != 0) continue;
            throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_OPTION_REQUIRED_ERROR_MSG, new Object[]{((Option)object).usage()}));
        }
        enumeration = this.getUniqueOptions();
        while (enumeration.hasMoreElements()) {
            object2 = (Option)enumeration.nextElement();
            object = this.getOptionValues((Option)object2);
            int n = ((Vector)object).size();
            if (((Option)object2).minRequired() > n) {
                throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_MULTIPLE_OPTIONS_REQ_ERROR_MSG, new Object[]{((Option)object2).usage()}));
            }
            if (((Option)object2).maxAllowed() >= n) continue;
            throw new ParseException(Res.formatKey(ResIDs.COMMAND_LINE_SPEC_OPTION_OVERUSED_ERROR_MSG, new Object[]{((Option)object2).usage()}));
        }
        object2 = new Vector();
        enumeration = this.getUniqueOptions();
        while (enumeration.hasMoreElements()) {
            object = (Option)enumeration.nextElement();
            Object object3 = ((Option)object).getGroup();
            if (object3 == null) continue;
            if (((Vector)object2).contains(object3)) {
                throw new ParseException(this.makeGroupErrorMsg(object3));
            }
            ((Vector)object2).addElement(object3);
        }
        enumeration = this.getUniqueOptions();
        while (enumeration.hasMoreElements()) {
            object = (Option)enumeration.nextElement();
            Object object4 = ((Option)object).getRequiredGroup();
            if (object4 == null || ((Vector)object2).contains(object4)) continue;
            throw new ParseException(this.makeRequiredGroupErrorMsg((Option)object, object4));
        }
    }

    private String makeRequiredGroupErrorMsg(Option option, Object object) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(option.usage());
        stringBuffer.append(Platform.getEOL());
        stringBuffer.append(Res.getString(ResIDs.COMMAND_LINE_SPEC_OPTION_MUST_BE_USED_ERROR_MSG));
        stringBuffer.append(Platform.getEOL());
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Option option2 = (Option)enumeration.nextElement();
            if (option2.getGroup() != object) continue;
            stringBuffer.append("    ");
            stringBuffer.append(option2.usage());
            stringBuffer.append(Platform.getEOL());
        }
        return stringBuffer.toString();
    }

    private String makeGroupErrorMsg(Object object) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(Res.getString(ResIDs.COMMAND_LINE_SPEC_ONLY_ONE_OPTION_ALLOWED_ERROR_MSG));
        stringBuffer.append(Platform.getEOL());
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            if (option.getGroup() != object) continue;
            stringBuffer.append("    ");
            stringBuffer.append(option.usage());
            stringBuffer.append(Platform.getEOL());
        }
        return stringBuffer.toString();
    }

    private final boolean isOption(String string) {
        if (this.hasOptionPrefix(string)) {
            return this.findPossibleOption(string.substring(1)) != null;
        }
        return false;
    }

    private final boolean hasOptionPrefix(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return c == '-' || c == '/';
    }

    String usage(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string);
        Vector<Option> vector = new Vector<Option>();
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            if (vector.contains(option) || option.getHidden()) continue;
            Object object = option.getGroup();
            if (object == null) {
                stringBuffer.append(ONE_SPACE_STRING);
                if (!option.isRequired()) {
                    stringBuffer.append("[");
                }
                stringBuffer.append(Option.OPTION_PREFIX);
                stringBuffer.append(option.getName());
                if (option.getArgName() != null) {
                    stringBuffer.append(ONE_SPACE_STRING);
                    stringBuffer.append(option.getArgName());
                }
                if (option.isRequired()) continue;
                stringBuffer.append("]");
                continue;
            }
            stringBuffer.append(" [");
            boolean bl = true;
            Enumeration enumeration2 = this.m_OptionList.elements();
            while (enumeration2.hasMoreElements()) {
                Option option2 = (Option)enumeration2.nextElement();
                if (option2.getGroup() != object || vector.contains(option2)) continue;
                if (!bl) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append(Option.OPTION_PREFIX);
                stringBuffer.append(option2.getName());
                if (option2.getArgName() != null) {
                    stringBuffer.append(ONE_SPACE_STRING);
                    stringBuffer.append(option2.getArgName());
                }
                bl = false;
                vector.addElement(option2);
            }
            stringBuffer.append("]");
        }
        if (this.m_bAllowParams) {
            stringBuffer.append(ONE_SPACE_STRING);
            if (!this.m_bRequireParams) {
                stringBuffer.append("[");
            }
            stringBuffer.append(Res.getString(ResIDs.COMMAND_LINE_SPEC_FILES));
            if (!this.m_bRequireParams) {
                stringBuffer.append("]");
            }
        }
        return stringBuffer.toString();
    }

    private String breakLines(String string, int n) {
        StringBuffer stringBuffer;
        block0: {
            stringBuffer = new StringBuffer(string.length());
            int n2 = string.length();
            boolean bl = false;
            String string2 = Platform.getEOL();
            int n3 = string2.length();
            int n4 = this.nextWS(string, 0);
            if (n4 != -1) break block0;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private int nextWS(String string, int n) {
        int n2 = string.length();
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                n3 = n4;
                break;
            }
            ++n4;
        }
        return n3;
    }

    private int addToBuffer(int n, StringBuffer stringBuffer, String string) {
        int n2 = 0;
        if (string.length() + n > 79) {
            stringBuffer.append(Platform.getEOL());
            stringBuffer.append("   ");
            n2 = 4;
        }
        stringBuffer.append(ONE_SPACE_STRING + string);
        n2 = n + string.length() + 1;
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Option option = (Option)e;
            stringBuffer.append("Name: " + option.getName() + " Value: " + option + Platform.getEOL());
        }
        return stringBuffer.toString();
    }

    CommandLineSpec(boolean bl, boolean bl2) {
        this.m_bAllowParams = bl;
        this.m_bRequireParams = bl2;
    }
}

