/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.BuildNumber;
import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.Project;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.commandline.CommandLineQuitException;
import com.starbase.starteam.commandline.CommandLineSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.StatusFilter;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.comm.NetMonitor;
import com.starbase.util.Assert;
import com.starbase.util.FileUtils;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

abstract class CommonCommand {
    private static final String EMPTY_STRING = "";
    static final int RETURN_SUCCESS_CODE = 0;
    static final int RETURN_ERROR_CODE = 1;
    static final int RETURN_ERROR_SOME_UNMATCHED = 101;
    static final int RETURN_ERROR_ALL_UNMATCHED = 102;
    private long _startup = System.currentTimeMillis();
    private long _start = 0L;
    private long _end = 0L;
    private CommandLineSpec _spec = null;
    private Server _Server = null;
    private Project _Project = null;
    private View _View = null;
    protected Folder _Folder = null;
    private String m_username = null;
    private String m_password = null;
    private Label[] m_labels = null;
    protected StarTeamURL _ProjectSpecifier = null;
    private String[] m_unusedSpecs = null;
    private String[] m_fileProps = null;
    private boolean m_anyErrors = false;

    protected boolean getUseSensitiveFileMatching() {
        return true;
    }

    protected final CommandLineSpec getSpec() {
        return this._spec;
    }

    protected final void setSpec(CommandLineSpec commandLineSpec) {
        this._spec = commandLineSpec;
    }

    protected View getView() {
        return this._View;
    }

    protected Server getServer() {
        return this._Server;
    }

    protected final String getProjectSpec() {
        return this.getStringOption("Project");
    }

    protected final boolean showLogo() {
        return !this.getIsOptionOn("NoLogo");
    }

    protected final boolean getCaseSensitiveFolderNames() {
        return this.getIsOptionOn("CaseSensitiveFolders");
    }

    private String defaultHost() {
        return "localhost";
    }

    private String defaultPort() {
        return "1024";
    }

    protected String getHostName() {
        String string = this._ProjectSpecifier.getHostName();
        return string != null ? string : this.defaultHost();
    }

    private String getPortString() {
        String string = this._ProjectSpecifier.getPort();
        return string != null ? string : this.defaultPort();
    }

    private boolean useCompression() {
        return this.getIsOptionOn("Compress");
    }

    private boolean useEncryption() {
        return this.getIsOptionOn("Encrypt");
    }

    private EncryptionAlgorithm getEncryptLevel() {
        if (this.useEncryption()) {
            Object object = this.getOptionObject("Encrypt");
            return (EncryptionAlgorithm)object;
        }
        return null;
    }

    private StatusFilter getStatusFilter() {
        if (this.getIsOptionOn("StatusFilter")) {
            return (StatusFilter)this.getOptionObject("StatusFilter");
        }
        return null;
    }

    protected int getPort() {
        try {
            int n = Integer.parseInt(this.getPortString());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected int getProtocol() {
        return this._ProjectSpecifier.getProtocol();
    }

    private String getProjectName() {
        return this._ProjectSpecifier.getProjectName();
    }

    protected final String getUserName() {
        return this.m_username;
    }

    protected final String getPassword() {
        return this.m_password;
    }

    protected final void resolveUserName() {
        this.m_username = this.decode(this._ProjectSpecifier.getUserName());
        if (this.m_username == null) {
            this.m_username = System.getProperty("user.name");
            if (this.m_username == null) {
                this.m_username = this.promptForUserName();
            }
        }
    }

    protected final void resolvePassword() throws IOException {
        if (this.getIsOptionOn("PasswordFile")) {
            String string = this.getStringOption("PasswordFile");
            this.m_password = this.readPwdFromFile(string);
            return;
        }
        String string = this.decode(this._ProjectSpecifier.getPassword());
        if (string == null) {
            string = this.promptForPassword();
        }
        this.m_password = string;
    }

    private String readPwdFromFile(String string) throws IOException {
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            fileInputStream = new FileInputStream(new java.io.File(string));
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            string2 = bufferedReader.readLine();
            if (string2.length() > 0 && string2.charAt(0) == '\ufeff') {
                string2 = string2.substring(1);
            }
            bufferedReader.close();
            return string2;
        }
        catch (IOException iOException) {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            throw iOException;
        }
    }

    private final boolean getRecurseFolders() {
        return this.getIsOptionOn("Recurse");
    }

    private Date getAsOfDate() {
        if (this.getIsOptionOn("ViewDate")) {
            return this.getTimeOption("ViewDate");
        }
        return null;
    }

    private String getLabelName() {
        return this.getStringOption("ViewLabel");
    }

    private String getPromotionStateName() {
        return this.getStringOption("ViewPromotionState");
    }

    private String getRootPath() throws IOException {
        if (this.getIsOptionOn("Rootpath")) {
            java.io.File file = new java.io.File(this.getStringOption("Rootpath"));
            return file.getCanonicalPath();
        }
        return null;
    }

    private String getFolderOverride() throws IOException {
        if (this.getIsOptionOn("Folderpath")) {
            java.io.File file = new java.io.File(this.getStringOption("Folderpath"));
            return file.getCanonicalPath();
        }
        return null;
    }

    protected boolean showNetMonitor() {
        return this.getIsOptionOn("NetMon");
    }

    protected boolean gatherTiming() {
        return this.getIsOptionOn("Timing");
    }

    protected final boolean showHelp() {
        return this.getIsOptionOn("Help?") || this.getIsOptionOn("Helphelp") || this.getIsOptionOn("Helph");
    }

    private final boolean getShowProgess() {
        return !this.getIsOptionOn("Quiet");
    }

    private final boolean getBypassErrors() {
        return this.getIsOptionOn("BypassErrors");
    }

    private final boolean getStopOnError() {
        return this.getIsOptionOn("StopOnError");
    }

    private final String[] getUserFileList() {
        String[] stringArray = this._spec.getParameters();
        if (stringArray.length == 0 && this.treatNoFilesAsAll()) {
            stringArray = new String[]{this.getStarDotStar()};
        }
        return stringArray;
    }

    protected final void cacheUnusedUserFileList() {
        String[] stringArray = this._spec.getParameters();
        this.m_unusedSpecs = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.m_unusedSpecs, 0, stringArray.length);
    }

    private void reportUnmatchedFiles() throws IOException {
        int n = 0;
        while (n < this.m_unusedSpecs.length) {
            String string = this.m_unusedSpecs[n];
            if (string != null) {
                if (this.iterateOnLocalFiles() && this.iterateOnServerFiles()) {
                    this.message(Res.formatKey(ResIDs.COMMON_COMMAND_LOCAL_SERVER_UNMATCHED_FILES_ERROR_MSG, new Object[]{string}));
                } else if (this.iterateOnLocalFiles() && !this.iterateOnServerFiles()) {
                    this.message(Res.formatKey(ResIDs.COMMON_COMMAND_LOCAL_UNMATCHED_FILES_ERROR_MSG, new Object[]{string}));
                } else if (!this.iterateOnLocalFiles() && this.iterateOnServerFiles()) {
                    this.message(Res.formatKey(ResIDs.COMMON_COMMAND_SERVER_UNMATCHED_FILES_ERROR_MSG, new Object[]{string}));
                } else {
                    this.message(Res.formatKey(ResIDs.COMMON_COMMAND_UNMATCHED_FILES_ERROR_MSG, new Object[]{string}));
                }
            }
            ++n;
        }
    }

    private boolean allUnmatched() {
        if (this.m_unusedSpecs.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.m_unusedSpecs.length) {
            String string = this.m_unusedSpecs[n];
            if (string == null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean anyUnmatched() {
        int n = 0;
        while (n < this.m_unusedSpecs.length) {
            String string = this.m_unusedSpecs[n];
            if (string != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String promptForUserName() {
        System.err.print(Res.getString(ResIDs.COMMON_COMMAND_ENTER_USERNAME_MSG));
        System.err.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String promptForPassword() {
        System.err.println(Res.formatKey(ResIDs.COMMON_COMMAND_PASSWORD_REQUIRED_MSG, new Object[]{this.m_username}));
        PasswordMaskingThread passwordMaskingThread = new PasswordMaskingThread();
        try {
            try {
                String string;
                passwordMaskingThread.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string2 = string = bufferedReader.readLine();
                Object var3_7 = null;
                passwordMaskingThread.quit();
                return string2;
            }
            catch (IOException iOException) {
                String string = null;
                Object var3_8 = null;
                passwordMaskingThread.quit();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            passwordMaskingThread.quit();
            throw throwable;
        }
    }

    private boolean validResponse(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        String string3 = Res.getString(ResIDs.COMMON_COMAND_OK_RESPONSE).toLowerCase();
        String string4 = Res.getString(ResIDs.COMMON_COMMAND_CANCEL_RESPONSE).toLowerCase();
        if (string2.length() == 0) {
            return true;
        }
        if (string3.startsWith(string2) && this.isUnique(string, new String[]{string3, string4})) {
            return true;
        }
        return string4.startsWith(string2) && this.isUnique(string, new String[]{string3, string4});
    }

    private boolean isQuit(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        String string3 = Res.getString(ResIDs.COMMON_COMAND_OK_RESPONSE).toLowerCase();
        String string4 = Res.getString(ResIDs.COMMON_COMMAND_CANCEL_RESPONSE).toLowerCase();
        if (string2.length() == 0) {
            return false;
        }
        return string4.startsWith(string2) && this.isUnique(string, new String[]{string3, string4});
    }

    protected boolean confirm(String string) throws IOException {
        return this.confirm(string, null);
    }

    protected boolean confirm(String string, Throwable throwable) throws IOException {
        this.m_anyErrors = true;
        boolean bl = false;
        if (!this.getBypassErrors()) {
            System.err.println(string);
            System.err.print(Res.getString(ResIDs.COMMON_COMMAND_OK_CANCEL_CONFIRM_DISPLAY));
            System.err.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = null;
            while (!this.validResponse(string2)) {
                if (string2 != null) {
                    System.err.println(Res.formatKey(ResIDs.COMMON_COMMAND_INVALID_RESPONSE_ERROR_MSG, new Object[]{string2}));
                    System.err.print(Res.getString(ResIDs.COMMON_COMMAND_OK_CANCEL_CONFIRM_DISPLAY));
                    System.err.flush();
                }
                if (!(string2 = bufferedReader.readLine()).startsWith("p") || throwable == null) continue;
                throwable.printStackTrace();
            }
            if (this.isQuit(string2)) {
                bl = true;
            }
        } else {
            System.err.println(string);
            if (this.getStopOnError()) {
                bl = true;
            }
        }
        if (bl) {
            throw new CommandLineQuitException();
        }
        return bl;
    }

    protected boolean prompt(String string) throws IOException {
        System.err.println(string);
        String string2 = Res.getString(ResIDs.COMMON_COMMAND_YES_NO_CANCEL_CONFIRM_DISPLAY);
        System.err.print(string2);
        System.err.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string3 = null;
        while (!this.isYesNoCancel(string3)) {
            if (string3 != null) {
                System.err.println(Res.formatKey(ResIDs.COMMON_COMMAND_INVALID_RESPONSE_ERROR_MSG, new Object[]{string3}));
                System.err.print(string2);
                System.err.flush();
            }
            string3 = bufferedReader.readLine();
        }
        return this.isYes(string3);
    }

    private boolean isUnique(String string, String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(string)) {
                if (bl) {
                    return false;
                }
                bl = true;
            }
            ++n;
        }
        return true;
    }

    private boolean isYes(String string) {
        String string2 = string.toLowerCase();
        String string3 = Res.getString(ResIDs.COMMON_COMMAND_YES_RESPONSE).toLowerCase();
        String string4 = Res.getString(ResIDs.COMMON_COMMAND_NO_RESPONSE).toLowerCase();
        String string5 = Res.getString(ResIDs.COMMON_COMMAND_CANCEL_RESPONSE).toLowerCase();
        if (string2.length() == 0) {
            return false;
        }
        if (string3.startsWith(string2) && this.isUnique(string, new String[]{string3, string4, string5})) {
            return true;
        }
        if (string4.startsWith(string2) && this.isUnique(string, new String[]{string3, string4, string5})) {
            return false;
        }
        throw new CommandLineQuitException();
    }

    private boolean isYesNoCancel(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        String string3 = Res.getString(ResIDs.COMMON_COMMAND_YES_RESPONSE).toLowerCase();
        String string4 = Res.getString(ResIDs.COMMON_COMMAND_NO_RESPONSE).toLowerCase();
        String string5 = Res.getString(ResIDs.COMMON_COMMAND_CANCEL_RESPONSE).toLowerCase();
        if (string2.length() == 0) {
            return true;
        }
        if (string3.startsWith(string2) && this.isUnique(string, new String[]{string3, string4, string5})) {
            return true;
        }
        if (string4.startsWith(string2) && this.isUnique(string, new String[]{string3, string4, string5})) {
            return true;
        }
        return string5.startsWith(string2) && this.isUnique(string, new String[]{string3, string4, string5});
    }

    protected Label findLabel(String string) throws IOException {
        if (this.m_labels == null) {
            this.m_labels = this._View.getActiveLabels();
        }
        int n = 0;
        while (n < this.m_labels.length) {
            Label label = this.m_labels[n];
            if (!label.isDeleted() && string.equalsIgnoreCase(label.getName())) {
                return label;
            }
            ++n;
        }
        return null;
    }

    protected PromotionState findPromotionState(String string) throws IOException {
        PromotionState[] promotionStateArray = this._View.getPromotionModel().getPromotionStates();
        int n = 0;
        while (n < promotionStateArray.length) {
            PromotionState promotionState = promotionStateArray[n];
            if (promotionState.getName().equalsIgnoreCase(string)) {
                return promotionState;
            }
            ++n;
        }
        return null;
    }

    protected final boolean reportError(Throwable throwable) throws IOException {
        System.err.println(Res.getString(ResIDs.COMMON_COMMAND_ERROR_OCCURRED_MSG));
        String string = throwable.getMessage();
        if (string != null) {
            System.err.println(string);
        } else {
            System.err.println(throwable);
        }
        return this.confirm(EMPTY_STRING, throwable);
    }

    protected final int runCommand(String[] stringArray) throws IOException {
        int n = this.runCommandImpl(stringArray);
        try {
            if (this._Server != null) {
                this._Server.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    protected boolean parseArguments(String[] stringArray) {
        return this.getSpec().parse(stringArray);
    }

    protected int runCommandImpl(String[] stringArray) throws IOException {
        try {
            boolean bl = this.parseArguments(stringArray);
            if (this.showLogo()) {
                CommonCommand.printStartupMsg();
            }
            if (this.showHelp()) {
                this.showUsage();
                return 0;
            }
            if (this.showNetMonitor()) {
                NetMonitor.onConsole();
            }
            if (!bl) {
                this.reportBadOptions(this.getSpec().errorMessage());
                return 1;
            }
            this.cacheUnusedUserFileList();
            this._ProjectSpecifier = new StarTeamURL(this.getProjectSpec());
            if (this._ProjectSpecifier.getProjectName() == null) {
                this.confirm(Res.formatKey(ResIDs.COMMON_COMMAND_NO_PROJECT_SPECIFIED_ERROR_MSG, new Object[]{this.getProjectSpec()}));
                return 1;
            }
            this.resolveUserName();
            this.resolvePassword();
            boolean bl2 = this.openServer();
            if (!bl2) {
                this.confirm(Res.formatKey(ResIDs.UNABLE_TO_CONNECT_ERROR_MSG, new Object[]{this.getHostName(), new Integer(this.getPort())}), null);
                return 1;
            }
            this._Server.logOn(this.m_username, this.m_password);
            this._Project = this.findProject();
            if (this._Project == null) {
                this.confirm(Res.formatKey(ResIDs.COMMON_COMMAND_PROJECT_NOT_FOUND_ERROR_MSG, new Object[]{this.getProjectName()}), null);
                return 1;
            }
            this._Folder = this.findFolder();
            if (this._Folder == null) {
                return 1;
            }
            String string = this.getFolderOverride();
            String string2 = this.getRootPath();
            if (string != null) {
                this._Folder.setAlternatePathFragment(string);
            } else if (string2 != null) {
                this._View.getRootFolder().setAlternatePathFragment(string2);
            }
            this.cacheFileProperties();
            this.preOperation();
            this.processEachFile();
            this.postOperation();
            this._end = System.currentTimeMillis();
            if (this.gatherTiming()) {
                System.out.println(EMPTY_STRING);
                System.out.println("Startup time: " + (this._start - this._startup) + "ms");
                System.out.println("Operation time  : " + (this._end - this._start) + "ms");
            }
            this.reportUnmatchedFiles();
            this._Server.disconnect();
            int n = 0;
            if (this.m_anyErrors) {
                n = 1;
            } else if (this.allUnmatched()) {
                n = 102;
            } else if (this.anyUnmatched()) {
                n = 101;
            }
            return n;
        }
        catch (CommandLineQuitException commandLineQuitException) {
            return 1;
        }
        catch (Throwable throwable) {
            this.reportError(throwable);
            NetMonitor.kill();
            try {
                if (this._Server != null) {
                    this._Server.disconnect();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return 1;
        }
    }

    boolean matchAny(String string, String[] stringArray, boolean bl) throws IOException {
        boolean bl2 = false;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n && !bl2) {
            bl2 = this.matchOne(string, stringArray[n2], bl);
            ++n2;
        }
        return bl2;
    }

    boolean matchOne(String string, String string2, boolean bl) throws IOException {
        return FileUtils.match(string2, string, bl);
    }

    private void cacheFileProperties() {
        PropertyNames propertyNames = this._Server.getPropertyNames();
        Property[] propertyArray = this._Server.typeForName(this._Server.getTypeNames().FILE).getProperties();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (!property.isClientCalculated() && !propertyNames.COMMENT.equals(property.getName())) {
                vector.addElement(property.getName());
            }
            ++n;
        }
        this.m_fileProps = new String[vector.size()];
        vector.copyInto(this.m_fileProps);
    }

    String name() {
        return this.getClass().getName();
    }

    abstract int run(String[] var1) throws IOException;

    protected void preOperation() throws IOException {
    }

    protected void postOperation() throws IOException {
    }

    protected void reportFolder(Folder folder) throws IOException {
    }

    String description() {
        return null;
    }

    abstract boolean iterateOnLocalFiles();

    abstract boolean iterateOnServerFiles();

    abstract boolean ignoreUserFileList();

    abstract void processOneFile(Folder var1, File var2) throws IOException;

    abstract void processLocalFile(Folder var1, String var2) throws IOException;

    abstract void processNoFiles() throws IOException;

    abstract boolean treatNoFilesAsAll();

    String getStarDotStar() {
        return "*";
    }

    private Vector getAllServerFiles(Folder folder) throws IOException {
        Vector<File> vector = new Vector<File>();
        folder.populateNow(folder.getTypeNames().FILE, this.m_fileProps, 0);
        Enumeration enumeration = null;
        enumeration = folder.enumerateItems(folder.getTypeNames().FILE);
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            vector.addElement(file);
        }
        return vector;
    }

    private Vector getAllLocalFiles(Folder folder) throws IOException {
        File[] fileArray = folder.getNotInViewFiles();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < fileArray.length) {
            vector.addElement(fileArray[n].getName());
            ++n;
        }
        return vector;
    }

    private void recordAnyUnmatched(Vector vector, boolean bl) throws IOException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = null;
            if (e instanceof String) {
                string = (String)e;
            } else if (e instanceof File) {
                string = ((File)e).getName();
            }
            if (string == null) continue;
            int n = 0;
            while (n < this.m_unusedSpecs.length) {
                String string2 = this.m_unusedSpecs[n];
                if (string2 != null && this.matchOne(string, string2, bl)) {
                    this.m_unusedSpecs[n] = null;
                }
                ++n;
            }
        }
    }

    private Vector onlyMatching(Vector vector, String[] stringArray, boolean bl) throws IOException {
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = null;
            if (e instanceof String) {
                string = (String)e;
            } else if (e instanceof File) {
                string = ((File)e).getName();
            }
            if (string == null || !this.matchAny(string, stringArray, bl)) continue;
            vector2.addElement(e);
        }
        return vector2;
    }

    void showFolderInfo(Folder folder) {
        this.message(Res.formatKey(ResIDs.FOLDER_INFORMATION_MSG, new Object[]{folder.getName(), folder.getPath()}));
    }

    void processFolder(Folder folder, boolean bl) throws IOException {
        Enumeration enumeration;
        this.showFolderInfo(folder);
        boolean bl2 = folder.getServer().getClientContext().getCaseSensitiveFileNames();
        Vector vector = this.getAllServerFiles(folder);
        Vector vector2 = this.getAllLocalFiles(folder);
        Vector vector3 = this.onlyMatching(vector, this.getUserFileList(), bl2);
        Vector vector4 = this.onlyMatching(vector2, this.getUserFileList(), bl2);
        StatusFilter statusFilter = this.getStatusFilter();
        if (this._start == 0L) {
            this._start = System.currentTimeMillis();
            if (this.gatherTiming()) {
                System.out.println("Startup time: " + (this._start - this._startup) + "ms");
            }
        }
        if (this.iterateOnServerFiles()) {
            this.recordAnyUnmatched(vector, bl2);
            enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                try {
                    boolean bl3 = true;
                    if (statusFilter != null && !statusFilter.isMatch(file.getStatus())) {
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    this.processOneFile(folder, file);
                }
                catch (CommandLineQuitException commandLineQuitException) {
                    throw commandLineQuitException;
                }
                catch (Throwable throwable) {
                    this.reportError(throwable);
                }
            }
        }
        boolean bl4 = true;
        if (statusFilter != null && !statusFilter.isMatch(4)) {
            bl4 = false;
        }
        if (this.iterateOnLocalFiles()) {
            this.recordAnyUnmatched(vector2, bl2);
            enumeration = vector4.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    if (!bl4) continue;
                    this.processLocalFile(folder, string);
                }
                catch (CommandLineQuitException commandLineQuitException) {
                    throw commandLineQuitException;
                }
                catch (Throwable throwable) {
                    this.reportError(throwable);
                }
            }
        }
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            this.reportFolder(folderArray[n]);
            ++n;
        }
        folder.discardItems(folder.getTypeNames().FILE, 0);
        if (bl) {
            folderArray = folder.getSubFolders();
            n = 0;
            while (n < folderArray.length) {
                this.processFolder(folderArray[n], bl);
                ++n;
            }
        }
    }

    void processEachFile() throws IOException {
        String[] stringArray = this.getUserFileList();
        int n = stringArray.length;
        if (n == 0) {
            this.processNoFiles();
        } else {
            this.processFolder(this._Folder, this.getRecurseFolders());
        }
    }

    protected void showUsage() {
        System.err.println(EMPTY_STRING);
        System.err.println(Res.formatKey(ResIDs.COMMON_COMMAND_STARTEAM_USAGE_DISPLAY, new Object[]{BuildNumber.currentRelease(), this.description()}));
        System.err.println(EMPTY_STRING);
        System.err.println(Res.formatKey(ResIDs.COMMON_COMMAND_COMMAND_USAGE_DISPLAY, new Object[]{"stcmd", this.name(), "-?"}));
        System.err.println(EMPTY_STRING);
        String string = "  stcmd " + this.name();
        System.err.println(this.getSpec().usage(string));
        System.err.println(EMPTY_STRING);
        System.err.println(this.getSpec().getOptions());
    }

    protected final boolean openServer() throws IOException {
        String string = this.getProjectSpec();
        int n = this.getPort();
        if (n == -1) {
            throw new IOException(Res.formatKey(ResIDs.COMMON_COMMAND_BAD_PORT_SPECIFIED_ERROR_MSG, new Object[]{string}));
        }
        EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.NULL;
        if (this.useEncryption()) {
            encryptionAlgorithm = this.getEncryptLevel();
        }
        this._Server = new Server(this.getHostName(), n, encryptionAlgorithm, this.useCompression(), this.getProtocol());
        this._Server.connect();
        return true;
    }

    private final Project findProject() throws IOException {
        String string = this.decode(this.getProjectName());
        if (string != null) {
            Project project = null;
            Project[] projectArray = this._Server.getProjects();
            int n = 0;
            while (n < projectArray.length) {
                project = projectArray[n];
                if (project.getName().equalsIgnoreCase(string)) {
                    return project;
                }
                ++n;
            }
            return null;
        }
        throw new IOException(Res.getString(ResIDs.COMMON_COMMAND_NO_PROJECT_NAME_SPECIFIED_ERROR_MSG));
    }

    private void setViewConfig(View view) throws IOException {
        Date date = this.getAsOfDate();
        if (date != null) {
            OLEDate oLEDate = new OLEDate(date.getTime());
            this._View = new View(view, ViewConfiguration.createFromTime(oLEDate));
            return;
        }
        String string = this.getLabelName();
        if (string != null) {
            Label label = this.findLabel(string);
            this.m_labels = null;
            if (label == null) {
                throw new IOException(Res.formatKey(ResIDs.COMMON_COMMAND_LABEL_NOT_FOUND_ERROR_MSG, new Object[]{string}));
            }
            this._View = new View(view, ViewConfiguration.createFromLabel(label.getID()));
            return;
        }
        string = this.getPromotionStateName();
        if (string != null) {
            PromotionState promotionState = this.findPromotionState(string);
            if (promotionState == null) {
                throw new IOException(Res.formatKey(ResIDs.COMMON_COMMAND_PROMOTION_STATE_NOT_FOUND_ERROR_MSG, new Object[]{string}));
            }
            this._View = new View(view, ViewConfiguration.createFromPromotionState(promotionState.getObjectID()));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Folder findFolder() throws IOException {
        Object object;
        Object object2;
        View[] viewArray = this._Project.getViews();
        StringTokenizer stringTokenizer = this._ProjectSpecifier.getFolders();
        String string = null;
        this._View = null;
        if (!stringTokenizer.hasMoreElements()) {
            if (viewArray.length <= 0) throw new IOException(Res.formatKey(ResIDs.COMMON_COMMAND_PROJECT_HAS_NO_VIEWS_ERROR_MSG, new Object[]{this._Project.getName()}));
            this._View = viewArray[0];
        } else {
            Object object3;
            string = (String)stringTokenizer.nextElement();
            this._View = null;
            object2 = null;
            if (string.indexOf(58) != -1) {
                object = new StringTokenizer(string, ":");
                object3 = new View[]{this._Project.getDefaultView()};
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = this.decode(((StringTokenizer)object).nextToken());
                    boolean bl = false;
                    int n = 0;
                    while (n < ((Object)object3).length) {
                        if (string2.equalsIgnoreCase(((View)object3[n]).getName())) {
                            this._View = object3[n];
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        StringBuffer stringBuffer = new StringBuffer();
                        String string3 = Platform.getEOL();
                        stringBuffer.append(Res.formatKey(ResIDs.COMMON_COMMAND_VIEW_NOT_FOUND_ERROR_MSG, new Object[]{string2}));
                        stringBuffer.append(string3);
                        stringBuffer.append(Res.getString(ResIDs.COMMON_COMMAND_POSSIBLE_VIEWS_MSG));
                        stringBuffer.append(string3);
                        int n2 = 0;
                        while (n2 < ((Object)object3).length) {
                            stringBuffer.append(Res.formatKey(ResIDs.COMMON_COMMAND_VIEW_DISPLAY, new Object[]{((View)object3[n2]).getName()}));
                            stringBuffer.append(string3);
                            ++n2;
                        }
                        throw new IOException(stringBuffer.toString());
                    }
                    object3 = this._View.getDerivedViews();
                }
            } else {
                string = this.decode(string);
                int n = 0;
                while (n < viewArray.length) {
                    object3 = viewArray[n];
                    if (object2 == null) {
                        object2 = object3;
                    }
                    if (((View)object3).getName().equalsIgnoreCase(string)) {
                        this._View = object3;
                        break;
                    }
                    ++n;
                }
                if (this._View == null) {
                    this._View = object2;
                    stringTokenizer = this._ProjectSpecifier.getFolders();
                }
            }
        }
        if (this._View == null) {
            object2 = new StringBuffer();
            object = Platform.getEOL();
            ((StringBuffer)object2).append(Res.formatKey(ResIDs.COMMON_COMMAND_VIEW_NOT_FOUND_ERROR_MSG, new Object[]{string}));
            ((StringBuffer)object2).append((String)object);
            ((StringBuffer)object2).append(Res.getString(ResIDs.COMMON_COMMAND_POSSIBLE_VIEWS_MSG));
            ((StringBuffer)object2).append((String)object);
            viewArray = this._Project.getViews();
            int n = 0;
            while (n < viewArray.length) {
                ((StringBuffer)object2).append(Res.formatKey(ResIDs.COMMON_COMMAND_VIEW_DISPLAY, new Object[]{viewArray[n].getName()}));
                ((StringBuffer)object2).append((String)object);
                ++n;
            }
            throw new IOException(((StringBuffer)object2).toString());
        }
        this.setViewConfig(this._View);
        return this.findFolder(this._View.getRootFolder(), stringTokenizer);
    }

    protected final Folder findFolder(Folder folder, Enumeration enumeration) throws IOException {
        if (!enumeration.hasMoreElements()) {
            return folder;
        }
        String string = (String)enumeration.nextElement();
        Folder folder2 = this.findSubFolder(folder, string = this.decode(string));
        if (folder2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = Platform.getEOL();
            stringBuffer.append(Res.formatKey(ResIDs.COMMON_COMMAND_SUBFOLDER_NOT_FOUND_ERROR_MSG, new Object[]{string, folder.getFolderHierarchy()}));
            stringBuffer.append(string2);
            stringBuffer.append(Res.getString(ResIDs.COMMON_COMMAND_EXISTING_SUBFOLDERS_MSG));
            stringBuffer.append(string2);
            Folder[] folderArray = folder.getSubFolders();
            int n = 0;
            while (n < folderArray.length) {
                stringBuffer.append(Res.formatKey(ResIDs.COMMON_COMMAND_SUBFOLDER_DISPLAY, new Object[]{folderArray[n].getName()}));
                stringBuffer.append(string2);
                ++n;
            }
            throw new IOException(stringBuffer.toString());
        }
        return this.findFolder(folder2, enumeration);
    }

    private Folder findSubFolder(Folder folder, String string) throws IOException {
        Folder[] folderArray = folder.getSubFolders();
        Folder folder2 = null;
        int n = 0;
        while (n < folderArray.length) {
            if (this.folderNameMatch(folderArray[n], string)) {
                if (folder2 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = Platform.getEOL();
                    stringBuffer.append(Res.formatKey(ResIDs.COMMON_COMMAND_AMBIGUOUS_SUBFOLDER_REFERENCE_ERROR_MSG, new Object[]{string, folder.getFolderHierarchy()}));
                    stringBuffer.append(string2);
                    stringBuffer.append(Res.getString(ResIDs.COMMON_COMMAND_EXISTING_SUBFOLDERS_MSG));
                    stringBuffer.append(string2);
                    Folder[] folderArray2 = folder.getSubFolders();
                    int n2 = 0;
                    while (n2 < folderArray2.length) {
                        stringBuffer.append(Res.formatKey(ResIDs.COMMON_COMMAND_SUBFOLDER_DISPLAY, new Object[]{folderArray2[n2].getName()}));
                        stringBuffer.append(string2);
                        ++n2;
                    }
                    throw new IOException(stringBuffer.toString());
                }
                folder2 = folderArray[n];
            }
            ++n;
        }
        return folder2;
    }

    protected boolean folderNameMatch(Folder folder, String string) {
        if (this.getCaseSensitiveFolderNames()) {
            return string.equals(folder.getName());
        }
        return string.equalsIgnoreCase(folder.getName());
    }

    private String decode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '%') {
                if (n > string.length() - 3) {
                    throw new IllegalArgumentException(Res.formatKey(ResIDs.COMMON_COMMAND_ILLEGAL_ENCODING_ERROR_MSG, new Object[]{string}));
                }
                try {
                    byte by = Byte.parseByte(string.substring(n + 1, n + 3), 16);
                    stringBuffer.append((char)(by & 0xFF));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(Res.formatKey(ResIDs.COMMON_COMMAND_ILLEGAL_ENCODING_ERROR_MSG, new Object[]{string}));
                }
                n += 2;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String getAppDescription() {
        return Res.formatKey(ResIDs.COMMON_COMMAND_STARTUP_MSG, new Object[]{BuildNumber.currentRelease(), BuildNumber.currentBuild()});
    }

    static void printStartupMsg() {
        System.out.println(CommonCommand.getAppDescription());
        System.out.println(Res.getString(ResIDs.COMMON_COMMAND_COPYRIGHT_MSG));
        String string = Platform.getWSOptions().locationMsg();
        if (string != null) {
            System.out.println(string);
        }
    }

    protected void reportBadOptions(String string) {
        System.err.println(EMPTY_STRING);
        System.err.println(Res.getString(ResIDs.COMMON_COMMAND_INVALID_COMMAND_LINE_SPEC_ERROR_MSG));
        System.err.println(string);
        System.err.println(EMPTY_STRING);
        System.err.println(EMPTY_STRING);
        this.showUsage();
    }

    void message(String string) {
        if (this.getShowProgess()) {
            System.out.println(string);
        }
    }

    protected String getStringOption(String string) {
        Object object = this.getOptionObject(string);
        return (String)object;
    }

    protected int getIntegerOption(String string) {
        Object object = this.getOptionObject(string);
        Integer n = (Integer)object;
        return n;
    }

    protected boolean getBooleanOption(String string) {
        Object object = this.getOptionObject(string);
        Boolean bl = (Boolean)object;
        return bl;
    }

    protected Date getTimeOption(String string) {
        Object object = this.getOptionObject(string);
        return (Date)object;
    }

    protected boolean getIsOptionOn(String string) {
        String string2 = Option.getName(string);
        Option option = this.getSpec().findSpecifiedOption(string2);
        return option != null;
    }

    protected String[] getStringOptionList(String string) {
        String string2 = Option.getName(string);
        Option option = this.getSpec().findSpecifiedOption(string2);
        String[] stringArray = null;
        if (option != null) {
            Vector vector = this.getSpec().getOptionValues(option);
            if (vector == null) {
                stringArray = new String[]{};
            } else {
                int n = vector.size();
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
            }
        }
        return stringArray;
    }

    protected Object getOptionObject(String string) {
        Object e;
        String string2 = Option.getName(string);
        Option option = this.getSpec().findSpecifiedOption(string2);
        if (option == null) {
            return null;
        }
        Vector vector = this.getSpec().getOptionValues(option);
        if (vector == null) {
            Assert.internalError("CommonCommand.getOptionObject(),keyName=" + string + ",opname=" + string2);
        }
        if (vector.size() != 1) {
            Assert.internalError("CommonCommand.getOptionObject(),keyName=" + string + ",opname=" + string2 + ",vector size=" + vector.size());
        }
        if ((e = vector.elementAt(0)) == null) {
            Assert.internalError("CommonCommand.getOptionObject(),keyName=" + string + ",opname=" + string2);
        }
        return e;
    }

    CommonCommand() {
    }

    private static class PasswordMaskingThread
    extends Thread {
        private boolean stop = false;

        public void run() {
            Object object = new Object();
            String string = "\r" + Res.getString(ResIDs.COMMON_COMMAND_PASSWORD_DISPLAY) + "                    \r" + Res.getString(ResIDs.COMMON_COMMAND_PASSWORD_DISPLAY);
            Object object2 = object;
            synchronized (object2) {
                while (!this.stop) {
                    try {
                        object.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.stop) {
                        System.err.print(string);
                    }
                    System.err.flush();
                }
            }
        }

        public void quit() {
            this.stop = true;
        }

        PasswordMaskingThread() {
        }
    }
}

