/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Assert;
import java.io.IOException;

class DeleteLocalFiles
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.DELETE_LOCAL_FILES_DESCRIPTION);
    }

    String name() {
        return "delete-local";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return true;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        java.io.File file = new java.io.File(folder.getPath(), string);
        if (file.delete()) {
            this.message(Res.formatKey(ResIDs.DELETE_LOCAL_FILES_DELETED_MSG, new Object[]{string}));
        } else {
            this.message(Res.formatKey(ResIDs.DELETE_LOCAL_FILES_UNABLE_TO_DELETE_MSG, new Object[]{string}));
        }
    }

    void processOneFile(Folder folder, File file) throws IOException {
        java.io.File file2 = new java.io.File(file.getFullName());
        boolean bl = file.deleteLocalFile(file2);
        if (bl) {
            this.message(Res.formatKey(ResIDs.DELETE_LOCAL_FILES_DELETED_MSG, new Object[]{file.getName()}));
        } else {
            this.message(Res.formatKey(ResIDs.DELETE_LOCAL_FILES_UNABLE_TO_DELETE_MSG, new Object[]{file.getName()}));
        }
    }

    void processNoFiles() {
        Assert.internalError("DeleteLocalFiles.processNoFiles()");
    }

    DeleteLocalFiles() {
    }
}

