/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.BuildNumber;
import com.starbase.starteam.ClientApplication;
import com.starbase.starteam.commandline.Add;
import com.starbase.starteam.commandline.AddFolder;
import com.starbase.starteam.commandline.AddProject;
import com.starbase.starteam.commandline.AddView;
import com.starbase.starteam.commandline.ApplyLabel;
import com.starbase.starteam.commandline.CheckIn;
import com.starbase.starteam.commandline.CheckOut;
import com.starbase.starteam.commandline.ClientStatus;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CreateLabel;
import com.starbase.starteam.commandline.DeleteLocalFiles;
import com.starbase.starteam.commandline.Description;
import com.starbase.starteam.commandline.Diff;
import com.starbase.starteam.commandline.History;
import com.starbase.starteam.commandline.List;
import com.starbase.starteam.commandline.Lock;
import com.starbase.starteam.commandline.MakeDirs;
import com.starbase.starteam.commandline.PersonalOptions;
import com.starbase.starteam.commandline.Remove;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.SetServerMode;
import com.starbase.starteam.commandline.UpdateStatus;
import java.io.IOException;

class Wrapper {
    private static final String APP_NAME = "stcmd";
    private static final String[] m_AllCommands = new String[]{"add", "add-folder", "add-project", "add-view", "apply-label", "ci", "co", "delete-local", "diff", "dsc", "hist", "label", "lck", "list", "local-mkdir", "move-status", "remove", "server-mode", "set-personal-options", "update-status"};

    static int main(String[] stringArray) throws IOException {
        ClientApplication.setName(CommonCommand.getAppDescription());
        int n = 1;
        if (stringArray.length == 0) {
            Wrapper.usage();
        } else {
            String string = stringArray[0].toLowerCase();
            int n2 = stringArray.length;
            String[] stringArray2 = new String[n2 - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, n2 - 1);
            CommonCommand commonCommand = null;
            if (string.equals("add")) {
                commonCommand = new Add();
            } else if (string.equals("add-folder")) {
                commonCommand = new AddFolder();
            } else if (string.equals("add-project")) {
                commonCommand = new AddProject();
            } else if (string.equals("add-view")) {
                commonCommand = new AddView();
            } else if (string.equals("apply-label")) {
                commonCommand = new ApplyLabel();
            } else if (string.equals("ci")) {
                commonCommand = new CheckIn();
            } else if (string.equals("co")) {
                commonCommand = new CheckOut();
            } else if (string.equals("diff")) {
                commonCommand = new Diff();
            } else if (string.equals("dsc")) {
                commonCommand = new Description();
            } else if (string.equals("hist")) {
                commonCommand = new History();
            } else if (string.equals("label")) {
                commonCommand = new CreateLabel();
            } else if (string.equals("lck")) {
                commonCommand = new Lock();
            } else if (string.equals("list")) {
                commonCommand = new List();
            } else if (string.equals("local-mkdir")) {
                commonCommand = new MakeDirs();
            } else if (string.equals("servermode")) {
                commonCommand = new SetServerMode();
            } else if (string.equals("server-mode")) {
                commonCommand = new SetServerMode();
            } else if (string.equals("delete-local")) {
                commonCommand = new DeleteLocalFiles();
            } else if (string.equals("update-status")) {
                commonCommand = new UpdateStatus();
            } else if (string.equals("remove")) {
                commonCommand = new Remove();
            } else if (string.equals("move-status")) {
                commonCommand = new ClientStatus();
            } else if (string.equals("set-personal-options")) {
                commonCommand = new PersonalOptions();
            } else {
                Wrapper.usage();
            }
            if (commonCommand != null) {
                n = ((CommonCommand)commonCommand).run(stringArray2);
            }
        }
        return n;
    }

    private static String description(String string) {
        if (string.equals("add")) {
            return new Add().description();
        }
        if (string.equals("add-folder")) {
            return new AddFolder().description();
        }
        if (string.equals("add-project")) {
            return new AddProject().description();
        }
        if (string.equals("add-view")) {
            return new AddView().description();
        }
        if (string.equals("apply-label")) {
            return new ApplyLabel().description();
        }
        if (string.equals("ci")) {
            return new CheckIn().description();
        }
        if (string.equals("co")) {
            return new CheckOut().description();
        }
        if (string.equals("diff")) {
            return new Diff().description();
        }
        if (string.equals("dsc")) {
            return new Description().description();
        }
        if (string.equals("hist")) {
            return new History().description();
        }
        if (string.equals("label")) {
            return new CreateLabel().description();
        }
        if (string.equals("lck")) {
            return new Lock().description();
        }
        if (string.equals("list")) {
            return new List().description();
        }
        if (string.equals("local-mkdir")) {
            return new MakeDirs().description();
        }
        if (string.equals("remove")) {
            return new Remove().description();
        }
        if (string.equals("servermode")) {
            return new SetServerMode().description();
        }
        if (string.equals("server-mode")) {
            return new SetServerMode().description();
        }
        if (string.equals("delete-local")) {
            return new DeleteLocalFiles().description();
        }
        if (string.equals("update-status")) {
            return new UpdateStatus().description();
        }
        if (string.equals("move-status")) {
            return new ClientStatus().description();
        }
        if (string.equals("set-personal-options")) {
            return new PersonalOptions().description();
        }
        return Res.getString(ResIDs.NOT_IMPLEMENTED);
    }

    private static void usage() {
        CommonCommand.printStartupMsg();
        System.out.println("");
        System.out.println(Res.formatKey(ResIDs.USAGE_VERSION_INFO_MSG, new Object[]{BuildNumber.currentRelease()}));
        System.out.println("");
        System.out.println(Res.formatKey(ResIDs.USAGE_HELP_MSG, new Object[]{APP_NAME}));
        System.out.println("");
        int n = 0;
        while (n < m_AllCommands.length) {
            String string = m_AllCommands[n];
            System.out.println(Res.formatKey(ResIDs.USAGE_CMD_HELP_MSG, new Object[]{APP_NAME, string, Wrapper.description(string)}));
            ++n;
        }
    }

    Wrapper() {
    }
}

