/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final byte[] base64idx = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private InputStream m_wrappedStream = null;
    private int m_blockSize = -1;
    private byte[] m_inBuf = null;
    private int m_inBufLen = 0;
    private int m_inBufInx = 0;
    private byte[] m_outBuf = new byte[3];
    private int m_outBufLen = 0;
    private int m_outBufInx = 0;

    public void setBlockSize(int n) {
        this.m_blockSize = n;
    }

    public int read() throws IOException {
        if (this.m_blockSize == 0) {
            return -1;
        }
        if (this.m_outBufInx >= this.m_outBufLen) {
            this.m_outBufLen = this.base64Decode(this.m_outBuf, 0, 3);
            if (this.m_outBufLen == 0) {
                this.m_blockSize = 0;
                return -1;
            }
            this.m_outBufInx = 0;
        }
        if (this.m_blockSize != -1) {
            --this.m_blockSize;
        }
        return this.m_outBuf[this.m_outBufInx++];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.m_blockSize == 0) {
            return -1;
        }
        int n3 = 0;
        while (this.m_outBufInx < this.m_outBufLen) {
            byArray[n++] = this.m_outBuf[this.m_outBufInx++];
            ++n3;
            if (this.m_blockSize != -1) {
                --this.m_blockSize;
            }
            if (this.m_blockSize != 0 && n3 != n2) continue;
            return n3;
        }
        int n4 = n2 - n3;
        if (this.m_blockSize != -1 && n4 > this.m_blockSize) {
            n4 = this.m_blockSize;
        }
        int n5 = (n4 + 2) / 3 * 4;
        this.prefetch(n5);
        int n6 = this.base64Decode(byArray, n, n4);
        n3 += n6;
        if (this.m_blockSize != -1) {
            this.m_blockSize -= n6;
        }
        return n3;
    }

    private void prefetch(int n) throws IOException {
        if (this.m_inBuf == null || this.m_inBuf.length < n) {
            this.m_inBuf = new byte[n];
        }
        this.m_inBufLen = this.m_wrappedStream.read(this.m_inBuf, 0, n);
        this.m_inBufInx = 0;
    }

    private byte nextByte() throws IOException {
        if (this.m_inBufInx < this.m_inBufLen) {
            return this.m_inBuf[this.m_inBufInx++];
        }
        return (byte)this.m_wrappedStream.read();
    }

    private static boolean isBase64(byte by) {
        return base64idx[by] != -1;
    }

    private int base64Decode(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = n;
        while (this.m_outBufInx < this.m_outBufLen) {
            byArray[n3++] = this.m_outBuf[this.m_outBufInx++];
            --n2;
        }
        this.m_outBufLen = 0;
        this.m_outBufInx = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2 && !bl && n2 > 0) {
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = 0;
            int n4 = 0;
            while (!bl2) {
                by4 = this.nextByte();
                if (by4 == -1) {
                    bl2 = true;
                    continue;
                }
                if (Base64InputStream.isBase64(by4)) {
                    n4 = 1;
                    break;
                }
                if (by4 != 61) continue;
                bl = true;
                break;
            }
            while (!bl2) {
                by3 = this.nextByte();
                if (by3 == -1) {
                    bl2 = true;
                    continue;
                }
                if (Base64InputStream.isBase64(by3)) {
                    n4 = 2;
                    break;
                }
                if (by3 != 61) continue;
                bl = true;
                break;
            }
            while (!bl2) {
                by2 = this.nextByte();
                if (by2 == -1) {
                    bl2 = true;
                    continue;
                }
                if (Base64InputStream.isBase64(by2)) {
                    n4 = 3;
                    break;
                }
                if (by2 != 61) continue;
                bl = true;
                break;
            }
            while (!bl2) {
                by = this.nextByte();
                if (by == -1) {
                    bl2 = true;
                    continue;
                }
                if (Base64InputStream.isBase64(by)) {
                    n4 = 4;
                    break;
                }
                if (by != 61) continue;
                bl = true;
                break;
            }
            by4 = base64idx[by4];
            by3 = base64idx[by3];
            by2 = base64idx[by2];
            by = base64idx[by];
            byte by5 = (byte)(by4 << 2 & 0xFC | by3 >> 4 & 3);
            byte by6 = (byte)(by3 << 4 & 0xF0 | by2 >> 2 & 0xF);
            byte by7 = (byte)(by2 << 6 & 0xC0 | by & 0x3F);
            if (n4 >= 2) {
                if (n2 > 0) {
                    byArray[n3++] = by5;
                    --n2;
                } else {
                    this.m_outBuf[this.m_outBufLen++] = by5;
                }
            }
            if (n4 >= 3) {
                if (n2 > 0) {
                    byArray[n3++] = by6;
                    --n2;
                } else {
                    this.m_outBuf[this.m_outBufLen++] = by6;
                }
            }
            if (n4 != 4) continue;
            if (n2 > 0) {
                byArray[n3++] = by7;
                --n2;
                continue;
            }
            this.m_outBuf[this.m_outBufLen++] = by6;
        }
        return n3 - n;
    }

    public Base64InputStream(InputStream inputStream) {
        this.m_wrappedStream = inputStream;
    }
}

