/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.ClientContext;
import com.starbase.starteam.PropertyEnums;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.vts.comm.Cipher;
import com.starbase.starteam.vts.comm.CmdGetServerParams;
import com.starbase.starteam.vts.comm.CmdGetSessionTag;
import com.starbase.starteam.vts.comm.CmdKeyExchangeA;
import com.starbase.starteam.vts.comm.CmdKeyExchangeB;
import com.starbase.starteam.vts.comm.CmdKeyExchangeC;
import com.starbase.starteam.vts.comm.CmdServerConnect;
import com.starbase.starteam.vts.comm.CmdSetForeignProjectPw;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.EncryptContext;
import com.starbase.starteam.vts.comm.EncryptFactory;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import com.starbase.util.UTF8;
import java.io.IOException;
import java.util.Hashtable;

public abstract class Connection {
    private String m_commandInProgress;
    private short m_rev = (short)-1;
    private String m_commandAPIRevision = "1.0";
    private GUID m_serverGUID = null;
    private GUID m_clientID = null;
    private String m_serverBuild = "";
    private String m_serverDesc = "";
    private String m_hostName = null;
    private int m_port = -1;
    private int m_protocol = -1;
    private Server m_server = null;
    private int m_nCount = 0;
    private int m_SessionTag = 0;
    private boolean m_bOpen = false;
    private boolean m_bCompactServerCmds = false;
    private boolean m_bSecured = false;
    private int m_nClientEncryptID = 0;
    private int m_nServerEncryptID = 0;
    private double m_commandTime = 0.0;
    private int m_nCommandUserID = -1;
    private Cipher m_encrypter = null;
    private Cipher m_decrypter = null;
    private int m_compressionLevel = 0;
    private Hashtable m_foreignPasswordExceptionNotification = new Hashtable();
    protected int m_commandCount = 0;
    private boolean m_bAutoReconnectEnabled = true;
    private int m_AutoReconnectAttempts = 1;
    private int m_AutoReconnectWait = 2;
    private long m_AutoReconnectPausedUntil = 0L;
    private Hashtable m_sessions = new Hashtable();

    public int getCommandCount() {
        return this.m_commandCount;
    }

    String getHostName() {
        return this.m_hostName;
    }

    int getPort() {
        return this.m_port;
    }

    int getProtocol() {
        return this.m_protocol;
    }

    public void usingCommand(String string) {
        if (this.m_commandInProgress != null) {
            Assert.internalError("Connection.usingCommand()");
        }
        this.m_commandInProgress = string;
    }

    public void commandNotInUse() {
        this.m_commandInProgress = null;
    }

    PropertyEnums getPropertyEnums() {
        return this.getServer().getPropertyEnums();
    }

    boolean isNotifiedForeignPasswordException(String string) {
        Boolean bl = (Boolean)this.m_foreignPasswordExceptionNotification.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    void setNotifiedForeignPasswordException(String string) {
        this.m_foreignPasswordExceptionNotification.put(string, new Boolean(true));
    }

    Server getServer() {
        return this.m_server;
    }

    public void setForeignPassword(GUID gUID, String string, int n, byte[] byArray) {
        String string2 = this.getSessionName(gUID);
        if (byArray == null) {
            byArray = this.getSessionBytes(gUID);
        }
        CmdSetForeignProjectPw cmdSetForeignProjectPw = new CmdSetForeignProjectPw(string, string2, byArray, n);
        cmdSetForeignProjectPw.execute(this, gUID, 0, 0);
    }

    public Cipher getEncrypter() {
        return this.m_encrypter;
    }

    public void setEncrypter(Cipher cipher) {
        this.m_encrypter = cipher;
    }

    public Cipher getDecrypter() {
        return this.m_decrypter;
    }

    public void setDecrypter(Cipher cipher) {
        this.m_decrypter = cipher;
    }

    public int getServerEncryptID() {
        return this.m_nServerEncryptID;
    }

    public void setServerEncryptID(int n) {
        this.m_nServerEncryptID = n;
    }

    public int getCompressionLevel() {
        return this.m_compressionLevel;
    }

    public void setCompressionLevel(int n) {
        this.m_compressionLevel = n;
    }

    int getSessionTag() {
        return this.m_SessionTag;
    }

    public boolean isCompressionRequired() {
        return this.m_bCompactServerCmds;
    }

    public void setCommandTime(double d) {
        this.m_commandTime = d;
    }

    public double getCommandTime() {
        return this.m_commandTime;
    }

    public void setCommandUserID(int n) {
        this.m_nCommandUserID = n;
    }

    public int getCommandUserID() {
        return this.m_nCommandUserID;
    }

    public boolean isEncryptionOn() {
        return this.m_encrypter != null && this.m_decrypter != null;
    }

    private void setRevisionLevel(short s) {
        this.m_rev = s;
    }

    public short getRevisionLevel() {
        return this.m_rev;
    }

    public GUID getServerGUID() {
        return this.m_serverGUID;
    }

    public GUID getClientGUID() {
        return this.m_clientID;
    }

    public String getServerBuild() {
        return this.m_serverBuild;
    }

    public String getServerBuildDescription() {
        return this.m_serverDesc;
    }

    public String getCommandAPIRevisionLevel() {
        return this.m_commandAPIRevision;
    }

    public final boolean open(GUID gUID, String string) throws IOException {
        this.connect();
        short[] sArray = SystemRevisionNumbers.getSupportedRevs();
        short s = sArray[0];
        if (s >= 100) {
            if (!this.negotiateNewRevision(gUID, string, sArray)) {
                this.negotiateOldRevision(sArray);
            }
        } else {
            this.negotiateOldRevision(sArray);
        }
        this.m_bOpen = true;
        return true;
    }

    private boolean negotiateNewRevision(GUID gUID, String string, short[] sArray) {
        int n = sArray.length;
        int n2 = 0;
        while (n2 < n) {
            short s = sArray[n2];
            if (s >= 100) {
                try {
                    this.setRevisionLevel(s);
                    CmdGetServerParams cmdGetServerParams = new CmdGetServerParams();
                    cmdGetServerParams.execute(this, null, 0, 0);
                    int n3 = cmdGetServerParams.getGlobalRevisionLevel();
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < sArray.length) {
                        if (n3 == sArray[n4]) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        throw new RuntimeException(Res.formatKey(ResIDs.INCOMPATIBLE_SDK_FMT, new Object[]{cmdGetServerParams.getServerBuild()}));
                    }
                    String string2 = SystemRevisionNumbers.chooseAPIRevision((short)n3, cmdGetServerParams.getCommandAPIRevision());
                    CmdServerConnect cmdServerConnect = new CmdServerConnect(gUID, string, string2);
                    cmdServerConnect.execute(this, null, 0, 0);
                    this.m_clientID = cmdServerConnect.getClientID();
                    this.m_serverGUID = cmdGetServerParams.getServerGuid();
                    this.m_serverBuild = cmdGetServerParams.getServerBuild();
                    this.m_serverDesc = cmdGetServerParams.getServerBuildDescription();
                    this.m_commandAPIRevision = string2;
                    return true;
                }
                catch (ServerException serverException) {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private void negotiateOldRevision(short[] sArray) {
        boolean bl = false;
        int n = sArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                short s = sArray[n2];
                if (s < 100) {
                    try {
                        this.setRevisionLevel(s);
                        this.m_SessionTag = this.querySessionTag(this.m_SessionTag);
                        bl = true;
                        break;
                    }
                    catch (ServerException serverException) {
                        if (serverException.getErrorCode() == 7 && serverException.getClassName().equals("CStCoreException")) break block5;
                        throw serverException;
                    }
                }
            }
            ++n2;
        }
        if (!bl) {
            throw new RuntimeException(Res.getString(ResIDs.INCOMPATIBLE_CLIENT));
        }
    }

    public GUID startNewClientSession(ClientContext clientContext) {
        CmdServerConnect cmdServerConnect = new CmdServerConnect(clientContext.getWorkStationID(), clientContext.getHostName(), this.getCommandAPIRevisionLevel());
        cmdServerConnect.execute(this, null, 0, 0);
        return cmdServerConnect.getClientID();
    }

    final void close() {
        this.disconnect();
        this.m_bOpen = false;
    }

    public abstract void connect() throws IOException;

    public abstract void reconnect(GUID var1);

    public abstract void disconnect();

    public boolean isAutoReconnectEnabled() {
        if (this.m_AutoReconnectPausedUntil != 0L) {
            long l = System.currentTimeMillis();
            if (l < this.m_AutoReconnectPausedUntil) {
                return false;
            }
            this.m_AutoReconnectPausedUntil = 0L;
        }
        return this.m_bAutoReconnectEnabled;
    }

    public void setAutoReconnectEnabled(boolean bl) {
        this.m_bAutoReconnectEnabled = bl;
    }

    public int getAutoReconnectAttempts() {
        return this.m_AutoReconnectAttempts;
    }

    public void setAutoReconnectAttempts(int n) {
        if (n < 1) {
            n = 1;
        }
        this.m_AutoReconnectAttempts = n;
    }

    public int getAutoReconnectWait() {
        return this.m_AutoReconnectWait;
    }

    public void setAutoReconnectWait(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_AutoReconnectWait = n;
    }

    void pauseReconnect(long l) {
        long l2 = System.currentTimeMillis();
        this.m_AutoReconnectPausedUntil = l2 + l;
    }

    boolean isAutoReconnect(GUID gUID) {
        return this.m_bOpen && this.isAutoReconnectEnabled() && SystemRevisionNumbers.equalOrGreater(this.getRevisionLevel(), this.getCommandAPIRevisionLevel(), (short)100, "1.10") && this.isSessionReady(gUID);
    }

    void reserve() {
        ++this.m_nCount;
    }

    int free() {
        if (this.m_nCount <= 0) {
            Assert.internalError("Connection.free(), m_nCount=" + this.m_nCount);
        }
        return --this.m_nCount;
    }

    public abstract Command prepareCommand(int var1, int var2, Cipher var3, Cipher var4, GUID var5, int var6, int var7, int var8, int var9) throws IOException;

    public abstract void execCommand(Command var1) throws IOException;

    public abstract void terminateCommand(Command var1) throws IOException;

    public void onCommandException(Exception exception) {
    }

    int querySessionTag(int n) {
        if (n != 0) {
            return n;
        }
        CmdGetSessionTag cmdGetSessionTag = new CmdGetSessionTag();
        cmdGetSessionTag.execute(this, null, 0, 0);
        return cmdGetSessionTag.getSessionTag();
    }

    public void enableEncryption(int n, EncryptionAlgorithm encryptionAlgorithm, int n2) {
        if (encryptionAlgorithm == null) {
            Assert.internalError("Connection.enableEncryption(), algid=null");
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.NULL) {
            return;
        }
        EncryptContext encryptContext = EncryptFactory.getContext();
        encryptContext.beginKeyExchange(encryptionAlgorithm, n2);
        int n3 = -1;
        CmdKeyExchangeA cmdKeyExchangeA = new CmdKeyExchangeA(n, encryptContext.exportPublicKeyToCAPI(), encryptionAlgorithm);
        cmdKeyExchangeA.execute(this, null, 0, 0);
        byte[] byArray = cmdKeyExchangeA.getServerPublicKey();
        n3 = cmdKeyExchangeA.getHandle();
        encryptContext.importCAPIPublicKey(byArray);
        encryptContext.generateSessionKey();
        CmdKeyExchangeB cmdKeyExchangeB = new CmdKeyExchangeB(n, n3, encryptContext.exportSessionKeyToCAPI());
        cmdKeyExchangeB.execute(this, null, 0, 0);
        byte[] byArray2 = cmdKeyExchangeB.getServerSessionKey();
        byte[] byArray3 = cmdKeyExchangeB.getHash();
        encryptContext.importCAPISessionKey(byArray2);
        if (!encryptContext.validServerHash(byArray3)) {
            Assert.internalError("Connection.enableEncryption()");
        }
        byte[] byArray4 = encryptContext.getClientHash();
        CmdKeyExchangeC cmdKeyExchangeC = new CmdKeyExchangeC(n, n3, byArray4);
        cmdKeyExchangeC.execute(this, null, 0, 0);
        int n4 = cmdKeyExchangeC.getServerCipherID();
        encryptContext.endKeyExchange();
        this.setServerEncryptID(n4);
        this.setEncrypter(encryptContext);
        this.setDecrypter(encryptContext);
    }

    public void saveSessionInfo(GUID gUID, String string, byte[] byArray) {
        SessionInfo sessionInfo = this.getSessionInfo(gUID);
        if (sessionInfo == null) {
            Connection connection = this;
            if (connection == null) {
                throw null;
            }
            sessionInfo = connection.new SessionInfo();
        }
        if (string != null) {
            sessionInfo.name = string;
        }
        if (byArray != null) {
            sessionInfo.bytes = byArray;
        }
        this.setSessionInfo(gUID, sessionInfo);
    }

    private SessionInfo getSessionInfo(GUID gUID) {
        return (SessionInfo)this.m_sessions.get(gUID);
    }

    private void setSessionInfo(GUID gUID, SessionInfo sessionInfo) {
        this.m_sessions.put(gUID, sessionInfo);
    }

    private boolean isSessionReady(GUID gUID) {
        SessionInfo sessionInfo = this.getSessionInfo(gUID);
        return sessionInfo != null && sessionInfo.name != null && sessionInfo.bytes != null;
    }

    String getSessionName(GUID gUID) {
        SessionInfo sessionInfo = this.getSessionInfo(gUID);
        if (sessionInfo == null) {
            Assert.internalError("Connection.getSessionName(), session=null");
        }
        if (sessionInfo.name == null) {
            Assert.internalError("Connection.getSessionName(), name=null");
        }
        return sessionInfo.name;
    }

    byte[] getSessionBytes(GUID gUID) {
        SessionInfo sessionInfo = this.getSessionInfo(gUID);
        if (sessionInfo == null) {
            Assert.internalError("Connection.getSessionBytes(), session=null");
        }
        if (sessionInfo.bytes == null) {
            Assert.internalError("Connection.getSessionName(), bytes=null");
        }
        return sessionInfo.bytes;
    }

    static String unmangle(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            Assert.internalError("UserAccount_Data.unmangle(), nBytes=0");
        }
        if ((n = (int)(byArray[n2 - 1] ^ 0xFF)) < 0 || n >= n2) {
            Assert.internalError("UserAccount_Data.unmangle(), nBytes=" + n2 + ", len=" + n);
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            byArray2[n3] = (byte)(byArray[n3] ^ n);
            ++n3;
        }
        return UTF8.Utf8ToString(byArray2);
    }

    Connection(String string, int n, int n2, Server server) {
        this.m_hostName = string;
        this.m_port = n;
        this.m_protocol = n2;
        this.m_server = server;
    }

    private class SessionInfo {
        public String name = null;
        public byte[] bytes = null;

        SessionInfo() {
        }
    }
}

