/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Indent;
import com.starbase.util.collections.Collection;
import com.starbase.util.collections.Iterator;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DBG {
    public static String formatObject(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
            try {
                Method method = object.getClass().getMethod("toDebugString", new Class[0]);
                String string2 = System.getProperty("line.separator");
                string = string + string2 + Indent.withSpaces((String)method.invoke(object, new Object[0]), 4);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            string = "(null)";
        }
        return string;
    }

    public static void dump(int[] nArray) {
        DBG.dump(nArray, new PrintWriter(System.out));
    }

    public static void dump(int[] nArray, PrintStream printStream) {
        DBG.dump(nArray, new PrintWriter(printStream));
    }

    public static void dump(int[] nArray, PrintWriter printWriter) {
        if (nArray == null) {
            printWriter.println("The int array being dumped is null");
            return;
        }
        printWriter.println("Dumping int array, " + nArray.length + " elements...");
        int n = 0;
        while (n < nArray.length) {
            printWriter.println("  [" + n + "] = " + nArray[n]);
            ++n;
        }
        printWriter.flush();
    }

    public static String dumpToString(int[] nArray) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(nArray, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Object[] objectArray) {
        DBG.dump(objectArray, new PrintWriter(System.out));
    }

    public static void dump(Object[] objectArray, PrintStream printStream) {
        DBG.dump(objectArray, new PrintWriter(printStream));
    }

    public static void dump(Object[] objectArray, PrintWriter printWriter) {
        if (objectArray == null) {
            printWriter.println("The object array being dumped is null");
        } else {
            printWriter.println("Dumping object array, " + objectArray.length + " elements...");
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = DBG.formatObject(object);
                printWriter.println("  [" + n + "] = " + string);
                ++n;
            }
        }
        printWriter.flush();
    }

    public static String dumpToString(Object[] objectArray) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(objectArray, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Object object) {
        DBG.dump(object, new PrintWriter(System.out));
    }

    public static void dump(Object object, PrintStream printStream) {
        DBG.dump(object, new PrintWriter(printStream));
    }

    public static void dump(Object object, PrintWriter printWriter) {
        if (object == null) {
            printWriter.println("The object being dumped is null");
            return;
        }
        printWriter.println("Dumping Object of class " + object.getClass().getName() + "...");
        String string = DBG.formatObject(object);
        printWriter.println(string);
        printWriter.flush();
    }

    public static String dumpToString(Object object) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(object, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Vector vector) {
        DBG.dump(vector, new PrintWriter(System.out));
    }

    public static void dump(Vector vector, PrintStream printStream) {
        DBG.dump(vector, new PrintWriter(printStream));
    }

    public static void dump(Vector vector, PrintWriter printWriter) {
        if (vector == null) {
            printWriter.println("The vector being dumped is null");
            return;
        }
        printWriter.println("Dumping Vector, " + vector.size() + " elements...");
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            String string = DBG.formatObject(e);
            printWriter.println("  [" + n + "] = " + string);
            ++n;
        }
        printWriter.flush();
    }

    public static String dumpToString(Vector vector) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(vector, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Enumeration enumeration) {
        DBG.dump(enumeration, new PrintWriter(System.out));
    }

    public static void dump(Enumeration enumeration, PrintStream printStream) {
        DBG.dump(enumeration, new PrintWriter(printStream));
    }

    public static void dump(Enumeration enumeration, PrintWriter printWriter) {
        if (enumeration == null) {
            printWriter.println("The enumeration being dumped is null");
            return;
        }
        printWriter.println("Dumping Enumeration...");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = DBG.formatObject(e);
            printWriter.println("  [" + n + "] = " + string);
            ++n;
        }
        printWriter.flush();
    }

    public static String dumpToString(Enumeration enumeration) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(enumeration, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Hashtable hashtable) {
        DBG.dump(hashtable, new PrintWriter(System.out));
    }

    public static void dump(Hashtable hashtable, PrintStream printStream) {
        DBG.dump(hashtable, new PrintWriter(printStream));
    }

    public static void dump(Hashtable hashtable, PrintWriter printWriter) {
        if (hashtable == null) {
            printWriter.println("The hashtable being dumped is null");
            return;
        }
        printWriter.println("Dumping Hashtable...");
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = enumeration2.nextElement();
            String string = k.toString() + ": ";
            string = string + DBG.formatObject(v);
            printWriter.println("  [" + n + "] = " + string);
            ++n;
        }
        printWriter.flush();
    }

    public static String dumpToString(Hashtable hashtable) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(hashtable, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Collection collection) {
        DBG.dump(collection, new PrintWriter(System.out));
    }

    public static void dump(Collection collection, PrintStream printStream) {
        DBG.dump(collection, new PrintWriter(printStream));
    }

    public static void dump(Collection collection, PrintWriter printWriter) {
        if (collection == null) {
            printWriter.println("The collection being dumped is null");
            return;
        }
        printWriter.println("Dumping Collection...");
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String string = DBG.formatObject(object);
            printWriter.println("  [" + n + "] = " + string);
            ++n;
        }
        printWriter.flush();
    }

    public static String dumpToString(Collection collection) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(collection, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void dump(Iterator iterator) {
        DBG.dump(iterator, new PrintWriter(System.out));
    }

    public static void dump(Iterator iterator, PrintStream printStream) {
        DBG.dump(iterator, new PrintWriter(printStream));
    }

    public static void dump(Iterator iterator, PrintWriter printWriter) {
        if (iterator == null) {
            printWriter.println("The iterator being dumped is null");
            return;
        }
        printWriter.println("Dumping Iterator...");
        int n = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String string = DBG.formatObject(object);
            printWriter.println("  [" + n + "] = " + string);
            ++n;
        }
        printWriter.flush();
    }

    public static String dumpToString(Iterator iterator) {
        StringWriter stringWriter = new StringWriter();
        DBG.dump(iterator, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

