/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ISO8601 {
    private static GregorianCalendar m_cal = new GregorianCalendar();
    private static GregorianCalendar m_localcal = new GregorianCalendar();
    private static final char[] m_gmtString;
    private static final char[] m_localString;
    private static final char[] m_digits;

    public static String toGMTString(long l) {
        GregorianCalendar gregorianCalendar = m_cal;
        synchronized (gregorianCalendar) {
            ((Calendar)m_cal).getTimeZone().setRawOffset(0);
            m_cal.setTime(new Date(l));
            int n = m_cal.get(1);
            ISO8601.m_gmtString[3] = m_digits[n % 10];
            ISO8601.m_gmtString[2] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[1] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[0] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[4] = 45;
            n = 1 + m_cal.get(2);
            ISO8601.m_gmtString[6] = m_digits[n % 10];
            ISO8601.m_gmtString[5] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[7] = 45;
            n = m_cal.get(5);
            ISO8601.m_gmtString[9] = m_digits[n % 10];
            ISO8601.m_gmtString[8] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[10] = 84;
            n = m_cal.get(11);
            ISO8601.m_gmtString[12] = m_digits[n % 10];
            ISO8601.m_gmtString[11] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[13] = 58;
            n = m_cal.get(12);
            ISO8601.m_gmtString[15] = m_digits[n % 10];
            ISO8601.m_gmtString[14] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[16] = 58;
            n = m_cal.get(13);
            ISO8601.m_gmtString[18] = m_digits[n % 10];
            ISO8601.m_gmtString[17] = m_digits[(n /= 10) % 10];
            n = (int)(l % 1000L);
            ISO8601.m_gmtString[19] = 46;
            ISO8601.m_gmtString[22] = m_digits[n % 10];
            ISO8601.m_gmtString[21] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[20] = m_digits[(n /= 10) % 10];
            ISO8601.m_gmtString[23] = 90;
            String string = new String(m_gmtString, 0, 24);
            Object var3_4 = null;
            return string;
        }
    }

    public static String toLocalString(long l) {
        GregorianCalendar gregorianCalendar = m_localcal;
        synchronized (gregorianCalendar) {
            m_localcal.setTime(new Date(l));
            int n = m_localcal.get(1);
            int n2 = m_localcal.get(2);
            int n3 = m_localcal.get(5);
            int n4 = m_localcal.get(13);
            int n5 = n;
            ISO8601.m_localString[3] = m_digits[n5 % 10];
            ISO8601.m_localString[2] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[1] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[0] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[4] = 45;
            n5 = 1 + n2;
            ISO8601.m_localString[6] = m_digits[n5 % 10];
            ISO8601.m_localString[5] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[7] = 45;
            n5 = n3;
            ISO8601.m_localString[9] = m_digits[n5 % 10];
            ISO8601.m_localString[8] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[10] = 84;
            n5 = m_localcal.get(11);
            ISO8601.m_localString[12] = m_digits[n5 % 10];
            ISO8601.m_localString[11] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[13] = 58;
            n5 = m_localcal.get(12);
            ISO8601.m_localString[15] = m_digits[n5 % 10];
            ISO8601.m_localString[14] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[16] = 58;
            n5 = n4;
            ISO8601.m_localString[18] = m_digits[n5 % 10];
            ISO8601.m_localString[17] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[19] = 46;
            n5 = (int)(l % 1000L);
            ISO8601.m_localString[22] = m_digits[n5 % 10];
            ISO8601.m_localString[21] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[20] = m_digits[(n5 /= 10) % 10];
            int n6 = ((Calendar)m_localcal).getTimeZone().getOffset(m_localcal.get(0), n, n2, n3, m_localcal.get(7), n4 * 1000);
            if (n6 < 0) {
                ISO8601.m_localString[23] = 45;
                n6 *= -1;
            } else {
                ISO8601.m_localString[23] = 43;
            }
            int n7 = n6 / 3600000;
            int n8 = n6 / 60000 % 60;
            n5 = n7;
            ISO8601.m_localString[25] = m_digits[n5 % 10];
            ISO8601.m_localString[24] = m_digits[(n5 /= 10) % 10];
            ISO8601.m_localString[26] = 58;
            n5 = n8;
            ISO8601.m_localString[28] = m_digits[n5 % 10];
            ISO8601.m_localString[27] = m_digits[(n5 /= 10) % 10];
            String string = new String(m_localString, 0, 29);
            Object var3_11 = null;
            return string;
        }
    }

    public static long parse(String string) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        String string2 = "ISO8601.parse()";
        if (string.length() < 20) {
            ISO8601.throwBadFormat(string2, string);
        }
        if (string.charAt(4) != '-') {
            ISO8601.throwBadFormat(string2, string);
        }
        if (string.charAt(7) != '-') {
            ISO8601.throwBadFormat(string2, string);
        }
        if (string.charAt(10) != 'T') {
            ISO8601.throwBadFormat(string2, string);
        }
        if (string.charAt(13) != ':') {
            ISO8601.throwBadFormat(string2, string);
        }
        if (string.charAt(16) != ':') {
            ISO8601.throwBadFormat(string2, string);
        }
        n3 = ISO8601.parseRange(string, 0, 4);
        n5 = ISO8601.parseRange(string, 5, 2);
        n4 = ISO8601.parseRange(string, 8, 2);
        n6 = ISO8601.parseRange(string, 11, 2);
        n7 = ISO8601.parseRange(string, 14, 2);
        n8 = ISO8601.parseRange(string, 17, 2);
        String string3 = string.substring(19);
        if (string3.startsWith(".")) {
            n9 = 0;
            n2 = 1;
            n = 100;
            char c = string3.charAt(n2);
            while (ISO8601.isDigit(c)) {
                n9 += n * (c - 48);
                n /= 10;
                if (n2 != 4 || c >= '5') {
                    // empty if block
                }
                c = string3.charAt(++n2);
            }
            string3 = string3.substring(n2);
        }
        n2 = string3.charAt(0);
        n = 1;
        if (n2 != 90) {
            if (n2 == 43 || n2 == 45) {
                if (string3.length() != 6) {
                    ISO8601.throwBadFormat(string2, string);
                }
                if (string3.charAt(3) != ':') {
                    ISO8601.throwBadFormat(string2, string);
                }
                n = n2 == 43 ? 1 : -1;
                n10 = n * ISO8601.parseRange(string3, 1, 2);
                n11 = ISO8601.parseRange(string3, 4, 2);
            } else {
                ISO8601.throwBadFormat(string2, string);
            }
        }
        GregorianCalendar gregorianCalendar = m_cal;
        synchronized (gregorianCalendar) {
            ((Calendar)m_cal).getTimeZone().setRawOffset(n10 * 60 * 60 * 1000 + n11 * 60 * 1000);
            m_cal.set(n3, n5 - 1, n4, n6, n7, n8);
            m_cal.set(14, n9);
            long l = m_cal.getTime().getTime();
            Object var15_17 = null;
            return l;
        }
    }

    private static void throwBadFormat(String string, String string2) {
        throw new IllegalArgumentException(Res.getString(ResIDs.INVALID_ISO8601_FORMAT));
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static int parseRange(String string, int n, int n2) {
        String string2 = string.substring(n, n + n2);
        return Integer.parseInt(string2);
    }

    private ISO8601() {
    }

    static {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "GMT");
        ((TimeZone)simpleTimeZone).setRawOffset(0);
        m_cal = new GregorianCalendar(simpleTimeZone);
        m_localcal = new GregorianCalendar(TimeZone.getDefault());
        m_gmtString = new char[32];
        m_localString = new char[32];
        m_digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }
}

