/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.starteam.SDKRuntimeException;
import com.starbase.util.FileAccess;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.io.IOException;

public class NativeFileAccess
extends FileAccess {
    private static final String LIBRARY = "StSDKNativeFileAccess_02";
    private static boolean m_bLoaded = false;

    private static void init() {
        if (!m_bLoaded) {
            try {
                System.loadLibrary(LIBRARY);
                m_bLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.NATIVE_LIBRARY_NOT_FOUND_FMT, new Object[]{LIBRARY}), unsatisfiedLinkError);
            }
        }
    }

    public long getLastModified(String string) throws IOException {
        long l = NativeFileAccess.getLastModifiedAsLong(string);
        if (l == 0L) {
            throw new IOException(Res.formatKey(ResIDs.ERROR_GETTING_MODIFIED_TIME_FMT, new Object[]{string}));
        }
        return l;
    }

    public void setLastModified(String string, long l) throws IOException {
        NativeFileAccess.setLastModifiedAsLong(string, l);
    }

    public boolean getCanWrite(String string) {
        return NativeFileAccess.getWritable(string);
    }

    public void setCanWrite(String string, boolean bl) throws IOException {
        NativeFileAccess.setWritable(string, bl);
    }

    public boolean getIsExecutable(String string) throws IOException {
        return NativeFileAccess.getExecutable(string);
    }

    public void setIsExecutable(String string, boolean bl) throws IOException {
        NativeFileAccess.setExecutable(string, bl);
    }

    private static native long getLastModifiedAsLong(String var0) throws IOException;

    private static native void setLastModifiedAsLong(String var0, long var1) throws IOException;

    private static native boolean getWritable(String var0);

    private static native void setWritable(String var0, boolean var1) throws IOException;

    private static native boolean getExecutable(String var0);

    private static native void setExecutable(String var0, boolean var1) throws IOException;

    public NativeFileAccess() {
        NativeFileAccess.init();
    }
}

