/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Assert;
import com.starbase.util.ISO8601;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class OLEDate {
    private static final double HALF_SECOND = 5.787037037037037E-6;
    private static int[] rgMonthDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static DateFormat m_DefaultDateFormat = null;
    private static Calendar m_calendar = null;
    public static OLEDate CURRENT_SERVER_TIME;
    private static final long DATE_MAX = 253402300799999L;
    private static final long SEC_PER_HOUR = 3600L;
    private static final long SEC_PER_MIN = 60L;
    private static final double SEC_PER_DAY = 86400.0;
    private static final double MSECS_PER_DAY = 8.64E7;
    private double m_OleTime = 0.0;

    private void setOleTime(double d) {
        this.m_OleTime = d;
    }

    public double getDoubleValue() {
        return this.m_OleTime;
    }

    public long getLongValue() {
        return OLEDate.longFromDouble(this.m_OleTime);
    }

    public Date createDate() {
        return new Date(this.getLongValue());
    }

    public static long longFromDouble(double d) {
        return OLEDate.javaDateFromOleDate(d).getTime();
    }

    public static double doubleFromLong(long l) {
        return OLEDate.oleTimeFromLong(l);
    }

    public OLEDate getUTCNoon() {
        Date date = this.createDate();
        Date date2 = new Date(Date.UTC(date.getYear(), date.getMonth(), date.getDate(), 12, 0, 0));
        return new OLEDate(date2);
    }

    public String toString() {
        if (this.m_OleTime == 0.0) {
            return "N/A";
        }
        Date date = OLEDate.javaDateFromOleDate(this.m_OleTime);
        DateFormat dateFormat = m_DefaultDateFormat;
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }

    public String localString(int n, int n2) {
        Date date = OLEDate.javaDateFromOleDate(this.m_OleTime);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2);
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }

    public String toISO8601String() {
        return ISO8601.toGMTString(this.getLongValue());
    }

    private static final double oleTimeFromLong(long l) throws IllegalArgumentException {
        if (l > 253402300799999L) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.TIME_VALUE_TOO_LARGE_FMT, new Object[]{new Long(l), new Long(253402300799999L)}));
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Calendar calendar = m_calendar;
        synchronized (calendar) {
            m_calendar.setTime(new Date(l));
            n = m_calendar.get(1);
            n2 = m_calendar.get(2) + 1;
            n3 = m_calendar.get(5);
            n4 = m_calendar.get(11);
            n5 = m_calendar.get(12);
            n6 = m_calendar.get(13);
        }
        if (n2 < 1 || n2 > 12) {
            Assert.internalError("OLEDate.oleTimeFromLong(), month=" + n2 + ".");
        }
        boolean bl = (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
        int n7 = rgMonthDays[n2] - rgMonthDays[n2 - 1] + (bl && n3 == 29 && n2 == 2 ? 1 : 0);
        if (n3 < 1 || n3 > n7 || n4 > 23 || n5 > 59 || n6 > 59) {
            Assert.internalError("OLEDate.oleTimeFromLong(), day=" + n3 + ", hour=" + n4 + ", minute=" + n5 + ", second=" + n6 + ".");
        }
        long l2 = (long)n * 365L + (long)(n / 4) - (long)(n / 100) + (long)(n / 400) + (long)rgMonthDays[n2 - 1] + (long)n3;
        if (n2 < 3 && bl) {
            --l2;
        }
        double d = (double)((long)n4 * 3600L + (long)n5 * 60L + (long)n6) / 86400.0;
        double d2 = (double)(l2 -= 693959L) + (l2 >= 0L ? d : -d);
        return d2;
    }

    private static final Date javaDateFromOleDate(double d) {
        long l;
        long l2;
        long l3;
        boolean bl = true;
        long l4 = (long)d;
        double d2 = d > 0.0 ? 5.787037037037037E-6 : -5.787037037037037E-6;
        long l5 = (long)(d += d2) + 693959L;
        d = Math.abs(d);
        long l6 = (long)((d - Math.floor(d)) * 86400.0);
        int n = 0;
        int n2 = 0;
        long l7 = 0L;
        long l8 = 0L;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n = (int)((l5 - 1L) % 7L) + 1;
        long l9 = l5 / 146097L;
        long l10 = ((l5 %= 146097L) - 1L) / 36524L;
        if (l10 != 0L) {
            l3 = ((l5 = (l5 - 1L) % 36524L) + 1L) / 1461L;
            if (l3 != 0L) {
                l2 = (l5 + 1L) % 1461L;
            } else {
                bl = false;
                l2 = l5;
            }
        } else {
            l3 = l5 / 1461L;
            l2 = l5 % 1461L;
        }
        if (bl) {
            l = l2 - 1L;
            if ((l /= 365L) != 0L) {
                l2 = (l2 - 1L) % 365L;
            }
        } else {
            l = l2 / 365L;
            l2 %= 365L;
        }
        n2 = (int)l2 + 1;
        l7 = l9 * 400L + l10 * 100L + l3 * 4L + l;
        boolean bl2 = false;
        if (l == 0L && bl) {
            if (l2 == 59L) {
                l8 = 2L;
                n3 = 29;
                bl2 = true;
            }
            if (!bl2 && l2 >= 60L) {
                --l2;
            }
        }
        if (!bl2) {
            l8 = (++l2 >> 5) + 1L;
            while (l2 > (long)rgMonthDays[(int)l8]) {
                ++l8;
            }
            n3 = (int)(l2 - (long)rgMonthDays[(int)l8 - 1]);
        }
        if (l6 == 0L) {
            n6 = 0;
            n5 = 0;
            n4 = 0;
        } else {
            n6 = (int)(l6 % 60L);
            long l11 = l6 / 60L;
            n5 = (int)l11 % 60;
            n4 = (int)l11 / 60;
        }
        Calendar calendar = m_calendar;
        synchronized (calendar) {
            m_calendar.clear();
            m_calendar.set((int)l7, (int)(l8 - 1L), n3, n4, n5, n6);
            Date date = m_calendar.getTime();
            Object var35_23 = null;
            return date;
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(OLEDate.round(this.m_OleTime));
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof OLEDate) {
            double d = OLEDate.round(this.m_OleTime);
            double d2 = OLEDate.round(((OLEDate)object).m_OleTime);
            return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
        }
        return false;
    }

    private static double round(double d) {
        if (d != 0.0) {
            double d2 = d < 0.0 ? -0.5 : 0.5;
            d = (double)((long)(d * 8.64E7 + d2)) / 8.64E7;
        }
        return d;
    }

    public OLEDate() {
        this.setOleTime(OLEDate.oleTimeFromLong(new Date().getTime()));
    }

    public OLEDate(double d) {
        this.setOleTime(d);
    }

    public OLEDate(long l) {
        this.setOleTime(OLEDate.oleTimeFromLong(l));
    }

    public OLEDate(Date date) {
        this.setOleTime(OLEDate.oleTimeFromLong(date.getTime()));
    }

    public OLEDate(OLEDate oLEDate) {
        this.setOleTime(oLEDate.getDoubleValue());
    }

    static {
        m_DefaultDateFormat = DateFormat.getDateTimeInstance(3, 1);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "GMT");
        m_calendar = new GregorianCalendar(simpleTimeZone);
        CURRENT_SERVER_TIME = new OLEDate(0.0);
    }
}

