/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TextInputStream
extends InputStream {
    private Reader m_source;

    public int read() throws IOException {
        int n = this.m_source.read();
        if (n == -1) {
            return -1;
        }
        this.checkText(n);
        return n;
    }

    private void checkText(int n) throws IOException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException(Res.getString(ResIDs.NON_TEXT_CHARACTERS));
        }
    }

    public void close() throws IOException {
        this.m_source.close();
    }

    public long skip(long l) throws IOException {
        return this.m_source.skip(l);
    }

    public int available() throws IOException {
        return this.m_source.ready() ? 1 : 0;
    }

    public synchronized void mark(int n) {
        super.mark(n);
    }

    public synchronized void reset() throws IOException {
        super.reset();
    }

    public boolean markSupported() {
        return super.markSupported();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        while (n4 < n2) {
            n3 = this.read();
            if (n3 == -1) break;
            if (byArray != null) {
                byArray[n + n4] = (byte)n3;
            }
            ++n4;
        }
        return n4;
    }

    public TextInputStream(Reader reader) {
        this.m_source = reader;
    }
}

