/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindTextPane
extends JComponent {
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String FIND_SELECTION = "FindSelection";
    public static final int FIND_DIRECTION_UP = 1;
    public static final int FIND_DIRECTION_DOWN = 0;
    private JDialog m_dialog = null;
    private JTextField m_editField = null;
    private JCheckBox m_caseCheck = null;
    private JRadioButton m_directionUp = null;
    private JRadioButton m_directionDown = null;
    private JButton m_approveButton = null;
    private JButton m_cancelButton = null;
    private JLabel m_textEntryLabel = null;
    private JPanel m_lowerGroup = null;
    private JPanel m_directionButtons = null;
    private boolean m_directionVisible = false;
    private int m_textColumns = 5;
    private String m_approveButtonText = "Find Next";
    private String m_cancelButtontext = "Cancel";
    private String m_textEntryLabelText = "Find what:";
    private String m_searchText = "";
    private String m_directionLabel = "Direction";
    private String m_directionUpText = "Up";
    private String m_directionDownText = "Down";
    private String m_matchCase = "Match case";
    private static /* synthetic */ Class class$Ljava$awt$event$ActionListener;

    public JDialog createDialog(Component component, String string) {
        JDialog jDialog;
        if (this.m_dialog != null) {
            jDialog = this.m_dialog;
        } else {
            Frame frame = FindTextPane.getFrameForComponent(component);
            FindTextPane findTextPane = this;
            if (findTextPane == null) {
                throw null;
            }
            jDialog = new JDialog(findTextPane, frame){
                private final /* synthetic */ FindTextPane this$0;

                public void show() {
                    super.show();
                    FindTextPane.access$3(this.this$0).requestFocus();
                }

                public void setVisible(boolean bl) {
                    super.setVisible(bl);
                    if (bl) {
                        FindTextPane.access$3(this.this$0).requestFocus();
                    }
                }
                {
                    this.this$0 = findTextPane;
                    this.constructor$0(findTextPane, frame);
                }

                private final void constructor$0(FindTextPane findTextPane, Frame frame) {
                }
            };
            jDialog.setTitle(string);
            jDialog.getContentPane().add(this);
            jDialog.pack();
            this.m_dialog = jDialog;
        }
        return jDialog;
    }

    public String getText() {
        if (this.m_editField != null) {
            this.m_searchText = this.m_editField.getText();
        }
        return this.m_searchText;
    }

    public void setText(String string) {
        this.m_searchText = string;
        this.m_editField.setText(string);
    }

    public int getTextColumns() {
        return this.m_textColumns;
    }

    public void setTextColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.m_textColumns = n;
        this.m_editField.setColumns(n);
    }

    public boolean isCaseMatched() {
        boolean bl = false;
        if (this.m_caseCheck != null) {
            bl = this.m_caseCheck.isSelected();
        }
        return bl;
    }

    public void setCaseMatched(boolean bl) {
        if (this.m_caseCheck != null) {
            this.m_caseCheck.setSelected(bl);
        }
    }

    public int getFindDirection() {
        int n = this.m_directionUp.isSelected() ? 1 : 0;
        return n;
    }

    public void setFindDirection(int n) {
    }

    public String getApproveButtonText() {
        return this.m_approveButtonText;
    }

    public void setApproveButtonText(String string) {
        this.m_approveButtonText = string;
        if (this.m_approveButton != null) {
            this.m_approveButton.setText(string);
        }
    }

    public String getCancelButtonText() {
        return this.m_cancelButtontext;
    }

    public void setCancelButtonText(String string) {
        this.m_cancelButtontext = string;
        if (this.m_cancelButton != null) {
            this.m_cancelButton.setText(string);
        }
    }

    public String getTextEntryLabel() {
        return this.m_textEntryLabelText;
    }

    public void setTextEntryLabel(String string) {
        this.m_textEntryLabelText = string;
        if (this.m_textEntryLabel != null) {
            this.m_textEntryLabel.setText(string);
        }
    }

    public String getDirectionLabel() {
        return this.m_directionLabel;
    }

    public void setDirectionLabel(String string) {
        Border border;
        this.m_directionLabel = string;
        if (this.m_directionButtons != null && (border = this.m_directionButtons.getBorder()) instanceof TitledBorder) {
            ((TitledBorder)border).setTitle(string);
        }
    }

    public String getDirectionUpText() {
        return this.m_directionUpText;
    }

    public void setDirectionUpText(String string) {
        this.m_directionUpText = string;
        if (this.m_directionUp != null) {
            this.m_directionUp.setText(string);
        }
    }

    public String getDirectionDownText() {
        return this.m_directionDownText;
    }

    public void setDirectionDownText(String string) {
        this.m_directionDownText = string;
        if (this.m_directionDown != null) {
            this.m_directionDown.setText(string);
        }
    }

    public String getMatchCaseText() {
        return this.m_matchCase;
    }

    public void setMatchCaseText(String string) {
        this.m_matchCase = string;
        if (this.m_caseCheck != null) {
            this.m_caseCheck.setText(string);
        }
    }

    public boolean isDirectionVisible() {
        return this.m_directionVisible;
    }

    public void setDirectionVisible(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl != this.m_directionVisible;
        if (bl2) {
            this.m_directionVisible = bl;
            if (bl) {
                this.m_lowerGroup.add(this.m_directionButtons);
            } else {
                this.m_lowerGroup.remove(this.m_directionButtons);
            }
        }
    }

    private void approveSelection() {
        this.fireActionPerformed(FIND_SELECTION);
    }

    private void cancelSelection() {
        if (this.m_dialog != null) {
            ((Component)this.m_dialog).setVisible(false);
        }
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$Ljava$awt$event$ActionListener != null ? class$Ljava$awt$event$ActionListener : (class$Ljava$awt$event$ActionListener = FindTextPane.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$Ljava$awt$event$ActionListener != null ? class$Ljava$awt$event$ActionListener : (class$Ljava$awt$event$ActionListener = FindTextPane.class$("java.awt.event.ActionListener")), actionListener);
    }

    protected void fireActionPerformed(String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$Ljava$awt$event$ActionListener != null ? class$Ljava$awt$event$ActionListener : FindTextPane.class$("java.awt.event.ActionListener"))) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, string);
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public static Frame getFrameForComponent(Component component) {
        Frame frame = null;
        if (component != null) {
            frame = component instanceof Frame ? (Frame)component : FindTextPane.getFrameForComponent(component.getParent());
        }
        return frame;
    }

    private static void makeSameSize(JComponent[] jComponentArray) {
        Dimension dimension;
        if (jComponentArray.length == 0) {
            return;
        }
        int n = jComponentArray[0].getPreferredSize().width;
        int n2 = jComponentArray[0].getPreferredSize().height;
        int n3 = jComponentArray[0].getMaximumSize().width;
        int n4 = jComponentArray[0].getMaximumSize().height;
        int n5 = jComponentArray[0].getMinimumSize().width;
        int n6 = jComponentArray[0].getMinimumSize().height;
        int n7 = 0;
        while (n7 < jComponentArray.length) {
            dimension = null;
            dimension = jComponentArray[n7].getPreferredSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height > n) {
                n = dimension.height;
            }
            dimension = jComponentArray[n7].getMaximumSize();
            if (dimension.width > n3) {
                n3 = dimension.width;
            }
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
            dimension = jComponentArray[n7].getMinimumSize();
            if (dimension.width > n5) {
                n5 = dimension.width;
            }
            if (dimension.height > n5) {
                n5 = dimension.height;
            }
            ++n7;
        }
        Dimension dimension2 = new Dimension(n, n2);
        dimension = new Dimension(n3, n4);
        Dimension dimension3 = new Dimension(n5, n6);
        int n8 = 0;
        while (n8 < jComponentArray.length) {
            jComponentArray[n8].setPreferredSize(dimension2);
            jComponentArray[n8].setMinimumSize(dimension3);
            jComponentArray[n8].setMaximumSize(dimension);
            ++n8;
        }
    }

    static /* synthetic */ JButton access$0(FindTextPane findTextPane) {
        return findTextPane.m_approveButton;
    }

    static /* synthetic */ void access$1(FindTextPane findTextPane) {
        findTextPane.approveSelection();
    }

    static /* synthetic */ void access$2(FindTextPane findTextPane) {
        findTextPane.cancelSelection();
    }

    static /* synthetic */ JTextField access$3(FindTextPane findTextPane) {
        return findTextPane.m_editField;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FindTextPane() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.m_textEntryLabel = new JLabel(this.getTextEntryLabel());
        this.m_textEntryLabel.setDisplayedMnemonic('n');
        jPanel2.add(this.m_textEntryLabel);
        this.m_editField = new JTextField(this.getText(), this.getTextColumns());
        this.m_textEntryLabel.setLabelFor(this.m_editField);
        jPanel2.add(this.m_editField);
        FindTextPane findTextPane = this;
        if (findTextPane == null) {
            throw null;
        }
        this.m_editField.getDocument().addDocumentListener(new DocumentListener(findTextPane){
            private final /* synthetic */ FindTextPane this$0;

            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkEnable(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkEnable(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkEnable(documentEvent);
            }

            private void checkEnable(DocumentEvent documentEvent) {
                FindTextPane.access$0(this.this$0).setEnabled(documentEvent.getDocument().getLength() > 0);
            }
            {
                this.this$0 = findTextPane;
                this.constructor$0(findTextPane);
            }

            private final void constructor$0(FindTextPane findTextPane) {
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_directionButtons = new JPanel();
        this.m_directionButtons.setBorder(new TitledBorder(this.getDirectionLabel()));
        this.m_directionUp = new JRadioButton(this.getDirectionUpText());
        this.m_directionUp.setMnemonic('U');
        this.m_directionButtons.add(this.m_directionUp);
        buttonGroup.add(this.m_directionUp);
        this.m_directionDown = new JRadioButton(this.getDirectionDownText());
        this.m_directionDown.setMnemonic('D');
        this.m_directionButtons.add(this.m_directionDown);
        buttonGroup.add(this.m_directionDown);
        this.m_directionDown.setSelected(true);
        this.m_lowerGroup = new JPanel();
        this.m_lowerGroup.setLayout(new BoxLayout(this.m_lowerGroup, 0));
        this.m_caseCheck = new JCheckBox(this.getMatchCaseText());
        this.m_caseCheck.setMnemonic('c');
        this.m_lowerGroup.add(this.m_caseCheck);
        if (this.isDirectionVisible()) {
            this.m_lowerGroup.add(this.m_directionButtons);
        }
        jPanel.add(jPanel2);
        jPanel.add(this.m_lowerGroup);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_approveButton = new JButton(this.getApproveButtonText());
        this.m_approveButton.setMnemonic('F');
        FindTextPane findTextPane2 = this;
        if (findTextPane2 == null) {
            throw null;
        }
        this.m_approveButton.addActionListener(new ActionListener(findTextPane2){
            private final /* synthetic */ FindTextPane this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                FindTextPane.access$1(this.this$0);
            }
            {
                this.this$0 = findTextPane;
                this.constructor$0(findTextPane);
            }

            private final void constructor$0(FindTextPane findTextPane) {
            }
        });
        this.m_approveButton.setEnabled(false);
        jPanel3.add(this.m_approveButton);
        this.m_cancelButton = new JButton(this.getCancelButtonText());
        FindTextPane findTextPane3 = this;
        if (findTextPane3 == null) {
            throw null;
        }
        this.m_cancelButton.addActionListener(new ActionListener(findTextPane3){
            private final /* synthetic */ FindTextPane this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                FindTextPane.access$2(this.this$0);
            }
            {
                this.this$0 = findTextPane;
                this.constructor$0(findTextPane);
            }

            private final void constructor$0(FindTextPane findTextPane) {
            }
        });
        jPanel3.add(this.m_cancelButton);
        FindTextPane.makeSameSize(new JComponent[]{this.m_cancelButton, this.m_approveButton});
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel3, "East");
    }
}

