/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.EditListWriter;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.visdiff.DiffedDocument;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class DiffWriter
extends EditListWriter {
    private static final String EOL = "\n";
    private int m_tabs = 0;
    private DiffedDocument m_sourceDoc = null;
    private DiffedDocument m_targetDoc = null;
    private ParsedCharSequence m_source = null;
    private ParsedCharSequence m_target = null;
    private boolean m_diffsOnly = false;
    private boolean m_trouble = false;
    private int m_anchornum = 0;

    public void start() throws IOException {
        this.setDocumentLineType(this.m_sourceDoc, "same");
        this.setDocumentLineType(this.m_targetDoc, "same");
    }

    public void finish() throws IOException {
    }

    public void unchangedLines(int n, int n2, int n3) throws IOException {
        if (!this.m_diffsOnly) {
            int n4 = 0;
            while (n4 < n3) {
                this.setDocumentLineType(this.m_sourceDoc, "same");
                this.setDocumentLineType(this.m_targetDoc, "same");
                this.outputLine(this.m_sourceDoc, this.m_source.getLine(n + n4 - 1));
                this.outputLine(this.m_targetDoc, this.m_target.getLine(n2 + n4 - 1));
                ++n4;
            }
        }
    }

    public void insertLines(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.setDocumentLineType(this.m_sourceDoc, "miss");
            this.writeDoc((Document)this.m_sourceDoc, EOL);
            this.setDocumentLineType(this.m_targetDoc, "add");
            this.outputLine(this.m_targetDoc, this.m_target.getLine(n2 + n4 - 1));
            ++n4;
        }
    }

    public void deleteLines(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.setDocumentLineType(this.m_sourceDoc, "del");
            this.outputLine(this.m_sourceDoc, this.m_source.getLine(n + n4 - 1));
            this.setDocumentLineType(this.m_targetDoc, "miss");
            this.writeDoc((Document)this.m_targetDoc, EOL);
            ++n4;
        }
    }

    public void replaceLines(int n, int n2, int n3, int n4) throws IOException {
        this.setDocumentLineType(this.m_sourceDoc, "repl");
        int n5 = 0;
        while (n5 < n2) {
            this.outputLine(this.m_sourceDoc, this.m_source.getLine(n + n5 - 1));
            ++n5;
        }
        n5 = n2;
        while (n5 < n4) {
            this.writeDoc((Document)this.m_sourceDoc, EOL);
            ++n5;
        }
        this.setDocumentLineType(this.m_targetDoc, "repl");
        n5 = 0;
        while (n5 < n4) {
            this.outputLine(this.m_targetDoc, this.m_target.getLine(n3 + n5 - 1));
            ++n5;
        }
        n5 = n4;
        while (n5 < n2) {
            this.writeDoc((Document)this.m_targetDoc, EOL);
            ++n5;
        }
    }

    private void outputLine(Document document, CharSequence charSequence) throws IOException {
        int n = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer(n + 2);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(charSequence.charAt(n2));
            ++n2;
        }
        stringBuffer.append(EOL);
        this.writeDoc(document, stringBuffer.toString());
    }

    private int lengthNoEOL(CharSequence charSequence) {
        int n = charSequence.length() - 1;
        while (n >= 0) {
            char c = charSequence.charAt(n);
            if (c != '\r' && c != '\n') break;
            --n;
        }
        return n + 1;
    }

    private void setDocumentLineType(DiffedDocument diffedDocument, String string) {
        diffedDocument.setLineType(string);
    }

    private void writeDoc(Document document, char c) throws IOException {
        char[] cArray = new char[]{c};
        this.writeDoc(document, new String(cArray));
    }

    private void writeDoc(Document document, String string) throws IOException {
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("BadLocationException");
        }
    }

    DiffWriter() {
    }

    public DiffWriter(DiffedDocument diffedDocument, DiffedDocument diffedDocument2, int n, ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, boolean bl) {
        this();
        this.m_sourceDoc = diffedDocument;
        this.m_targetDoc = diffedDocument2;
        this.m_tabs = n;
        this.m_source = parsedCharSequence;
        this.m_target = parsedCharSequence2;
        this.m_diffsOnly = bl;
    }
}

