/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import java.io.UnsupportedEncodingException;

class EncodingSupport {
    private static String[] m_baseEncodings = new String[]{"ASCII", "8859_1", "8859_2", "8859_3", "8859_4", "8859_5", "8859_6", "8859_7", "8859_8", "8859_9", "Big5", "Cp297", "Cp278", "Cp936", "Cp950", "Cp932", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp1255", "Cp1256", "Cp1257", "Cp1258", "EUC_CN", "EUC_JP", "EUC_KR", "EUC_TW", "GBK", "ISO2022CN", "ISO2022CN_CNS", "ISO2022CN_GB", "ISO2022JP", "ISO2022KR", "KOI8_R", "SJIS", "UTF8", "Unicode"};
    private static String[] m_knownInputEncodings = null;
    private static String[] m_validInputEncodings = null;
    private static String[] m_knownOutputEncodings = null;
    private static String[] m_validOutputEncodings = null;

    public static boolean isEncodingReadSupported(String string) {
        boolean bl;
        try {
            new String(new byte[0], string);
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        return bl;
    }

    public static boolean isEncodingWriteSupported(String string) {
        boolean bl;
        try {
            "".getBytes(string);
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        return bl;
    }

    public void setKnownInputEncodings(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
            m_knownInputEncodings = stringArray2;
            EncodingSupport.checkKnownInputEncodings();
        }
    }

    public String[] getKnownInputEncodings() {
        String[] stringArray = null;
        if (m_knownInputEncodings != null) {
            stringArray = new String[m_knownInputEncodings.length];
            int n = 0;
            while (n < m_knownInputEncodings.length) {
                stringArray[n] = m_knownInputEncodings[n];
                ++n;
            }
        }
        return stringArray;
    }

    public static String[] getValidInputEncodings() {
        if (m_validInputEncodings == null) {
            EncodingSupport.checkKnownInputEncodings();
        }
        return m_validInputEncodings;
    }

    public static String[] getValidOutputEncodings() {
        if (m_validOutputEncodings == null) {
            EncodingSupport.checkKnownOutputEncodings();
        }
        return m_validOutputEncodings;
    }

    private static void checkKnownInputEncodings() {
        int n = 0;
        if (m_knownInputEncodings == null) {
            m_knownInputEncodings = m_baseEncodings;
        }
        int n2 = 0;
        while (n2 < m_knownInputEncodings.length) {
            if (EncodingSupport.isEncodingReadSupported(m_knownInputEncodings[n2])) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < m_knownInputEncodings.length) {
            if (EncodingSupport.isEncodingReadSupported(m_knownInputEncodings[n4])) {
                stringArray[n3++] = m_knownInputEncodings[n4];
            }
            ++n4;
        }
        m_validInputEncodings = stringArray;
    }

    private static void checkKnownOutputEncodings() {
        int n = 0;
        if (m_knownOutputEncodings == null) {
            m_knownOutputEncodings = m_baseEncodings;
        }
        int n2 = 0;
        while (n2 < m_knownOutputEncodings.length) {
            if (EncodingSupport.isEncodingReadSupported(m_knownOutputEncodings[n2])) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < m_knownOutputEncodings.length) {
            if (EncodingSupport.isEncodingReadSupported(m_knownOutputEncodings[n4])) {
                stringArray[n3++] = m_knownOutputEncodings[n4];
            }
            ++n4;
        }
        m_validOutputEncodings = stringArray;
    }

    EncodingSupport() {
    }
}

