/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.visdiff.TextDiffFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.swing.UIManager;

public class VisDiff {
    private TextDiffFrame m_frame;
    private String m_sourceFilename = null;
    private String m_targetFilename = null;
    private String m_sourceEncoding = "8859_1";
    private String m_targetEncoding = "8859_1";
    private String m_sourceTitle = null;
    private String m_targetTitle = null;
    private String m_localeLanguage = null;
    private String m_localeCountry = null;
    private String m_localeVarient = null;

    public static void main(String[] stringArray) {
        new VisDiff(stringArray);
    }

    private void parseArgs(String[] stringArray) {
        String string = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("*DELETE_TEMP_FILES*")) {
                if (stringArray[n].startsWith("-")) {
                    if (bl) {
                        System.out.println("error: missing argument for -" + string);
                        System.exit(1);
                    }
                    if ((string = stringArray[n].substring(1).trim()).equals("st") || string.equals("tt") || string.equals("se") || string.equals("te") || string.equals("ll") || string.equals("lc") || string.equals("lv")) {
                        bl = true;
                    } else if (string.equals("h") || string.equals("help") || string.equals("?")) {
                        this.showHelp();
                        System.exit(0);
                    } else {
                        System.out.println("error: illegal option -" + string);
                        System.exit(1);
                    }
                } else if (bl) {
                    if (string.equals("st")) {
                        this.m_sourceTitle = stringArray[n];
                    } else if (string.equals("tt")) {
                        this.m_targetTitle = stringArray[n];
                    } else if (string.equals("se")) {
                        this.m_sourceEncoding = stringArray[n];
                    } else if (string.equals("te")) {
                        this.m_targetEncoding = stringArray[n];
                    } else if (string.equals("ll")) {
                        this.m_localeLanguage = stringArray[n];
                    } else if (string.equals("lc")) {
                        this.m_localeCountry = stringArray[n];
                    } else if (string.equals("lv")) {
                        this.m_localeVarient = stringArray[n];
                    }
                    string = null;
                    bl = false;
                } else if (this.m_sourceFilename == null) {
                    this.m_sourceFilename = stringArray[n];
                } else if (this.m_targetFilename == null) {
                    this.m_targetFilename = stringArray[n];
                } else if (this.m_sourceTitle == null) {
                    this.m_sourceTitle = stringArray[n];
                } else if (this.m_targetTitle == null) {
                    this.m_targetTitle = stringArray[n];
                } else {
                    System.out.println("error: two filename arguments required");
                    System.exit(1);
                }
            }
            ++n;
        }
    }

    private boolean validateArgs() {
        boolean bl = true;
        if ((this.m_sourceFilename == null || this.m_targetFilename == null) && this.m_sourceFilename != this.m_targetFilename) {
            System.out.println("error: two filename arguments required");
            bl = false;
        }
        if (this.m_sourceEncoding != null && !this.isValidCharacterEncoding(this.m_sourceEncoding)) {
            System.out.println("error: invalid source encoding " + this.m_sourceEncoding);
            bl = false;
        }
        if (this.m_targetEncoding != null && !this.isValidCharacterEncoding(this.m_targetEncoding)) {
            System.out.println("error: invalid target encoding " + this.m_targetEncoding);
            bl = false;
        }
        if (this.m_localeCountry != null && this.m_localeLanguage == null) {
            System.out.println("error: locale: must supply a valid language when specifying country");
            bl = false;
        }
        if (this.m_localeVarient != null && this.m_localeLanguage == null) {
            System.out.println("error: locale: must supply a valid language when specifying varient");
            bl = false;
        }
        if (this.m_localeVarient != null && this.m_localeCountry == null) {
            System.out.println("error: locale: must supply a valid language when specifying varient");
            bl = false;
        }
        return bl;
    }

    private void showHelp() {
        System.out.println("NAME");
        System.out.println("     VisDiff - display line-by-line  differences  between  pairs  of text files");
        System.out.println("USAGE: VisDiff [-h]");
        System.out.println("      VisDiff [-st title] [-tt title] [-se enc] [-te enc] [-ll lc [-lc cc [-lv");
        System.out.println("      variant] ] ] filename1 filename2 [caption1] [caption2]");
        System.out.println("OPTIONS");
        System.out.println("     -st title      Sets the title to be displayed for the source file.");
        System.out.println("     -tt title      Sets the title to be displayed for the target file.");
        System.out.println("     -se enc        Sets the character encoding to be used for the source file.");
        System.out.println("     -te enc        Sets the character encoding to be used for the target file.");
        System.out.println("     -ll lc         Sets the language to use for the UI localization. lc must");
        System.out.println("                    be a valid 2-character ISO-639 language code.");
        System.out.println("     -lc cc         Sets the country to use for the UI localization. cc must be");
        System.out.println("                    a valid 2-character ISO-3166 country code. -ll must be set");
        System.out.println("                    in order to use this option.");
        System.out.println("     -lc variant    Sets the variant to use for the UI localization. -ll and");
        System.out.println("                    -lc must be set in order to use this option.");
    }

    private boolean isValidCharacterEncoding(String string) {
        boolean bl;
        try {
            new String(new byte[0], string);
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        return bl;
    }

    VisDiff(String[] stringArray) {
        Locale locale = null;
        UIManager.installLookAndFeel("Macintosh", "com.sun.java.swing.plaf.mac.MacLookAndFeel");
        this.parseArgs(stringArray);
        if (!this.validateArgs()) {
            System.exit(1);
        }
        if (this.m_localeLanguage != null) {
            locale = this.m_localeCountry != null ? (this.m_localeVarient != null ? new Locale(this.m_localeLanguage, this.m_localeCountry, this.m_localeVarient) : new Locale(this.m_localeLanguage, this.m_localeCountry)) : new Locale(this.m_localeLanguage, "");
        }
        this.m_frame = locale == null ? new TextDiffFrame() : new TextDiffFrame(locale);
        if (this.m_sourceFilename != null && this.m_targetFilename != null) {
            File file = new File(this.m_sourceFilename);
            File file2 = new File(this.m_targetFilename);
            try {
                this.m_frame.setSourceFile(file, this.m_sourceEncoding);
                this.m_frame.setTargetFile(file2, this.m_targetEncoding);
                if (this.m_sourceTitle != null) {
                    this.m_frame.setSourceTitle(this.m_sourceTitle);
                }
                if (this.m_targetTitle != null) {
                    this.m_frame.setTargetTitle(this.m_targetTitle);
                }
                this.m_frame.performDiff();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Invalid file encoding.");
            }
            catch (IOException iOException) {
                System.out.println("Error opening source files.");
            }
        }
        this.m_frame.pack();
        VisDiff visDiff = this;
        if (visDiff == null) {
            throw null;
        }
        this.m_frame.addWindowListener(new WindowAdapter(visDiff){
            private final /* synthetic */ VisDiff this$0;

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = visDiff;
                this.constructor$0(visDiff);
            }

            private final void constructor$0(VisDiff visDiff) {
            }
        });
        this.m_frame.show();
    }
}

