/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class SignJar
extends Task {
    protected File jar;
    protected String alias;
    private String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected File signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;
    private String maxMemory;
    protected Vector filesets = new Vector();
    protected boolean lazy;

    public void setMaxmemory(String max) {
        this.maxMemory = max;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setSignedjar(File signedjar) {
        this.signedjar = signedjar;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setInternalsf(boolean internalsf) {
        this.internalsf = internalsf;
    }

    public void setSectionsonly(boolean sectionsonly) {
        this.sectionsonly = sectionsonly;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        if (null == this.jar && this.filesets.size() == 0) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (null != this.jar) {
            if (this.filesets.size() != 0) {
                this.log("nested filesets will be ignored if the jar attribute has been specified.", 1);
            }
            this.doOneJar(this.jar, this.signedjar);
            return;
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] jarFiles = ds.getIncludedFiles();
            for (int j = 0; j < jarFiles.length; ++j) {
                this.doOneJar(new File(fs.getDir(this.getProject()), jarFiles[j]), null);
            }
        }
    }

    private void doOneJar(File jarSource, File jarTarget) throws BuildException {
        if (null == this.alias) {
            throw new BuildException("alias attribute must be set");
        }
        if (null == this.storepass) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate(jarSource, jarTarget)) {
            return;
        }
        ExecTask cmd = (ExecTask)this.getProject().createTask("exec");
        cmd.setExecutable(JavaEnvUtils.getJdkExecutable("jarsigner"));
        if (this.maxMemory != null) {
            cmd.createArg().setValue("-J-Xmx" + this.maxMemory);
        }
        if (null != this.keystore) {
            File keystoreFile = this.getProject().resolveFile(this.keystore);
            if (keystoreFile.exists()) {
                cmd.createArg().setValue("-keystore");
                cmd.createArg().setValue(keystoreFile.getPath());
            } else {
                cmd.createArg().setValue("-keystore");
                cmd.createArg().setValue(this.keystore);
            }
        }
        if (null != this.storepass) {
            cmd.createArg().setValue("-storepass");
            cmd.createArg().setValue(this.storepass);
        }
        if (null != this.storetype) {
            cmd.createArg().setValue("-storetype");
            cmd.createArg().setValue(this.storetype);
        }
        if (null != this.keypass) {
            cmd.createArg().setValue("-keypass");
            cmd.createArg().setValue(this.keypass);
        }
        if (null != this.sigfile) {
            cmd.createArg().setValue("-sigfile");
            cmd.createArg().setValue(this.sigfile);
        }
        if (null != jarTarget) {
            cmd.createArg().setValue("-signedjar");
            cmd.createArg().setValue(jarTarget.toString());
        }
        if (this.verbose) {
            cmd.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            cmd.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            cmd.createArg().setValue("-sectionsonly");
        }
        cmd.createArg().setValue(jarSource.toString());
        cmd.createArg().setValue(this.alias);
        this.log("Signing Jar : " + jarSource.getAbsolutePath());
        cmd.setFailonerror(true);
        cmd.setTaskName(this.getTaskName());
        cmd.execute();
    }

    protected boolean isUpToDate(File jarFile, File signedjarFile) {
        if (null == jarFile) {
            return false;
        }
        if (null != signedjarFile) {
            if (!jarFile.exists()) {
                return false;
            }
            if (!signedjarFile.exists()) {
                return false;
            }
            if (jarFile.equals(signedjarFile)) {
                return false;
            }
            if (signedjarFile.lastModified() > jarFile.lastModified()) {
                return true;
            }
        } else if (this.lazy) {
            return this.isSigned(jarFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSigned(File file) {
        block16: {
            block15: {
                block14: {
                    SIG_START = "META-INF/";
                    SIG_END = ".SF";
                    if (!file.exists()) {
                        return false;
                    }
                    jarFile = null;
                    try {
                        try {
                            jarFile = new ZipFile(file);
                            if (null == this.alias) {
                                entries = jarFile.entries();
                                while (entries.hasMoreElements()) {
                                    name = entries.nextElement().getName();
                                    if (!name.startsWith("META-INF/") || !name.endsWith(".SF")) continue;
                                    var7_11 = true;
                                    var9_12 = null;
                                    if (jarFile == null) return var7_11;
                                    break block14;
                                }
                                var6_9 = false;
                                break block15;
                            }
                            entries = jarFile.getEntry("META-INF/" + this.alias.toUpperCase() + ".SF") != null;
                            break block16;
                        }
                        catch (IOException e) {
                            var6_10 = false;
                            var9_15 = null;
                            if (jarFile == null) return var6_10;
                            try {
                                jarFile.close();
                                return var6_10;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var6_10;
                        }
                    }
                    catch (Throwable var8_22) {
                        var9_16 = null;
                        if (jarFile == null) throw var8_22;
                        try {}
                        catch (IOException e) {
                            throw var8_22;
                        }
                        jarFile.close();
                        throw var8_22;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 186->194)] { 
lbl47:
                // 1 sources

                jarFile.close();
                return var7_11;
lbl49:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var7_11;
            }
            var9_13 = null;
            if (jarFile == null) return var6_9;
            ** try [egrp 2[TRYBLOCK] [8 : 186->194)] { 
lbl56:
            // 1 sources

            jarFile.close();
            return var6_9;
lbl58:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_9;
        }
        var9_14 = null;
        if (jarFile == null) return entries;
        try {}
        catch (IOException e) {
            // empty catch block
            return entries;
        }
        jarFile.close();
        return entries;
    }
}

