/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public abstract class DefaultCompilerAdapter
implements CompilerAdapter {
    protected Path src;
    protected File destDir;
    protected String encoding;
    protected boolean debug = false;
    protected boolean optimize = false;
    protected boolean deprecation = false;
    protected boolean depend = false;
    protected boolean verbose = false;
    protected String target;
    protected Path bootclasspath;
    protected Path extdirs;
    protected Path compileClasspath;
    protected Path compileSourcepath;
    protected Project project;
    protected Location location;
    protected boolean includeAntRuntime;
    protected boolean includeJavaRuntime;
    protected String memoryInitialSize;
    protected String memoryMaximumSize;
    protected File[] compileList;
    protected static final String lSep = System.getProperty("line.separator");
    protected Javac attributes;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setJavac(Javac attributes) {
        this.attributes = attributes;
        this.src = attributes.getSrcdir();
        this.destDir = attributes.getDestdir();
        this.encoding = attributes.getEncoding();
        this.debug = attributes.getDebug();
        this.optimize = attributes.getOptimize();
        this.deprecation = attributes.getDeprecation();
        this.depend = attributes.getDepend();
        this.verbose = attributes.getVerbose();
        this.target = attributes.getTarget();
        this.bootclasspath = attributes.getBootclasspath();
        this.extdirs = attributes.getExtdirs();
        this.compileList = attributes.getFileList();
        this.compileClasspath = attributes.getClasspath();
        this.compileSourcepath = attributes.getSourcepath();
        this.project = attributes.getProject();
        this.location = attributes.getLocation();
        this.includeAntRuntime = attributes.getIncludeantruntime();
        this.includeJavaRuntime = attributes.getIncludejavaruntime();
        this.memoryInitialSize = attributes.getMemoryInitialSize();
        this.memoryMaximumSize = attributes.getMemoryMaximumSize();
    }

    public Javac getJavac() {
        return this.attributes;
    }

    protected Project getProject() {
        return this.project;
    }

    protected Path getCompileClasspath() {
        Path cp;
        Path classpath = new Path(this.project);
        if (this.destDir != null) {
            classpath.setLocation(this.destDir);
        }
        if ((cp = this.compileClasspath) == null) {
            cp = new Path(this.project);
        }
        if (this.includeAntRuntime) {
            classpath.addExisting(cp.concatSystemClasspath("last"));
        } else {
            classpath.addExisting(cp.concatSystemClasspath("ignore"));
        }
        if (this.includeJavaRuntime) {
            classpath.addJavaRuntime();
        }
        return classpath;
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline cmd) {
        return this.setupJavacCommandlineSwitches(cmd, false);
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline cmd, boolean useDebugLevel) {
        String memoryParameterPrefix;
        Path classpath = this.getCompileClasspath();
        Path sourcepath = null;
        sourcepath = this.compileSourcepath != null ? this.compileSourcepath : this.src;
        String string = memoryParameterPrefix = this.assumeJava11() ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryInitialSize setting.", 1);
            } else {
                cmd.createArgument().setValue(memoryParameterPrefix + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryMaximumSize setting.", 1);
            } else {
                cmd.createArgument().setValue(memoryParameterPrefix + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.attributes.getNowarn()) {
            cmd.createArgument().setValue("-nowarn");
        }
        if (this.deprecation) {
            cmd.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir);
        }
        cmd.createArgument().setValue("-classpath");
        if (this.assumeJava11()) {
            Path cp = new Path(this.project);
            if (this.bootclasspath != null) {
                cp.append(this.bootclasspath);
            }
            if (this.extdirs != null) {
                cp.addExtdirs(this.extdirs);
            }
            cp.append(classpath);
            cp.append(sourcepath);
            cmd.createArgument().setPath(cp);
        } else {
            cmd.createArgument().setPath(classpath);
            if (sourcepath.size() > 0) {
                cmd.createArgument().setValue("-sourcepath");
                cmd.createArgument().setPath(sourcepath);
            }
            if (this.target != null) {
                cmd.createArgument().setValue("-target");
                cmd.createArgument().setValue(this.target);
            }
            if (this.bootclasspath != null && this.bootclasspath.size() > 0) {
                cmd.createArgument().setValue("-bootclasspath");
                cmd.createArgument().setPath(this.bootclasspath);
            }
            if (this.extdirs != null && this.extdirs.size() > 0) {
                cmd.createArgument().setValue("-extdirs");
                cmd.createArgument().setPath(this.extdirs);
            }
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            if (useDebugLevel && !this.assumeJava11()) {
                String debugLevel = this.attributes.getDebugLevel();
                if (debugLevel != null) {
                    cmd.createArgument().setValue("-g:" + debugLevel);
                } else {
                    cmd.createArgument().setValue("-g");
                }
            } else {
                cmd.createArgument().setValue("-g");
            }
        } else if (!this.assumeJava11()) {
            cmd.createArgument().setValue("-g:none");
        }
        if (this.optimize) {
            cmd.createArgument().setValue("-O");
        }
        if (this.depend) {
            if (this.assumeJava11()) {
                cmd.createArgument().setValue("-depend");
            } else if (this.assumeJava12()) {
                cmd.createArgument().setValue("-Xdepend");
            } else {
                this.attributes.log("depend attribute is not supported by the modern compiler", 1);
            }
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
        }
        this.addCurrentCompilerArgs(cmd);
        return cmd;
    }

    protected Commandline setupModernJavacCommandlineSwitches(Commandline cmd) {
        this.setupJavacCommandlineSwitches(cmd, true);
        if (this.attributes.getSource() != null && !this.assumeJava13()) {
            cmd.createArgument().setValue("-source");
            cmd.createArgument().setValue(this.attributes.getSource());
        }
        return cmd;
    }

    protected Commandline setupModernJavacCommand() {
        Commandline cmd = new Commandline();
        this.setupModernJavacCommandlineSwitches(cmd);
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    protected Commandline setupJavacCommand() {
        return this.setupJavacCommand(false);
    }

    protected Commandline setupJavacCommand(boolean debugLevelCheck) {
        Commandline cmd = new Commandline();
        this.setupJavacCommandlineSwitches(cmd, debugLevelCheck);
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    protected void logAndAddFilesToCompile(Commandline cmd) {
        this.attributes.log("Compilation " + cmd.describeArguments(), 3);
        StringBuffer niceSourceList = new StringBuffer("File");
        if (this.compileList.length != 1) {
            niceSourceList.append("s");
        }
        niceSourceList.append(" to be compiled:");
        niceSourceList.append(lSep);
        for (int i = 0; i < this.compileList.length; ++i) {
            String arg = this.compileList[i].getAbsolutePath();
            cmd.createArgument().setValue(arg);
            niceSourceList.append("    " + arg + lSep);
        }
        this.attributes.log(niceSourceList.toString(), 3);
    }

    protected int executeExternalCompile(String[] args, int firstFileName) {
        return this.executeExternalCompile(args, firstFileName, true);
    }

    /*
     * Unable to fully structure code
     */
    protected int executeExternalCompile(String[] args, int firstFileName, boolean quoteFiles) {
        commandArray = null;
        tmpFile = null;
        try {
            block20: {
                if (Commandline.toString(args).length() > 4096 && firstFileName >= 0) {
                    out = null;
                    try {
                        userDir = this.getJavac().getTempdir();
                        if (userDir == null) {
                            userDirName = System.getProperty("user.dir");
                            userDir = new File(userDirName);
                        }
                        tmpFile = this.fileUtils.createTempFile("files", "", userDir);
                        tmpFile.deleteOnExit();
                        out = new PrintWriter(new FileWriter(tmpFile));
                        for (i = firstFileName; i < args.length; ++i) {
                            if (quoteFiles && args[i].indexOf(" ") > -1) {
                                args[i] = args[i].replace('\\', '/');
                                out.println("\"" + args[i] + "\"");
                                continue;
                            }
                            out.println(args[i]);
                        }
                        out.flush();
                        commandArray = new String[firstFileName + 1];
                        System.arraycopy(args, 0, commandArray, 0, firstFileName);
                        commandArray[firstFileName] = "@" + tmpFile;
                        var10_13 = null;
                        ** if (out == null) goto lbl-1000
                    }
                    catch (Throwable var9_17) {
                        var10_14 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        throw var9_17;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            out.close();
                        }
                        catch (Throwable t) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block20;
                        catch (IOException e) {
                            throw new BuildException("Error creating temporary file", e, this.location);
                        }
                    }
                }
                commandArray = args;
            }
            try {
                exe = new Execute(new LogStreamHandler(this.attributes, 2, 1));
                exe.setAntRun(this.project);
                exe.setWorkingDirectory(this.project.getBaseDir());
                exe.setCommandline(commandArray);
                exe.execute();
                var7_10 = exe.getExitValue();
                return var7_10;
            }
            catch (IOException e) {
                throw new BuildException("Error running " + args[0] + " compiler", e, this.location);
            }
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    protected void addExtdirsToClasspath(Path classpath) {
        classpath.addExtdirs(this.extdirs);
    }

    protected void addCurrentCompilerArgs(Commandline cmd) {
        cmd.addArguments(this.getJavac().getCurrentCompilerArgs());
    }

    protected boolean assumeJava11() {
        return "javac1.1".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.1") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.1");
    }

    protected boolean assumeJava12() {
        return "javac1.2".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.2") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.2");
    }

    protected boolean assumeJava13() {
        return "javac1.3".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3") || "modern".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3");
    }

    public abstract /* synthetic */ boolean execute() throws BuildException;
}

