/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class StandardQueryCache
implements QueryCache {
    private static final Log log = LogFactory.getLog((Class)StandardQueryCache.class);
    private Cache queryCache;
    private UpdateTimestampsCache updateTimestampsCache;
    private final String regionName;

    public void clear() throws CacheException {
        this.queryCache.clear();
    }

    public StandardQueryCache(Settings settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) throws HibernateException {
        String prefix;
        if (regionName == null) {
            regionName = StandardQueryCache.class.getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionName = prefix + '.' + regionName;
        }
        log.info((Object)("starting query cache at region: " + regionName));
        this.queryCache = settings.getCacheProvider().buildCache(regionName, props);
        this.updateTimestampsCache = updateTimestampsCache;
        this.regionName = regionName;
    }

    public boolean put(QueryKey key, Type[] returnTypes, List result, boolean isNaturalKeyLookup, SessionImplementor session) throws HibernateException {
        if (isNaturalKeyLookup && result.size() == 0) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching query results in region: " + this.regionName));
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        cacheable.add(new Long(session.getTimestamp()));
        for (int i = 0; i < result.size(); ++i) {
            if (returnTypes.length == 1) {
                cacheable.add(returnTypes[0].disassemble(result.get(i), session, null));
                continue;
            }
            cacheable.add(TypeFactory.disassemble((Object[])result.get(i), returnTypes, null, session, null));
        }
        this.queryCache.put(key, cacheable);
        return true;
    }

    public List get(QueryKey key, Type[] returnTypes, boolean isNaturalKeyLookup, Set spaces, SessionImplementor session) throws HibernateException {
        List cacheable;
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking cached query results in region: " + this.regionName));
        }
        if ((cacheable = (List)this.queryCache.get(key)) == null) {
            log.debug((Object)"query results were not found in cache");
            return null;
        }
        Long timestamp = (Long)cacheable.get(0);
        if (!isNaturalKeyLookup && !this.isUpToDate(spaces, timestamp)) {
            log.debug((Object)"cached query results were not up to date");
            return null;
        }
        log.debug((Object)"returning cached query results");
        for (int i = 1; i < cacheable.size(); ++i) {
            if (returnTypes.length == 1) {
                returnTypes[0].beforeAssemble((Serializable)cacheable.get(i), session);
                continue;
            }
            TypeFactory.beforeAssemble((Serializable[])cacheable.get(i), returnTypes, session);
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        for (int i = 1; i < cacheable.size(); ++i) {
            try {
                if (returnTypes.length == 1) {
                    result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                    continue;
                }
                result.add(TypeFactory.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
                continue;
            }
            catch (UnresolvableObjectException uoe) {
                if (isNaturalKeyLookup) {
                    log.debug((Object)"could not reassemble cached result set");
                    this.queryCache.remove(key);
                    return null;
                }
                throw uoe;
            }
        }
        return result;
    }

    protected boolean isUpToDate(Set spaces, Long timestamp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking query spaces for up-to-dateness: " + spaces));
        }
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp);
    }

    public void destroy() {
        try {
            this.queryCache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)("could not destroy query cache: " + this.regionName), (Throwable)e);
        }
    }

    public Cache getCache() {
        return this.queryCache;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String toString() {
        return "StandardQueryCache(" + this.regionName + ')';
    }
}

