/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.StringHelper;

public class ImprovedNamingStrategy
implements NamingStrategy,
Serializable {
    public static final NamingStrategy INSTANCE = new ImprovedNamingStrategy();

    public String classToTableName(String className) {
        return ImprovedNamingStrategy.addUnderscores(StringHelper.unqualify(className));
    }

    public String propertyToColumnName(String propertyName) {
        return ImprovedNamingStrategy.addUnderscores(propertyName);
    }

    public String tableName(String tableName) {
        return ImprovedNamingStrategy.addUnderscores(tableName);
    }

    public String columnName(String columnName) {
        return ImprovedNamingStrategy.addUnderscores(columnName);
    }

    public String propertyToTableName(String className, String propertyName) {
        return this.classToTableName(className) + '_' + this.propertyToColumnName(propertyName);
    }

    private static String addUnderscores(String name) {
        StringBuffer buf = new StringBuffer(name.replace('.', '_'));
        for (int i = 1; i < buf.length() - 1; ++i) {
            if (!Character.isLowerCase(buf.charAt(i - 1)) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, '_');
        }
        return buf.toString().toLowerCase();
    }
}

