/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.Registry;

public class JndiJmx
extends BaseModelMBean
implements NotificationListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$modeler$JndiJmx == null ? (class$org$apache$commons$modeler$JndiJmx = JndiJmx.class$("org.apache.commons.modeler.JndiJmx")) : class$org$apache$commons$modeler$JndiJmx));
    protected Context componentContext;
    protected Context descriptorContext;
    protected Context configContext;
    MBeanServer mserver;
    Hashtable attributes = new Hashtable();
    Hashtable instances = new Hashtable();
    static /* synthetic */ Class class$org$apache$commons$modeler$JndiJmx;

    public JndiJmx() throws MBeanException {
        super((class$org$apache$commons$modeler$JndiJmx == null ? (class$org$apache$commons$modeler$JndiJmx = JndiJmx.class$("org.apache.commons.modeler.JndiJmx")) : class$org$apache$commons$modeler$JndiJmx).getName());
    }

    public void setComponentContext(Context ctx) {
        this.componentContext = ctx;
    }

    public void setDescriptorContext(Context ctx) {
        this.descriptorContext = ctx;
    }

    public void setConfigContext(Context ctx) {
        this.configContext = ctx;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification msnot = (MBeanServerNotification)notification;
            ObjectName oname = msnot.getMBeanName();
            if ("jmx.mbean.created".equalsIgnoreCase(notification.getType())) {
                try {
                    ObjectInstance mbean = this.mserver.getObjectInstance(oname);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("MBean created " + oname + " " + mbean));
                    }
                    if (mbean instanceof NotificationBroadcaster) {
                        NotificationBroadcaster nb = (NotificationBroadcaster)((Object)mbean);
                        nb.addNotificationListener(this, null, null);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Add attribute change listener");
                        }
                    }
                    this.instances.put(oname.toString(), mbean);
                }
                catch (InstanceNotFoundException ex) {
                    log.error((Object)"Instance not found for the created object", (Throwable)ex);
                }
            }
            if ("jmx.mbean.deleted".equalsIgnoreCase(notification.getType())) {
                this.instances.remove(oname.toString());
            }
        }
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification anotif = (AttributeChangeNotification)notification;
            String name = anotif.getAttributeName();
            Object value = anotif.getNewValue();
            Object source = anotif.getSource();
            Object mname = null;
            Hashtable<String, AttributeChangeNotification> mbeanAtt = (Hashtable<String, AttributeChangeNotification>)this.attributes.get(source);
            if (mbeanAtt == null) {
                mbeanAtt = new Hashtable<String, AttributeChangeNotification>();
                this.attributes.put(source, mbeanAtt);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("First attribute for " + source));
                }
            }
            mbeanAtt.put(name, anotif);
            log.debug((Object)("Attribute change notification " + name + " " + value + " " + source));
        }
    }

    public String dumpStatus() throws Exception {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.instances.keys();
        while (en.hasMoreElements()) {
            String on = (String)en.nextElement();
            Object mbean = this.instances.get(on);
            Hashtable mbeanAtt = (Hashtable)this.attributes.get(mbean);
            sb.append("<mbean class=\"").append(on).append("\">");
            sb.append("\n");
            Enumeration attEn = mbeanAtt.keys();
            while (attEn.hasMoreElements()) {
                String an = (String)attEn.nextElement();
                AttributeChangeNotification anotif = (AttributeChangeNotification)mbeanAtt.get(an);
                sb.append("  <attribute name=\"").append(an).append("\" ");
                sb.append("value=\"").append(anotif.getNewValue()).append("\">");
                sb.append("\n");
            }
            sb.append("</mbean>");
            sb.append("\n");
        }
        return sb.toString();
    }

    public void replay() throws Exception {
    }

    public void init() throws Exception {
        MBeanServer mserver = Registry.getRegistry().getMBeanServer();
        ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        mserver.addNotificationListener(delegate, this, null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

