/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.util;

import java.rmi.RemoteException;
import org.apache.bsf.debug.util.RemoteServiceListener;
import org.apache.bsf.debug.util.SocketConnection;

public class Skeleton {
    private static int gUidGenerator = 9999;
    private static Object lock = new Object();
    int m_tid;
    int m_uid;
    SocketConnection m_con;

    protected Skeleton(int n) throws RemoteException {
        this.m_tid = n;
        this.m_uid = 4;
    }

    protected Skeleton(int n, int n2) throws RemoteException {
        this.m_tid = n;
        this.m_uid = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof Skeleton) {
            return this.m_uid == ((Skeleton)object).m_uid;
        }
        return false;
    }

    public void allocOid(SocketConnection socketConnection) {
        Object object = lock;
        synchronized (object) {
            this.m_con = socketConnection;
            if (this.m_uid == 4) {
                this.m_uid = gUidGenerator++;
            }
        }
    }

    public boolean hasNoUid() {
        return this.m_uid == 4;
    }

    public int getTid() {
        return this.m_tid;
    }

    public int getUid() {
        return this.m_uid;
    }

    public void addListener(RemoteServiceListener remoteServiceListener) throws RemoteException {
        throw new Error("Not to be called on the local service.");
    }

    public void removeListener(RemoteServiceListener remoteServiceListener) throws RemoteException {
        throw new Error("Not to be called on the local service.");
    }

    public void createFuture(Object object) throws RemoteException {
        throw new Error("Not to be called on the local service.");
    }

    public void suspendFuture(Object object) throws RemoteException {
        throw new Error("Not to be called on the local service.");
    }

    public void completeFuture(Object object) throws RemoteException {
        throw new Error("Not to be called on the local service.");
    }
}

