/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import rath.msnm.BuddyGroup;
import rath.msnm.BuddyList;
import rath.msnm.Debug;
import rath.msnm.LocalCopy;
import rath.msnm.NotificationProcessor;
import rath.msnm.SwitchboardSession;
import rath.msnm.entity.MsnFriend;
import rath.msnm.entity.ServerInfo;
import rath.msnm.event.MsnAdapter;
import rath.msnm.event.MsnListener;
import rath.msnm.ftp.ToSendFile;
import rath.msnm.ftp.VolatileDownloader;
import rath.msnm.ftp.VolatileTransferServer;
import rath.msnm.msg.FileTransferMessage;
import rath.msnm.msg.MimeMessage;

public class MSNMessenger {
    private NotificationProcessor ns = null;
    private BuddyGroup buddyGroup = null;
    private BuddyList forwardList = null;
    private LocalCopy localCopy = null;
    boolean isLogged = false;
    public boolean is911 = false;
    private byte[] bPhoto = null;
    private BufferedImage imgPhoto = null;
    private String ctxPhoto = null;
    private String loginName = null;
    private String password = null;
    private String initStatus = "NLN";
    private MsnListener base = null;
    protected ArrayList listeners = new ArrayList();
    private MsnFriend owner = null;
    private Hashtable sessionMap = new Hashtable();

    public MSNMessenger() {
        this(null, null);
    }

    public MSNMessenger(String loginName, String password) {
        this.loginName = loginName;
        this.password = password;
        this.owner = new MsnFriend(loginName);
        this.base = new Listener();
        this.buddyGroup = BuddyGroup.getInstance();
        this.forwardList = this.buddyGroup.getForwardList();
        this.localCopy = new LocalCopy();
    }

    private void initLogon() {
        this.buddyGroup.clear();
        this.localCopy.setLoginName(this.loginName);
        this.localCopy.loadInformation();
        this.ns.lastFrom = this.localCopy.getProperty("SerialFrom", "0");
        this.ns.lastTo = this.localCopy.getProperty("SerialTo", "0");
        this.ns.lastFN = this.localCopy.getProperty("FriendlyName", this.loginName);
        this.localCopy.loadBuddies(this.buddyGroup);
    }

    void storeLocalCopy(String from, String to) {
        this.localCopy.setProperty("SerialFrom", from);
        this.localCopy.setProperty("SerialTo", to);
        this.localCopy.setProperty("FriendlyName", this.owner.getFriendlyName());
        this.localCopy.storeInformation();
        this.localCopy.storeBuddies(this.buddyGroup);
        this.fireBuddyListModifiedEvent();
    }

    public BuddyGroup getBuddyGroup() {
        return this.buddyGroup;
    }

    public LocalCopy getLocalCopy() {
        return this.localCopy;
    }

    public void setInitialStatus(String code) {
        this.initStatus = code;
    }

    public String getInitialStatus() {
        return this.initStatus;
    }

    public boolean isLoggedIn() {
        return this.isLogged;
    }

    public synchronized void addMsnListener(MsnListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public void fireListAdd(MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireListAdd");
        }
        this.base.listAdd(friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).listAdd(friend);
        }
    }

    public void fireInstantMessageEvent(SwitchboardSession ss, MsnFriend friend, MimeMessage mime) {
        this.fireInstantMessageEventImpl(ss, friend, mime);
    }

    protected void fireInstantMessageEventImpl(SwitchboardSession ss, MsnFriend friend, MimeMessage mime) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireInstantMessageEvent");
        }
        this.base.instantMessageReceived(ss, friend, mime);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).instantMessageReceived(ss, friend, mime);
        }
    }

    protected void fireJoinSessionEventImpl(SwitchboardSession ss, MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireJoinSessionEvent");
        }
        this.base.whoJoinSession(ss, friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).whoJoinSession(ss, friend);
        }
    }

    public void fireJoinSessionEvent(SwitchboardSession ss, MsnFriend friend) {
        this.fireJoinSessionEventImpl(ss, friend);
    }

    protected void fireListOnlineEventImpl(MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireListOnlineEvent");
        }
        this.base.listOnline(friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).listOnline(friend);
        }
    }

    public void fireListOnlineEvent(MsnFriend friend) {
        this.fireListOnlineEventImpl(friend);
    }

    protected void fireLoginCompleteEventImpl(MsnFriend own) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireLoginCompleteEvent");
        }
        this.base.loginComplete(own);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).loginComplete(own);
        }
    }

    public void fireLoginCompleteEvent(MsnFriend own) {
        this.fireLoginCompleteEventImpl(own);
    }

    protected void firePartSessionEventImpl(SwitchboardSession ss, MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: firePartSessionEvent");
        }
        this.base.whoPartSession(ss, friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).whoPartSession(ss, friend);
        }
    }

    public void firePartSessionEvent(SwitchboardSession ss, MsnFriend friend) {
        this.firePartSessionEventImpl(ss, friend);
    }

    protected void fireProgressTypingEventImpl(SwitchboardSession ss, MsnFriend friend, String typeuser) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireProgressTypingEvent");
        }
        this.base.progressTyping(ss, friend, typeuser);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).progressTyping(ss, friend, typeuser);
        }
    }

    public void fireProgressTypingEvent(SwitchboardSession ss, MsnFriend friend, String typeuser) {
        this.fireProgressTypingEventImpl(ss, friend, typeuser);
    }

    protected void fireSwitchboardSessionStartedEventImpl(SwitchboardSession ss) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireSwitchboardSessionStartedEvent");
        }
        this.base.switchboardSessionStarted(ss);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).switchboardSessionStarted(ss);
        }
    }

    public void fireSwitchboardSessionStartedEvent(SwitchboardSession ss) {
        this.fireSwitchboardSessionStartedEventImpl(ss);
    }

    protected void fireSwitchboardSessionEndedEventImpl(SwitchboardSession ss) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireSwitchboardSessionEndedEvent");
        }
        this.base.switchboardSessionEnded(ss);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).switchboardSessionEnded(ss);
        }
    }

    public void fireSwitchboardSessionEndedEvent(SwitchboardSession ss) {
        this.fireSwitchboardSessionEndedEventImpl(ss);
    }

    protected void fireSwitchboardSessionAbandonEventImpl(SwitchboardSession ss, String targetName) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireSwitchboardSessionAbandonEvent");
        }
        this.base.switchboardSessionAbandon(ss, targetName);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).switchboardSessionAbandon(ss, targetName);
        }
    }

    public void fireSwitchboardSessionAbandonEvent(SwitchboardSession ss, String targetName) {
        this.fireSwitchboardSessionAbandonEventImpl(ss, targetName);
    }

    protected void fireUserOnlineEventImpl(MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireUserOnlineEvent");
        }
        this.base.userOnline(friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).userOnline(friend);
        }
    }

    public void fireUserOnlineEvent(MsnFriend friend) {
        this.fireUserOnlineEventImpl(friend);
    }

    protected void fireUserOfflineEventImpl(String loginName) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireUserOfflineEvent");
        }
        this.base.userOffline(loginName);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).userOffline(loginName);
        }
    }

    public void fireUserOfflineEvent(String loginName) {
        this.fireUserOfflineEventImpl(loginName);
    }

    protected void fireFilePostedEventImpl(SwitchboardSession ss, int cookie, String filename, int filesize) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFilePostedEvent");
        }
        this.base.filePosted(ss, cookie, filename, filesize);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).filePosted(ss, cookie, filename, filesize);
        }
    }

    public void fireFilePostedEvent(SwitchboardSession ss, int cookie, String filename, int filesize) {
        this.fireFilePostedEventImpl(ss, cookie, filename, filesize);
    }

    protected void fireFileSendAcceptedEventImpl(SwitchboardSession ss, int cookie) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileSendAcceptedEvent");
        }
        this.base.fileSendAccepted(ss, cookie);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileSendAccepted(ss, cookie);
        }
    }

    public void fireFileSendAcceptedEvent(SwitchboardSession ss, int cookie) {
        this.fireFileSendAcceptedEventImpl(ss, cookie);
    }

    protected void fireFileSendRejectedEventImpl(SwitchboardSession ss, int cookie, String reason) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileSendRejectedEvent");
        }
        this.base.fileSendRejected(ss, cookie, reason);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileSendRejected(ss, cookie, reason);
        }
    }

    public void fireFileSendRejectedEvent(SwitchboardSession ss, int cookie, String reason) {
        this.fireFileSendRejectedEventImpl(ss, cookie, reason);
    }

    protected void fireFileSendStartedEventImpl(VolatileTransferServer server) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileSendStartedEvent");
        }
        this.base.fileSendStarted(server);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileSendStarted(server);
        }
    }

    public void fireFileSendStartedEvent(VolatileTransferServer server) {
        this.fireFileSendStartedEventImpl(server);
    }

    protected void fireFileSendEndedEventImpl(VolatileTransferServer server) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileSendEndedEvent");
        }
        this.base.fileSendEnded(server);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileSendEnded(server);
        }
    }

    public void fireFileSendEndedEvent(VolatileTransferServer server) {
        this.fireFileSendEndedEventImpl(server);
    }

    protected void fireFileReceiveStartedEventImpl(VolatileDownloader down) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileReceiveStartedEvent");
        }
        this.base.fileReceiveStarted(down);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileReceiveStarted(down);
        }
    }

    public void fireFileReceiveStartedEvent(VolatileDownloader down) {
        this.fireFileReceiveStartedEventImpl(down);
    }

    protected void fireFileSendErrorEventImpl(VolatileTransferServer server, Throwable e) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileSendErrorEvent");
        }
        this.base.fileSendError(server, e);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileSendError(server, e);
        }
    }

    public void fireFileSendErrorEvent(VolatileTransferServer server, Throwable e) {
        this.fireFileSendErrorEventImpl(server, e);
    }

    protected void fireFileReceiveErrorEventImpl(VolatileDownloader down, Throwable e) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireFileReceiveErrorEvent");
        }
        this.base.fileReceiveError(down, e);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).fileReceiveError(down, e);
        }
    }

    public void fireFileReceiveErrorEvent(VolatileDownloader down, Throwable e) {
        this.fireFileReceiveErrorEventImpl(down, e);
    }

    protected void fireWhoAddedMeEventImpl(MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireWhoAddedMeEvent");
        }
        this.base.whoAddedMe(friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).whoAddedMe(friend);
        }
    }

    public void fireWhoAddedMeEvent(MsnFriend friend) {
        this.fireWhoAddedMeEventImpl(friend);
    }

    protected void fireWhoRemovedMeEventImpl(MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireWhoRemovedMeEvent");
        }
        this.base.whoRemovedMe(friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).whoRemovedMe(friend);
        }
    }

    public void fireWhoRemovedMeEvent(MsnFriend friend) {
        this.fireWhoRemovedMeEventImpl(friend);
    }

    protected void fireBuddyListModifiedEventImpl() {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireBuddyListModifiedEvent");
        }
        this.base.buddyListModified();
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).buddyListModified();
        }
    }

    public void fireBuddyListModifiedEvent() {
        this.fireBuddyListModifiedEventImpl();
    }

    protected void fireAddFailedEventImpl(int errcode) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireAddFailedEvent");
        }
        this.base.addFailed(errcode);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).addFailed(errcode);
        }
    }

    public void fireAddFailedEvent(int errcode) {
        this.fireAddFailedEventImpl(errcode);
    }

    protected void fireLoginErrorEventImpl(String header) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireLoginErrorEvent");
        }
        this.base.loginError(header);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).loginError(header);
        }
    }

    public void fireLoginErrorEvent(String header) {
        this.fireLoginErrorEventImpl(header);
    }

    protected void fireRenameNotifyEventImpl(MsnFriend friend) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireRenameNotifyEvent");
        }
        this.base.renameNotify(friend);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).renameNotify(friend);
        }
    }

    public void fireRenameNotifyEvent(MsnFriend friend) {
        this.fireRenameNotifyEventImpl(friend);
    }

    protected void fireAllListUpdatedEventImpl() {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireAllListUpdatedEvent");
        }
        this.base.allListUpdated();
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).allListUpdated();
        }
    }

    public void fireAllListUpdatedEvent() {
        this.fireAllListUpdatedEventImpl();
    }

    protected void fireLogoutNotifyEventImpl() {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireLogoutNotifyEvent");
        }
        this.base.logoutNotify();
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).logoutNotify();
        }
    }

    public void fireLogoutNotifyEvent() {
        this.fireLogoutNotifyEventImpl();
    }

    protected void fireNotifyUnreadMailImpl(Properties mime, int unread) {
        if (Debug.printFireEvent) {
            System.out.println("* Event: fireNotifyUnreadMail");
        }
        this.base.notifyUnreadMail(mime, unread);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((MsnListener)this.listeners.get(i)).notifyUnreadMail(mime, unread);
        }
    }

    public void fireNotifyUnreadMail(Properties mime, int unread) {
        this.fireNotifyUnreadMailImpl(mime, unread);
    }

    public synchronized void removeMsnListener(MsnListener l) {
        this.listeners.remove(l);
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public MsnFriend getOwner() {
        return this.owner;
    }

    private void dispatch() {
        throw new UnsupportedOperationException("DispatchServer not allowed");
    }

    protected void loginImpl() {
        this.ns = new NotificationProcessor(this, ServerInfo.getDefaultServerInfo(), 1);
        this.initLogon();
        this.ns.start();
    }

    public void login(String username, String password) {
        this.loginName = username;
        this.password = password;
        this.loginImpl();
    }

    public void login() {
        if (this.loginName == null || this.password == null) {
            throw new IllegalArgumentException("Login name and password must not be null");
        }
        this.login(this.loginName, this.password);
    }

    public void logout() {
        Enumeration e = this.sessionMap.elements();
        while (e.hasMoreElements()) {
            SwitchboardSession ss = (SwitchboardSession)e.nextElement();
            ss.interrupt();
            ss.cleanUp();
        }
        this.sessionMap.clear();
        if (this.ns != null) {
            this.ns.interrupt();
            try {
                this.ns.logout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ns = null;
        }
    }

    public void setMyStatus(String status) throws IOException {
        this.ns.setMyStatus(status);
    }

    public String getMyStatus() {
        if (this.ns == null) {
            return "FLN";
        }
        return this.ns.getMyStatus();
    }

    public void setMyFriendlyName(String newName) throws IOException {
        this.ns.setMyFriendlyName(newName);
    }

    public void doCall(String loginName) throws IOException {
        this.ns.doCallFriend(loginName);
    }

    public void addFriend(String loginName) throws IOException {
        this.ns.requestAdd(loginName);
    }

    public void addFriendAsList(String loginName, String listKind) throws IOException, IllegalArgumentException {
        this.ns.requestAddAsList(loginName, listKind);
    }

    public void blockFriend(String loginName) throws IOException {
        this.ns.requestBlock(loginName, false);
    }

    public void unBlockFriend(String loginName) throws IOException {
        this.ns.requestBlock(loginName, true);
    }

    public void removeFriend(String loginName) throws IOException {
        this.ns.requestRemove(loginName);
    }

    public void removeFriendAsList(String loginName, String listKind) throws IOException, IllegalArgumentException {
        this.ns.requestRemoveAsList(loginName, listKind);
    }

    public void addGroup(String groupName) throws IOException {
        this.ns.requestCreateGroup(groupName);
    }

    public void removeGroup(String groupIndex) throws IOException {
        this.ns.requestRemoveGroup(groupIndex);
    }

    public void renameGroup(String groupIndex, String newName) throws IOException {
        this.ns.requestRenameGroup(groupIndex, newName);
    }

    public void moveGroupAsFriend(MsnFriend friend, String oldIndex, String newIndex) throws IOException {
        this.ns.requestMoveGroup(friend, oldIndex, newIndex);
    }

    public SwitchboardSession doCallWait(String loginName) throws IOException, InterruptedException {
        return this.ns.doCallFriendWait(loginName);
    }

    public SwitchboardSession findSwitchboardSession(String loginName) {
        Enumeration e = this.sessionMap.elements();
        while (e.hasMoreElements()) {
            SwitchboardSession ss = (SwitchboardSession)e.nextElement();
            if (!ss.isInFriend(loginName)) continue;
            return ss;
        }
        return null;
    }

    public SwitchboardSession findSwitchboardSessionAt(String loginName) {
        Enumeration e = this.sessionMap.elements();
        while (e.hasMoreElements()) {
            SwitchboardSession ss = (SwitchboardSession)e.nextElement();
            if (ss.getFriendCount() != 1 || !ss.isInFriend(loginName)) continue;
            return ss;
        }
        return null;
    }

    public boolean sendMessage(String loginName, MimeMessage msg) throws IOException {
        SwitchboardSession ss = this.findSwitchboardSession(loginName);
        if (ss != null) {
            ss.sendMessage(msg);
            return true;
        }
        return false;
    }

    public boolean sendMessage(String loginName, MimeMessage msg, String sessionId) throws IOException {
        SwitchboardSession ss = (SwitchboardSession)this.sessionMap.get(sessionId);
        if (ss == null) {
            return this.sendMessage(loginName, msg);
        }
        ss.sendMessage(msg);
        return true;
    }

    public boolean sendMessage(MimeMessage msg, SwitchboardSession session) throws IOException {
        if (session != null) {
            session.sendMessage(msg);
            return true;
        }
        return false;
    }

    public void sendFileRequest(String loginName, File file, String sessionId) throws IOException {
        if (sessionId == null) {
            throw new IllegalArgumentException("session id must not be null");
        }
        this.sendFileRequest(loginName, file, (SwitchboardSession)this.sessionMap.get(sessionId));
    }

    public void sendFileRequest(String loginName, File file, SwitchboardSession session) throws IOException {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        FileTransferMessage msg = FileTransferMessage.createInviteMessage(file);
        ToSendFile toSend = new ToSendFile(msg.getProperty("Invitation-Cookie"), loginName, file);
        session.sendFileRequest(toSend, msg);
    }

    public List getOpenedSwitchboardSessions() {
        ArrayList list = new ArrayList();
        list.addAll(this.sessionMap.values());
        return list;
    }

    private class Listener
    extends MsnAdapter {
        private Listener() {
        }

        public void renameNotify(MsnFriend own) {
            if (own != null && MSNMessenger.this.owner.getLoginName().equals(own.getLoginName())) {
                MSNMessenger.this.owner.setFriendlyName(own.getFriendlyName());
            }
        }

        public void loginComplete(MsnFriend own) {
            MSNMessenger.this.isLogged = true;
            MSNMessenger.this.owner = own;
        }

        public void logoutNotify() {
            MSNMessenger.this.isLogged = false;
        }

        public void listOnline(MsnFriend friend) {
            MSNMessenger.this.forwardList.add(friend);
        }

        public void userOnline(MsnFriend friend) {
            MSNMessenger.this.forwardList.add(friend);
        }

        public void userOffline(String loginName) {
            MSNMessenger.this.forwardList.setOffline(loginName);
        }

        public void switchboardSessionStarted(SwitchboardSession ss) {
            String sid = ss.getSessionId();
            if (sid == null) {
                return;
            }
            MSNMessenger.this.sessionMap.put(sid, ss);
        }

        public void switchboardSessionEnded(SwitchboardSession ss) {
            String sid = ss.getSessionId();
            MSNMessenger.this.sessionMap.remove(sid);
        }

        public void whoAddedMe(MsnFriend friend) {
            System.out.println(friend + " Add me.");
        }

        public void whoRemovedMe(MsnFriend friend) {
            System.out.println(friend.getLoginName() + " remove me.");
        }
    }
}

