/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.OutputStream;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.event.ChangeObserver;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.event.PageValidateListener;
import org.apache.tapestry.util.StringSplitter;

public abstract class AbstractPage
extends BaseComponent
implements IPage {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$AbstractPage == null ? (class$org$apache$tapestry$AbstractPage = AbstractPage.class$("org.apache.tapestry.AbstractPage")) : class$org$apache$tapestry$AbstractPage));
    private ChangeObserver _changeObserver;
    private IEngine _engine;
    private Object _visit;
    private String _pageName;
    private IRequestCycle _requestCycle;
    private Locale _locale;
    private EventListenerList _listenerList;
    private String _outputEncoding;
    static /* synthetic */ Class class$org$apache$tapestry$AbstractPage;
    static /* synthetic */ Class class$org$apache$tapestry$event$PageDetachListener;
    static /* synthetic */ Class class$org$apache$tapestry$event$PageRenderListener;
    static /* synthetic */ Class class$org$apache$tapestry$event$PageValidateListener;

    public AbstractPage() {
        this.initialize();
    }

    public abstract IMarkupWriter getResponseWriter(OutputStream var1);

    public void detach() {
        Tapestry.addMethodInvocation("AbstractPage.detach()");
        this._changeObserver = null;
        this.firePageDetached();
        this.initialize();
        this._engine = null;
        this._visit = null;
        this._requestCycle = null;
    }

    protected void initialize() {
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public ChangeObserver getChangeObserver() {
        return this._changeObserver;
    }

    public String getExtendedId() {
        return this._pageName;
    }

    public String getIdPath() {
        return null;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale value) {
        if (this._locale != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractPage.attempt-to-change-locale"));
        }
        this._locale = value;
    }

    public IComponent getNestedComponent(String path) {
        if (path == null) {
            return this;
        }
        StringSplitter splitter = new StringSplitter('.');
        IComponent current = this;
        String[] elements = splitter.splitToArray(path);
        for (int i = 0; i < elements.length; ++i) {
            current = current.getComponent(elements[i]);
        }
        return current;
    }

    public void attach(IEngine value) {
        if (this._engine != null) {
            LOG.error((Object)(this + " attach(" + value + "), but engine = " + this._engine));
        }
        this._engine = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(IMarkupWriter writer, IRequestCycle cycle) {
        try {
            this.firePageBeginRender();
            this.beginResponse(writer, cycle);
            if (!cycle.isRewinding()) {
                cycle.commitPageChanges();
            }
            this.render(writer, cycle);
        }
        finally {
            this.firePageEndRender();
        }
    }

    public void setChangeObserver(ChangeObserver value) {
        this._changeObserver = value;
    }

    public void setPageName(String pageName) {
        if (this._pageName != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractPage.attempt-to-change-name"));
        }
        this._pageName = pageName;
    }

    public void validate(IRequestCycle cycle) {
        Tapestry.addMethodInvocation("AbstractPage.validate()");
        this.firePageValidate();
    }

    public void beginResponse(IMarkupWriter writer, IRequestCycle cycle) {
    }

    public IRequestCycle getRequestCycle() {
        return this._requestCycle;
    }

    public void setRequestCycle(IRequestCycle value) {
        this._requestCycle = value;
    }

    public Object getVisit() {
        if (this._visit == null) {
            this._visit = this._engine.getVisit(this._requestCycle);
        }
        return this._visit;
    }

    public Object getGlobal() {
        return this._engine.getGlobal();
    }

    public void addPageDetachListener(PageDetachListener listener) {
        this.addListener(class$org$apache$tapestry$event$PageDetachListener == null ? (class$org$apache$tapestry$event$PageDetachListener = AbstractPage.class$("org.apache.tapestry.event.PageDetachListener")) : class$org$apache$tapestry$event$PageDetachListener, listener);
    }

    private void addListener(Class listenerClass, EventListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(listenerClass, listener);
    }

    private void removeListener(Class listenerClass, EventListener listener) {
        if (this._listenerList != null) {
            this._listenerList.remove(listenerClass, listener);
        }
    }

    public void addPageRenderListener(PageRenderListener listener) {
        this.addListener(class$org$apache$tapestry$event$PageRenderListener == null ? (class$org$apache$tapestry$event$PageRenderListener = AbstractPage.class$("org.apache.tapestry.event.PageRenderListener")) : class$org$apache$tapestry$event$PageRenderListener, listener);
    }

    protected void firePageDetached() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$org$apache$tapestry$event$PageDetachListener == null ? AbstractPage.class$("org.apache.tapestry.event.PageDetachListener") : class$org$apache$tapestry$event$PageDetachListener)) continue;
            PageDetachListener l = (PageDetachListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageDetached(event);
        }
    }

    protected void firePageBeginRender() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$org$apache$tapestry$event$PageRenderListener == null ? AbstractPage.class$("org.apache.tapestry.event.PageRenderListener") : class$org$apache$tapestry$event$PageRenderListener)) continue;
            PageRenderListener l = (PageRenderListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageBeginRender(event);
        }
    }

    protected void firePageEndRender() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$org$apache$tapestry$event$PageRenderListener == null ? AbstractPage.class$("org.apache.tapestry.event.PageRenderListener") : class$org$apache$tapestry$event$PageRenderListener)) continue;
            PageRenderListener l = (PageRenderListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageEndRender(event);
        }
    }

    public void removePageDetachListener(PageDetachListener listener) {
        this.removeListener(class$org$apache$tapestry$event$PageDetachListener == null ? (class$org$apache$tapestry$event$PageDetachListener = AbstractPage.class$("org.apache.tapestry.event.PageDetachListener")) : class$org$apache$tapestry$event$PageDetachListener, listener);
    }

    public void removePageRenderListener(PageRenderListener listener) {
        this.removeListener(class$org$apache$tapestry$event$PageRenderListener == null ? (class$org$apache$tapestry$event$PageRenderListener = AbstractPage.class$("org.apache.tapestry.event.PageRenderListener")) : class$org$apache$tapestry$event$PageRenderListener, listener);
    }

    public void beginPageRender() {
        this.firePageBeginRender();
    }

    public void endPageRender() {
        this.firePageEndRender();
    }

    public String getPageName() {
        return this._pageName;
    }

    public void addPageValidateListener(PageValidateListener listener) {
        this.addListener(class$org$apache$tapestry$event$PageValidateListener == null ? (class$org$apache$tapestry$event$PageValidateListener = AbstractPage.class$("org.apache.tapestry.event.PageValidateListener")) : class$org$apache$tapestry$event$PageValidateListener, listener);
    }

    public void removePageValidateListener(PageValidateListener listener) {
        this.removeListener(class$org$apache$tapestry$event$PageValidateListener == null ? (class$org$apache$tapestry$event$PageValidateListener = AbstractPage.class$("org.apache.tapestry.event.PageValidateListener")) : class$org$apache$tapestry$event$PageValidateListener, listener);
    }

    protected void firePageValidate() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$org$apache$tapestry$event$PageValidateListener == null ? AbstractPage.class$("org.apache.tapestry.event.PageValidateListener") : class$org$apache$tapestry$event$PageValidateListener)) continue;
            PageValidateListener l = (PageValidateListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageValidate(event);
        }
    }

    protected String getOutputEncoding() {
        if (this._outputEncoding == null) {
            this._outputEncoding = this.getEngine().getOutputEncoding();
        }
        return this._outputEncoding;
    }

    public void pageActivated(IRequestCycle cycle) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

