/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceLocation;

public class Location
implements ILocation {
    private IResourceLocation _resourceLocation;
    private int _lineNumber = -1;
    private int _columnNumber = -1;

    public Location(IResourceLocation location) {
        this._resourceLocation = location;
    }

    public Location(IResourceLocation location, int lineNumber) {
        this(location);
        this._lineNumber = lineNumber;
    }

    public Location(IResourceLocation location, int lineNumber, int columnNumber) {
        this(location);
        this._lineNumber = lineNumber;
        this._columnNumber = columnNumber;
    }

    public IResourceLocation getResourceLocation() {
        return this._resourceLocation;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getColumnNumber() {
        return this._columnNumber;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(237, 53);
        builder.append((Object)this._resourceLocation);
        builder.append(this._lineNumber);
        builder.append(this._columnNumber);
        return builder.toHashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ILocation)) {
            return false;
        }
        ILocation l = (ILocation)other;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this._lineNumber, l.getLineNumber());
        builder.append(this._columnNumber, l.getColumnNumber());
        builder.append((Object)this._resourceLocation, (Object)l.getResourceLocation());
        return builder.isEquals();
    }

    public String toString() {
        if (this._lineNumber <= 0 && this._columnNumber <= 0) {
            return this._resourceLocation.toString();
        }
        StringBuffer buffer = new StringBuffer(this._resourceLocation.toString());
        if (this._lineNumber > 0) {
            buffer.append(", line ");
            buffer.append(this._lineNumber);
        }
        if (this._columnNumber > 0) {
            buffer.append(", column ");
            buffer.append(this._columnNumber);
        }
        return buffer.toString();
    }
}

