/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.RenderRewoundException;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.util.IdAllocator;
import org.apache.tapestry.util.StringSplitter;
import org.apache.tapestry.valid.IValidationDelegate;

public abstract class Form
extends AbstractComponent
implements IForm,
IDirect {
    private boolean _rewinding;
    private boolean _rendering;
    private String _name;
    private int _allocatedIdIndex;
    private List _allocatedIds = new ArrayList();
    private Map _events;
    private static final int EVENT_MAP_SIZE = 3;
    private IdAllocator _elementIdAllocator = new IdAllocator();
    private String _encodingType;
    private List _hiddenValues;

    public static IForm get(IRequestCycle cycle) {
        return (IForm)cycle.getAttribute("org.apache.tapestry.active.Form");
    }

    public boolean isRewinding() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public abstract boolean isDirect();

    public boolean getRequiresSession() {
        return this.isStateful();
    }

    public String getElementId(IFormComponent component) {
        return this.getElementId(component, component.getId());
    }

    public String getElementId(IFormComponent component, String baseId) {
        String result = this._elementIdAllocator.allocateId(baseId);
        if (this._rewinding) {
            if (this._allocatedIdIndex >= this._allocatedIds.size()) {
                throw new StaleLinkException(Tapestry.format("Form.too-many-ids", this.getExtendedId(), Integer.toString(this._allocatedIds.size()), component.getExtendedId()), this);
            }
            String expected = (String)this._allocatedIds.get(this._allocatedIdIndex);
            if (!result.equals(expected)) {
                throw new StaleLinkException(Tapestry.format("Form.id-mismatch", new Object[]{this.getExtendedId(), Integer.toString(this._allocatedIdIndex + 1), expected, result, component.getExtendedId()}), this);
            }
        } else {
            this._allocatedIds.add(result);
        }
        ++this._allocatedIdIndex;
        component.setName(result);
        return result;
    }

    public String getName() {
        return this._name;
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.getAttribute("org.apache.tapestry.active.Form") != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Form.forms-may-not-nest"), this, null, null);
        }
        cycle.setAttribute("org.apache.tapestry.active.Form", this);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._rendering = false;
        this._allocatedIdIndex = 0;
        this._allocatedIds.clear();
        this._events = null;
        this._elementIdAllocator.clear();
        if (this._hiddenValues != null) {
            this._hiddenValues.clear();
        }
        cycle.removeAttribute("org.apache.tapestry.active.Form");
        this._encodingType = null;
        IValidationDelegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.setFormComponent(null);
        }
        super.cleanupAfterRender(cycle);
    }

    protected void writeAttributes(IMarkupWriter writer, ILink link) {
        String method = this.getMethod();
        writer.begin(this.getTag());
        writer.attribute("method", method == null ? "post" : method);
        writer.attribute("name", this._name);
        writer.attribute("action", link.getURL(null, false));
        if (this._encodingType != null) {
            writer.attribute("enctype", this._encodingType);
        }
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean rewound;
        String actionId = cycle.getNextActionId();
        this._name = this.getDisplayName() + actionId;
        boolean renderForm = !cycle.isRewinding();
        this._rewinding = rewound = cycle.isRewound(this);
        this._allocatedIdIndex = 0;
        this._rendering = true;
        if (rewound) {
            String storedIdList = cycle.getRequestContext().getParameter(this._name);
            this.reconstructAllocatedIds(storedIdList);
        }
        ILink link = this.getLink(cycle, actionId);
        IMarkupWriter nested = writer.getNestedWriter();
        this.renderBody(nested, cycle);
        if (renderForm) {
            this.writeAttributes(writer, link);
            this.renderInformalParameters(writer, cycle);
            writer.println();
        }
        this.writeLinkParameters(writer, link, !renderForm);
        if (renderForm) {
            this.writeHiddenField(writer, this._name, this.buildAllocatedIdList());
            this.writeHiddenValues(writer);
            nested.close();
            writer.end(this.getTag());
            this.emitEventHandlers(writer, cycle);
        }
        if (rewound) {
            int expected = this._allocatedIds.size();
            if (this._allocatedIdIndex < expected) {
                String nextExpectedId = (String)this._allocatedIds.get(this._allocatedIdIndex);
                throw new StaleLinkException(Tapestry.format("Form.too-few-ids", this.getExtendedId(), Integer.toString(expected - this._allocatedIdIndex), nextExpectedId), this);
            }
            IActionListener listener = this.getListener();
            if (listener != null) {
                listener.actionTriggered(this, cycle);
            }
            throw new RenderRewoundException(this);
        }
    }

    public void addEventHandler(FormEventType type, String functionName) {
        Object value;
        if (this._events == null) {
            this._events = new HashMap(3);
        }
        if ((value = this._events.get((Object)type)) == null) {
            this._events.put(type, functionName);
            return;
        }
        if (value instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            list.add(functionName);
            this._events.put(type, list);
            return;
        }
        List list = (List)value;
        list.add(functionName);
    }

    protected void emitEventHandlers(IMarkupWriter writer, IRequestCycle cycle) {
        if (this._events == null || this._events.isEmpty()) {
            return;
        }
        Body body = Body.get(cycle);
        if (body == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Form.needs-body-for-event-handlers"), this, null, null);
        }
        StringBuffer buffer = new StringBuffer();
        Iterator i = this._events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            FormEventType type = (FormEventType)((Object)entry.getKey());
            Object value = entry.getValue();
            buffer.append("document.");
            buffer.append(this._name);
            buffer.append(".");
            buffer.append(type.getPropertyName());
            buffer.append(" = ");
            if (value instanceof String) {
                buffer.append(value.toString());
                buffer.append(";");
            } else {
                buffer.append("function ()\n{\n");
                boolean combineWithAnd = type.getCombineUsingAnd();
                List l = (List)value;
                int count = l.size();
                for (int j = 0; j < count; ++j) {
                    String functionName = (String)l.get(j);
                    if (j > 0) {
                        if (combineWithAnd) {
                            buffer.append(" &&");
                        } else {
                            buffer.append(";");
                        }
                    }
                    buffer.append("\n  ");
                    if (combineWithAnd) {
                        if (j == 0) {
                            buffer.append("return ");
                        } else {
                            buffer.append("  ");
                        }
                    }
                    buffer.append(functionName);
                    buffer.append("()");
                }
                buffer.append(";\n}");
            }
            buffer.append("\n\n");
        }
        body.addInitializationScript(buffer.toString());
    }

    public void rewind(IMarkupWriter writer, IRequestCycle cycle) {
        this.render(writer, cycle);
    }

    public void trigger(IRequestCycle cycle) {
        Object[] parameters = cycle.getServiceParameters();
        cycle.rewindForm(this, (String)parameters[0]);
    }

    private ILink getLink(IRequestCycle cycle, String actionId) {
        String serviceName = null;
        serviceName = this.isDirect() ? "direct" : "action";
        IEngine engine = cycle.getEngine();
        IEngineService service = engine.getService(serviceName);
        return service.getLink(cycle, this, new String[]{actionId});
    }

    private void writeLinkParameters(IMarkupWriter writer, ILink link, boolean reserveOnly) {
        Object[] names = link.getParameterNames();
        int count = Tapestry.size(names);
        for (int i = 0; i < count; ++i) {
            Object name = names[i];
            this._elementIdAllocator.allocateId((String)name);
            if (reserveOnly) continue;
            this.writeHiddenFieldsForParameter(writer, link, (String)name);
        }
    }

    protected void writeHiddenField(IMarkupWriter writer, String name, String value) {
        this.writeHiddenField(writer, name, null, value);
    }

    protected void writeHiddenField(IMarkupWriter writer, String name, String id, String value) {
        writer.beginEmpty("input");
        writer.attribute("type", "hidden");
        writer.attribute("name", name);
        if (id != null && id.length() != 0) {
            writer.attribute("id", id);
        }
        writer.attribute("value", value);
        writer.println();
    }

    private void writeHiddenFieldsForParameter(IMarkupWriter writer, ILink link, String parameterName) {
        String[] values = link.getParameterValues(parameterName);
        for (int i = 0; i < values.length; ++i) {
            this.writeHiddenField(writer, parameterName, values[i]);
        }
    }

    protected String buildAllocatedIdList() {
        StringBuffer buffer = new StringBuffer();
        int count = this._allocatedIds.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this._allocatedIds.get(i));
        }
        return buffer.toString();
    }

    protected void reconstructAllocatedIds(String storedIdList) {
        if (Tapestry.isBlank(storedIdList)) {
            return;
        }
        StringSplitter splitter = new StringSplitter(',');
        String[] ids = splitter.splitToArray(storedIdList);
        for (int i = 0; i < ids.length; ++i) {
            this._allocatedIds.add(ids[i]);
        }
    }

    public abstract IValidationDelegate getDelegate();

    public abstract void setDelegate(IValidationDelegate var1);

    public abstract void setDirect(boolean var1);

    public abstract IActionListener getListener();

    public abstract String getMethod();

    public boolean isStateful() {
        IBinding statefulBinding = this.getStatefulBinding();
        if (statefulBinding == null) {
            return true;
        }
        return statefulBinding.getBoolean();
    }

    public abstract IBinding getStatefulBinding();

    protected void finishLoad() {
        this.setDirect(true);
    }

    public void setEncodingType(String encodingType) {
        if (this._encodingType != null && !this._encodingType.equals(encodingType)) {
            throw new ApplicationRuntimeException(Tapestry.format("Form.encoding-type-contention", this.getExtendedId(), this._encodingType, encodingType), this, null, null);
        }
        this._encodingType = encodingType;
    }

    protected String getTag() {
        return "form";
    }

    protected String getDisplayName() {
        return "Form";
    }

    public void addHiddenValue(String name, String value) {
        if (this._hiddenValues == null) {
            this._hiddenValues = new ArrayList();
        }
        this._hiddenValues.add(new HiddenValue(name, value));
    }

    public void addHiddenValue(String name, String id, String value) {
        if (this._hiddenValues == null) {
            this._hiddenValues = new ArrayList();
        }
        this._hiddenValues.add(new HiddenValue(name, id, value));
    }

    protected void writeHiddenValues(IMarkupWriter writer) {
        int count = Tapestry.size(this._hiddenValues);
        for (int i = 0; i < count; ++i) {
            HiddenValue hv = (HiddenValue)this._hiddenValues.get(i);
            this.writeHiddenField(writer, hv._name, hv._id, hv._value);
        }
    }

    private static class HiddenValue {
        String _name;
        String _value;
        String _id;

        private HiddenValue(String name, String value) {
            this(name, null, value);
        }

        private HiddenValue(String name, String id, String value) {
            this._name = name;
            this._id = id;
            this._value = value;
        }
    }
}

