/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.link;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.ILinkRenderer;

public class DefaultLinkRenderer
implements ILinkRenderer {
    public static final ILinkRenderer SHARED_INSTANCE = new DefaultLinkRenderer();

    public void renderLink(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent linkComponent) {
        IMarkupWriter wrappedWriter = null;
        if (cycle.getAttribute("org.apache.tapestry.active-link-component") != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractLinkComponent.no-nesting"), linkComponent, null, null);
        }
        cycle.setAttribute("org.apache.tapestry.active-link-component", linkComponent);
        boolean hasBody = this.getHasBody();
        boolean disabled = linkComponent.isDisabled();
        if (!disabled) {
            ILink l = linkComponent.getLink(cycle);
            if (hasBody) {
                writer.begin(this.getElement());
            } else {
                writer.beginEmpty(this.getElement());
            }
            writer.attribute(this.getUrlAttribute(), this.constructURL(l, linkComponent.getAnchor(), cycle));
            this.beforeBodyRender(writer, cycle, linkComponent);
            wrappedWriter = writer.getNestedWriter();
        } else {
            wrappedWriter = writer;
        }
        if (hasBody) {
            linkComponent.renderBody(wrappedWriter, cycle);
        }
        if (!disabled) {
            this.afterBodyRender(writer, cycle, linkComponent);
            linkComponent.renderAdditionalAttributes(writer, cycle);
            if (hasBody) {
                wrappedWriter.close();
                writer.end();
            } else {
                writer.closeTag();
            }
        }
        cycle.removeAttribute("org.apache.tapestry.active-link-component");
    }

    protected String constructURL(ILink link, String anchor, IRequestCycle cycle) {
        return link.getURL(anchor, true);
    }

    protected void beforeBodyRender(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent link) {
    }

    protected void afterBodyRender(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent link) {
    }

    protected String getElement() {
        return "a";
    }

    protected String getUrlAttribute() {
        return "href";
    }

    protected boolean getHasBody() {
        return true;
    }
}

