/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import java.util.Collection;
import java.util.Iterator;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.pageload.IComponentVisitor;

public class ComponentTreeWalker {
    private IComponentVisitor[] _visitors;

    public ComponentTreeWalker(IComponentVisitor[] visitors) {
        this._visitors = visitors;
    }

    public void walkComponentTree(IComponent component) {
        for (int i = 0; i < this._visitors.length; ++i) {
            IComponentVisitor visitor = this._visitors[i];
            visitor.visitComponent(component);
        }
        Collection components = component.getComponents().values();
        if (Tapestry.size(components) == 0) {
            return;
        }
        Iterator it = components.iterator();
        while (it.hasNext()) {
            IComponent embedded = (IComponent)it.next();
            this.walkComponentTree(embedded);
        }
    }
}

