/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.pageload.PageLoader;
import org.apache.tapestry.resolver.PageSpecificationResolver;
import org.apache.tapestry.util.MultiKey;
import org.apache.tapestry.util.pool.Pool;

public class PageSource
implements IPageSource {
    private static final String PAGE_LOADER_POOL_KEY = "org.apache.tapestry.PageLoader";
    private static final String PAGE_SPECIFICATION_RESOLVER_KEY = "org.apache.tapestry.PageSpecificationResolver";
    private IResourceResolver _resolver;
    private Pool _pool;

    public PageSource(IEngine engine) {
        this._resolver = engine.getResourceResolver();
        this._pool = engine.getPool();
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    protected MultiKey buildKey(IEngine engine, String pageName) {
        Object[] keys = new Object[]{pageName, engine.getLocale()};
        return new MultiKey(keys, false);
    }

    protected MultiKey buildKey(IPage page) {
        Object[] keys = new Object[]{page.getPageName(), page.getLocale()};
        return new MultiKey(keys, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPage getPage(IRequestCycle cycle, String pageName, IMonitor monitor) {
        IEngine engine = cycle.getEngine();
        MultiKey key = this.buildKey(engine, pageName);
        IPage result = (IPage)this._pool.retrieve(key);
        if (result == null) {
            monitor.pageCreateBegin(pageName);
            PageSpecificationResolver pageSpecificationResolver = this.getPageSpecificationResolver(cycle);
            pageSpecificationResolver.resolve(cycle, pageName);
            PageLoader loader = this.getPageLoader(cycle);
            try {
                result = loader.loadPage(pageSpecificationResolver.getSimplePageName(), pageSpecificationResolver.getNamespace(), cycle, pageSpecificationResolver.getSpecification());
            }
            finally {
                this.discardPageLoader(loader);
                this.discardPageSpecificationResolver(pageSpecificationResolver);
            }
            monitor.pageCreateEnd(pageName);
        } else {
            result.attach(engine);
            result.setRequestCycle(cycle);
        }
        return result;
    }

    protected PageLoader getPageLoader(IRequestCycle cycle) {
        PageLoader result = (PageLoader)this._pool.retrieve(PAGE_LOADER_POOL_KEY);
        if (result == null) {
            result = new PageLoader(cycle);
        }
        return result;
    }

    protected void discardPageLoader(PageLoader loader) {
        this._pool.store(PAGE_LOADER_POOL_KEY, loader);
    }

    protected PageSpecificationResolver getPageSpecificationResolver(IRequestCycle cycle) {
        PageSpecificationResolver result = (PageSpecificationResolver)this._pool.retrieve(PAGE_SPECIFICATION_RESOLVER_KEY);
        if (result == null) {
            result = new PageSpecificationResolver(cycle);
        }
        return result;
    }

    protected void discardPageSpecificationResolver(PageSpecificationResolver resolver) {
        this._pool.store(PAGE_SPECIFICATION_RESOLVER_KEY, resolver);
    }

    public void releasePage(IPage page) {
        Tapestry.clearMethodInvocations();
        page.detach();
        Tapestry.checkMethodInvocation("AbstractPage.detach()", "detach()", page);
        this._pool.store(this.buildKey(page), page);
    }

    public synchronized void reset() {
        this._pool.clear();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("pool", (Object)this._pool);
        builder.append("resolver", (Object)this._resolver);
        return builder.toString();
    }
}

