/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.param;

import ognl.ClassResolver;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.param.IParameterConnector;
import org.apache.tapestry.spec.Direction;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.util.prop.OgnlUtils;

public abstract class AbstractParameterConnector
implements IParameterConnector {
    private String _parameterName;
    private String _propertyName;
    private IBinding _binding;
    private IComponent _component;
    private boolean _required;
    private Object _clearValue;
    private Direction _direction;
    private IResourceResolver _resolver;

    protected AbstractParameterConnector(IComponent component, String parameterName, IBinding binding) {
        this._component = component;
        this._parameterName = parameterName;
        this._binding = binding;
        this._resolver = component.getPage().getEngine().getResourceResolver();
        IParameterSpecification pspec = this._component.getSpecification().getParameter(this._parameterName);
        this._required = pspec.isRequired();
        this._propertyName = pspec.getPropertyName();
        this._direction = pspec.getDirection();
        this._clearValue = this.readCurrentPropertyValue();
    }

    private Object readCurrentPropertyValue() {
        return OgnlUtils.get(this._propertyName, (ClassResolver)this._resolver, (Object)this._component);
    }

    protected void setPropertyValue(Object value) {
        OgnlUtils.set(this._propertyName, (ClassResolver)this._resolver, (Object)this._component, value);
    }

    protected Object getBindingValue(Class requiredType) {
        Object result = requiredType == null ? this._binding.getObject() : this._binding.getObject(this._parameterName, requiredType);
        return result;
    }

    protected IBinding getBinding() {
        return this._binding;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('[');
        buffer.append(this._component.getExtendedId());
        buffer.append(' ');
        buffer.append(this._parameterName);
        buffer.append(' ');
        buffer.append(this._binding);
        buffer.append(' ');
        buffer.append(this._direction.getName());
        if (this._required) {
            buffer.append(" required");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void resetParameter(IRequestCycle cycle) {
        IForm form;
        IFormComponent component;
        if (this._direction == Direction.FORM && cycle.isRewinding() && !(component = (IFormComponent)this._component).isDisabled() && (form = Form.get(cycle)) != null && form.isRewinding()) {
            Object value = this.readCurrentPropertyValue();
            this._binding.setObject(value);
        }
        this.setPropertyValue(this._clearValue);
    }

    protected boolean shouldSetPropertyValue(IRequestCycle cycle) {
        if (this._direction == Direction.IN) {
            return true;
        }
        return !cycle.isRewinding();
    }

    public abstract /* synthetic */ void setParameter(IRequestCycle var1);
}

