/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import java.util.Iterator;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.parse.AbstractSpecificationRule;
import org.apache.tapestry.spec.IBindingSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.util.xml.DocumentParseException;
import org.xml.sax.Attributes;

public class ComponentCopyOfRule
extends AbstractSpecificationRule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String id = this.getValue(attributes, "id");
        String copyOf = this.getValue(attributes, "copy-of");
        String type = this.getValue(attributes, "type");
        if (Tapestry.isBlank(copyOf)) {
            if (Tapestry.isBlank(type)) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.missing-type-or-copy-of", id), this.getResourceLocation());
            }
            return;
        }
        if (Tapestry.isNonBlank(type)) {
            throw new DocumentParseException(Tapestry.format("SpecificationParser.both-type-and-copy-of", id), this.getResourceLocation());
        }
        IComponentSpecification spec = (IComponentSpecification)this.digester.getRoot();
        IContainedComponent source = spec.getComponent(copyOf);
        if (source == null) {
            throw new DocumentParseException(Tapestry.format("SpecificationParser.unable-to-copy", copyOf), this.getResourceLocation());
        }
        IContainedComponent target = (IContainedComponent)this.digester.peek();
        target.setType(source.getType());
        target.setCopyOf(copyOf);
        Iterator i = source.getBindingNames().iterator();
        while (i.hasNext()) {
            String bindingName = (String)i.next();
            IBindingSpecification binding = source.getBinding(bindingName);
            target.setBinding(bindingName, binding);
        }
    }
}

