/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.util.HashMap;
import java.util.Locale;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class EmailValidator
extends BaseValidator {
    private int _minimumLength;
    private String _minimumLengthMessage;
    private String _invalidEmailFormatMessage;
    private String _scriptPath = "/org/apache/tapestry/valid/EmailValidator.script";

    public EmailValidator() {
    }

    private EmailValidator(boolean required) {
        super(required);
    }

    public String toString(IFormComponent field, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        if (this.checkRequired(field, input)) {
            return null;
        }
        if (this._minimumLength > 0 && input.length() < this._minimumLength) {
            throw new ValidatorException(this.buildMinimumLengthMessage(field), ValidationConstraint.MINIMUM_WIDTH);
        }
        if (!this.isValidEmail(input)) {
            throw new ValidatorException(this.buildInvalidEmailFormatMessage(field), ValidationConstraint.EMAIL_FORMAT);
        }
        return input;
    }

    public int getMinimumLength() {
        return this._minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this._minimumLength = minimumLength;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        Locale locale = field.getPage().getLocale();
        String displayName = field.getDisplayName();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        if (this._minimumLength > 0) {
            symbols.put("minimumLengthMessage", this.buildMinimumLengthMessage(field));
        }
        String pattern = this.getPattern(this.getInvalidEmailFormatMessage(), "invalid-email-format", locale);
        symbols.put("emailFormatMessage", this.formatString(pattern, displayName));
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    protected boolean isValidEmail(String email) {
        int atIndex = email.indexOf(64);
        return atIndex != -1 && atIndex != 0 && atIndex != email.length() - 1;
    }

    public String getInvalidEmailFormatMessage() {
        return this._invalidEmailFormatMessage;
    }

    public String getMinimumLengthMessage() {
        return this._minimumLengthMessage;
    }

    public void setInvalidEmailFormatMessage(String string) {
        this._invalidEmailFormatMessage = string;
    }

    public void setMinimumLengthMessage(String string) {
        this._minimumLengthMessage = string;
    }

    protected String buildMinimumLengthMessage(IFormComponent field) {
        String pattern = this.getPattern(this._minimumLengthMessage, "field-too-short", field.getPage().getLocale());
        return this.formatString(pattern, Integer.toString(this._minimumLength), field.getDisplayName());
    }

    protected String buildInvalidEmailFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this._invalidEmailFormatMessage, "invalid-email-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }
}

