/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.ConfigurationFacade;

import java.net.MalformedURLException;

/**
 * This sample demonstrates how to set next build version of a configuration. This is useful
 * if you want to manage build version outside of QuickBuild.
 */
public class ControlBuildVersion {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        ConfigurationFacade configuration = remote.getConfigurationByHierarchyName("root.live-samples.test");
        if (configuration == null)
            throw new RuntimeException("Specified configuration does not exist!");
        // here we only set next build version. Of course, you can change anything of this configuration.
        configuration.setNextBuildVersion("mynextversion1");
        remote.saveConfiguration(configuration);
        
        System.out.println("Next build version has been set successfully!");
    }
}
