/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.GroupFacade;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Iterator;

/**
 * This sample demonstrates how to dump all existing groups in your system.
 */
public class DumpAllGroups {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        List groups = remote.getGroups();
        for (Iterator it = groups.iterator(); it.hasNext();) {
            GroupFacade group = (GroupFacade) it.next();
            System.out.println(group.getName());
        }
    }
}
