/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.BuildRelatedUrls;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.BuildFacade;
import com.pmease.quickbuild.model.ConfigurationFacade;

import java.io.IOException;

/**
 * This sample demonstrates how to get information of a particular build. This is very useful if you
 * want to access information for a particular build from other systems such as an issue tracking
 * application.
 */
public class GetBuildByVersion {
    public static void main(String[] args) throws IOException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        ConfigurationFacade configuration = remote.getConfigurationByHierarchyName("root.live-samples.test");
        if (configuration == null)
            throw new RuntimeException("Can not find specified configuration!");
        BuildFacade build = remote.getBuildByVersion(configuration.getId(), "test-1.0.0");
        if (build == null)
            System.out.println("Specified build can not ben found!");
        else {
            System.out.println("Information about build \"" + build.getVersion() + "\":");
            System.out.println("Build status: " + build.getStatus());
            System.out.println("Build finish date: " + build.getEndDate());
            BuildRelatedUrls urls = remote.getBuildRelatedUrls(build.getId());

            System.out.println("Build URL: " + urls.getBuildUrl());
        }
    }
}
