/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.util.Hashtable;
import org.mortbay.html.Block;
import org.mortbay.html.CompositeFactory;

public class Table
extends Block {
    private Block row = null;
    private Block cell = null;
    private static Hashtable threadNestingMap = null;
    private CompositeFactory cellNestFactory = null;
    private Block _defaultHead = null;
    private Block _defaultCell = null;
    private Block _defaultRow = null;

    public Table() {
        super("table");
        if (threadNestingMap != null) {
            this.cellNestFactory = (CompositeFactory)threadNestingMap.get(Thread.currentThread());
        }
    }

    public Table(int n) {
        super("table");
        this.attribute("border", n);
        if (threadNestingMap != null) {
            this.cellNestFactory = (CompositeFactory)threadNestingMap.get(Thread.currentThread());
        }
    }

    public Table(int n, String string) {
        this(n);
        this.attribute(string);
    }

    public Table newRow() {
        this.unnest();
        this.row = new Block("tr");
        this.nest(this.row);
        if (this._defaultRow != null) {
            this.row.setAttributesFrom(this._defaultRow);
            if (this._defaultRow.size() > 0) {
                this.row.add(this._defaultRow.contents());
            }
        }
        this.cell = null;
        return this;
    }

    public Table newRow(String string) {
        this.newRow();
        this.row.attribute(string);
        return this;
    }

    private void newBlock(String string) {
        if (this.row == null) {
            this.newRow();
        } else {
            this.row.unnest();
        }
        this.cell = new Block(string);
        this.row.nest(this.cell);
        if (this.cellNestFactory != null) {
            this.cell.nest(this.cellNestFactory.newComposite());
        }
    }

    public Table newCell() {
        this.newBlock("td");
        if (this._defaultCell != null) {
            this.cell.setAttributesFrom(this._defaultCell);
            if (this._defaultCell.size() > 0) {
                this.cell.add(this._defaultCell.contents());
            }
        }
        return this;
    }

    public Table newCell(String string) {
        this.newCell();
        this.cell.attribute(string);
        return this;
    }

    public Table addCell(Object object) {
        this.newCell();
        this.cell.add(object);
        return this;
    }

    public Table addCell(Object object, String string) {
        this.addCell(object);
        this.cell.attribute(string);
        return this;
    }

    public Table newHeading() {
        this.newBlock("th");
        if (this._defaultHead != null) {
            this.cell.setAttributesFrom(this._defaultHead);
            if (this._defaultHead.size() > 0) {
                this.cell.add(this._defaultHead.contents());
            }
        }
        return this;
    }

    public Table addHeading(Object object) {
        this.newHeading();
        this.cell.add(object);
        return this;
    }

    public Table addHeading(Object object, String string) {
        this.addHeading(object);
        this.cell.attribute(string);
        return this;
    }

    public Table cellSpacing(int n) {
        this.attribute("cellspacing", n);
        return this;
    }

    public Table cellPadding(int n) {
        this.attribute("cellpadding", n);
        return this;
    }

    public Table spacing(int n, int n2) {
        if (n >= 0) {
            this.attribute("hspace", n);
        }
        if (n2 >= 0) {
            this.attribute("vspace", n2);
        }
        return this;
    }

    public Block row() {
        return this.row;
    }

    public Block cell() {
        return this.cell;
    }

    public static void setCellNestingFactory(CompositeFactory compositeFactory) {
        if (threadNestingMap == null) {
            threadNestingMap = new Hashtable();
        }
        if (compositeFactory == null) {
            threadNestingMap.remove(Thread.currentThread());
        } else {
            threadNestingMap.put(Thread.currentThread(), compositeFactory);
        }
    }

    public static void setThreadNestingFactory(CompositeFactory compositeFactory) {
        if (threadNestingMap == null) {
            threadNestingMap = new Hashtable();
        }
        if (compositeFactory == null) {
            threadNestingMap.remove(Thread.currentThread());
        } else {
            threadNestingMap.put(Thread.currentThread(), compositeFactory);
        }
    }

    public void setNestingFactory(CompositeFactory compositeFactory) {
        this.cellNestFactory = compositeFactory;
    }

    public Block defaultRow() {
        if (this._defaultRow == null) {
            this._defaultRow = new Block("tr");
        }
        return this._defaultRow;
    }

    public Block defaultHead() {
        if (this._defaultHead == null) {
            this._defaultHead = new Block("th");
        }
        return this._defaultHead;
    }

    public Block defaultCell() {
        if (this._defaultCell == null) {
            this._defaultCell = new Block("td");
        }
        return this._defaultCell;
    }
}

