/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.mortbay.html.Composite;
import org.mortbay.html.Element;
import org.mortbay.html.Form;
import org.mortbay.html.Input;
import org.mortbay.html.Select;
import org.mortbay.html.Table;
import org.mortbay.html.TextArea;

public class TableForm
extends Form {
    private Table table = null;
    private Table column = null;
    private int columns = 1;
    private Composite hidden = new Composite();
    private Composite buttons = null;
    private Composite bottomButtons = null;
    private String fieldAttributes = null;
    private boolean extendRow = false;

    public TableForm(String string) {
        super(string);
        this.newTable();
        super.add(this.hidden);
    }

    public void addText(String string, String string2) {
        Composite composite = new Composite();
        composite.add(string2);
        this.addField(string, composite);
    }

    public Input addTextField(String string, String string2, int n, String string3) {
        Input input = new Input("text", string, string3);
        input.setSize(n);
        this.addField(string2, input);
        return input;
    }

    public TextArea addTextArea(String string, String string2, int n, int n2, String string3) {
        TextArea textArea = new TextArea(string, string3);
        textArea.setSize(n, n2);
        this.addField(string2, textArea);
        return textArea;
    }

    public Input addFileField(String string, String string2) {
        Input input = new Input("file", string);
        this.addField(string2, input);
        return input;
    }

    public void addInfoField(String string, String string2, String string3) {
        this.addText(string2, string3);
        this.addHiddenField(string, string3);
    }

    public void addHiddenField(String string, String string2) {
        Input input = new Input("hidden", string, string2);
        this.hidden.add(input);
    }

    public void addPassword(String string, String string2, int n) {
        Input input = new Input("password", string);
        input.setSize(n);
        this.addField(string2, input);
    }

    public void addCheckbox(String string, String string2, boolean bl) {
        Input input = new Input("checkbox", string);
        this.addField(string2, input);
        if (bl) {
            input.check();
        }
    }

    public Select addSelect(String string, String string2, boolean bl, int n) {
        Select select = new Select(string, bl);
        select.setSize(n);
        this.addField(string2, select);
        return select;
    }

    public Select addSelect(String string, String string2, boolean bl, int n, Enumeration enumeration) {
        Select select = this.addSelect(string, string2, bl, n);
        select.setSize(n);
        while (enumeration.hasMoreElements()) {
            select.add(enumeration.nextElement().toString());
        }
        return select;
    }

    public void addButtonArea(String string) {
        this.buttons = new Composite();
        this.addField(string, this.buttons);
    }

    public void addButtonArea() {
        this.buttons = new Composite();
        this.addField(null, this.buttons);
    }

    public void addButtonRow() {
        this.buttons = new Composite();
        if (!this.extendRow) {
            this.column.newRow();
            this.column.addCell(this.buttons).left().middle();
            this.column.cell().attribute("colspan", "2");
        }
        this.extendRow = false;
    }

    public void buttonsAtBottom() {
        if (this.bottomButtons != null) {
            this.buttons = this.bottomButtons;
        } else {
            this.bottomButtons = this.buttons = new Composite();
        }
    }

    public Input addButton(String string, String string2) {
        if (this.buttons == null) {
            this.buttonsAtBottom();
        }
        Input input = new Input("submit", string, string2);
        if (this.extendRow) {
            this.addField(null, input);
        } else {
            this.buttons.add(input);
        }
        return input;
    }

    public void addReset(String string) {
        if (this.buttons == null) {
            this.buttonsAtBottom();
        }
        Input input = new Input("reset", "Reset", string);
        if (this.extendRow) {
            this.addField(null, input);
        } else {
            this.buttons.add(input);
        }
    }

    public void useAttributes(String string) {
        this.fieldAttributes = string;
    }

    public Table table() {
        return this.column;
    }

    public Table outerTable() {
        return this.table;
    }

    public TableForm extendRow() {
        this.extendRow = true;
        return this;
    }

    public void addField(String string, Element element) {
        string = string == null ? "&nbsp;" : "<b>" + string + ":</b>";
        if (this.extendRow) {
            this.column.add(element);
            this.extendRow = false;
        } else {
            this.column.newRow();
            this.column.addCell(string);
            this.column.cell().right();
            if (this.fieldAttributes != null) {
                this.column.addCell(element, this.fieldAttributes);
                this.fieldAttributes = null;
            } else {
                this.column.addCell(element);
            }
        }
    }

    public void addColumn() {
        this.column = new Table(0);
        this.table.addCell(this.column).top();
        ++this.columns;
    }

    public void addColumn(int n) {
        this.table.addCell("&nbsp", "width=" + n);
        this.column = new Table(0);
        this.table.addCell(this.column);
        this.table.cell().top();
        ++this.columns;
    }

    public void newColumns() {
        this.column = new Table(0);
        this.columns = 1;
        this.table.newRow();
        this.table.addCell(this.column);
        this.table.cell().top();
    }

    public void setColumnSpan(int n) {
        this.table.cell().attribute("colspan", "" + n);
    }

    public void newTable() {
        this.table = new Table(0);
        this.column = new Table(0);
        this.columns = 1;
        super.add(this.table);
        this.table.newRow();
        this.table.addCell(this.column).top();
    }

    public void write(Writer writer) throws IOException {
        if (this.bottomButtons != null) {
            this.table.newRow();
            this.table.addCell(this.bottomButtons).attribute("colspan", this.columns);
        }
        super.write(writer);
    }
}

