/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpFields;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;

public class ChunkingInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(ChunkingInputStream.class);
    private static final String __UNEXPECTED_EOF = "Unexpected EOF while chunking";
    int _chunkSize = 0;
    HttpFields _trailer = null;
    LineInput _in;

    public ChunkingInputStream(LineInput lineInput) {
        this._in = lineInput;
    }

    public void resetStream() {
        this._chunkSize = 0;
        this._trailer = null;
    }

    public int read() throws IOException {
        int n = -1;
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        n = this._in.read();
        if (n < 0) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        --this._chunkSize;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        if (n > this._chunkSize) {
            n = this._chunkSize;
        }
        if ((n = this._in.read(byArray, 0, n)) < 0) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        this._chunkSize -= n;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        if (n2 > this._chunkSize) {
            n2 = this._chunkSize;
        }
        if ((n2 = this._in.read(byArray, n, n2)) < 0) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        this._chunkSize -= n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1L;
        }
        if (l > (long)this._chunkSize) {
            l = this._chunkSize;
        }
        if ((l = this._in.skip(l)) < 0L) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        this._chunkSize -= (int)l;
        return l;
    }

    public int available() throws IOException {
        int n = this._in.available();
        if (n <= this._chunkSize || this._chunkSize == 0) {
            return n;
        }
        return this._chunkSize;
    }

    public void close() throws IOException {
        this._chunkSize = -1;
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() {
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    public void mark(int n) {
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    private int getChunkSize() throws IOException {
        if (this._chunkSize < 0) {
            return -1;
        }
        this._trailer = null;
        this._chunkSize = -1;
        LineInput.LineBuffer lineBuffer = this._in.readLineBuffer();
        while (lineBuffer != null && lineBuffer.size == 0) {
            lineBuffer = this._in.readLineBuffer();
        }
        if (lineBuffer == null) {
            throw new IOException("Unexpected EOF");
        }
        String string = new String(lineBuffer.buffer, 0, lineBuffer.size);
        int n = string.indexOf(59);
        if (n > 0) {
            string = string.substring(0, n).trim();
        }
        try {
            this._chunkSize = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this._chunkSize = -1;
            log.warn((Object)("Bad Chunk:" + string));
            log.debug((Object)"EXCEPTION ", (Throwable)numberFormatException);
            throw new IOException("Bad chunk size");
        }
        if (this._chunkSize == 0) {
            this._chunkSize = -1;
            this._trailer = new HttpFields();
            this._trailer.read(this._in);
        }
        return this._chunkSize;
    }
}

