/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;

public class ContextLoader
extends URLClassLoader {
    private static Log log = LogFactory.getLog(ContextLoader.class);
    private boolean _java2compliant;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;
    private HttpContext _context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLoader(HttpContext httpContext, String string, ClassLoader classLoader, PermissionCollection permissionCollection) throws MalformedURLException, IOException {
        block13: {
            block12: {
                super(new URL[0], classLoader);
                this._java2compliant = false;
                this._context = httpContext;
                this._permissions = permissionCollection;
                this._parent = classLoader;
                if (this._parent == null) {
                    this._parent = ContextLoader.getSystemClassLoader();
                }
                if (string != null) break block12;
                this._urlClassPath = "";
                break block13;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                Resource resource;
                block14: {
                    File file;
                    resource = Resource.newResource(stringTokenizer.nextToken());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Path resource=" + resource));
                    }
                    if ((file = resource.getFile()) != null) {
                        object = resource.getURL();
                        this.addURL((URL)object);
                        this._urlClassPath = this._urlClassPath == null ? ((URL)object).toString() : this._urlClassPath + "," + ((URL)object).toString();
                        continue;
                    }
                    if (resource.isDirectory() || file != null) break block14;
                    object = resource.getInputStream();
                    File file2 = new File(httpContext.getTempDirectory(), "lib");
                    if (!file2.exists()) {
                        file2.mkdir();
                        file2.deleteOnExit();
                    }
                    File file3 = File.createTempFile("Jetty-", ".jar", file2);
                    file3.deleteOnExit();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extract " + resource + " to " + file3));
                    }
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file3);
                        IO.copy((InputStream)object, fileOutputStream);
                    }
                    catch (Throwable throwable) {
                        IO.close(fileOutputStream);
                        throw throwable;
                    }
                    IO.close(fileOutputStream);
                    URL uRL = file3.toURL();
                    this.addURL(uRL);
                    this._urlClassPath = this._urlClassPath == null ? uRL.toString() : this._urlClassPath + "," + uRL.toString();
                    continue;
                }
                object = resource.getURL();
                this.addURL((URL)object);
                this._urlClassPath = this._urlClassPath == null ? ((URL)object).toString() : this._urlClassPath + "," + ((URL)object).toString();
            }
        }
        if (log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ClassPath=" + this._urlClassPath));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Permissions=" + this._permissions));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL=" + Arrays.asList(this.getURLs())));
            }
        }
    }

    public void setJava2Compliant(boolean bl) {
        this._java2compliant = bl;
    }

    public boolean isJava2Compliant() {
        return this._java2compliant;
    }

    public String toString() {
        return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ")\n  --parent--> " + this._parent.toString();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection;
        PermissionCollection permissionCollection2 = permissionCollection = this._permissions == null ? super.getPermissions(codeSource) : this._permissions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loader.getPermissions(" + codeSource + ")=" + permissionCollection));
        }
        return permissionCollection;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        ClassNotFoundException classNotFoundException = null;
        boolean bl2 = false;
        if (clazz == null && (this._java2compliant || this.isSystemPath(string)) && !this.isServerPath(string) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try loadClass " + string + " from " + this._parent));
            }
            bl2 = true;
            try {
                clazz = this._parent.loadClass(string);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("p0 loaded " + clazz));
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try findClass " + string + " from " + this._urlClassPath));
            }
            try {
                clazz = this.findClass(string);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("cx loaded " + clazz));
                }
            }
            catch (ClassNotFoundException classNotFoundException3) {
                classNotFoundException = classNotFoundException3;
            }
        }
        if (clazz == null && !bl2 && !this.isServerPath(string) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try loadClass " + string + " from " + this._parent));
            }
            clazz = this._parent.loadClass(string);
            if (log.isTraceEnabled()) {
                log.trace((Object)("p1 loaded " + clazz));
            }
        }
        if (clazz == null) {
            throw classNotFoundException;
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public URL getResource(String string) {
        URL uRL = null;
        boolean bl = false;
        if (this._parent != null && (this._java2compliant || this.isSystemPath(string))) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try getResource " + string + " from " + this._parent));
            }
            bl = true;
            uRL = this._parent.getResource(string);
        }
        if (uRL == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try findResource " + string + " from " + this._urlClassPath));
            }
            if ((uRL = this.findResource(string)) == null && string.startsWith("/")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HACK leading / off " + string));
                }
                uRL = this.findResource(string.substring(1));
            }
        }
        if (this._parent != null && uRL == null && !bl) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try getResource " + string + " from " + this._parent));
            }
            uRL = this._parent.getResource(string);
        }
        if (uRL != null && log.isTraceEnabled()) {
            log.trace((Object)("found " + uRL));
        }
        return uRL;
    }

    public boolean isServerPath(String string) {
        string = string.replace('/', '.');
        while (string.startsWith(".")) {
            string = string.substring(1);
        }
        String[] stringArray = this._context.getServerClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = true;
                String string2 = stringArray[i];
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                    bl = false;
                }
                if (!(string2.endsWith(".") ? string.startsWith(string2) : string.equals(string2))) continue;
                return bl;
            }
        }
        return false;
    }

    public boolean isSystemPath(String string) {
        string = string.replace('/', '.');
        while (string.startsWith(".")) {
            string = string.substring(1);
        }
        String[] stringArray = this._context.getSystemClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = true;
                String string2 = stringArray[i];
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                    bl = false;
                }
                if (!(string2.endsWith(".") ? string.startsWith(string2) : string.equals(string2))) continue;
                return bl;
            }
        }
        return false;
    }

    public void destroy() {
        this._parent = null;
        this._permissions = null;
        this._urlClassPath = null;
    }

    String[] getServerClasses() {
        return this._context.getServerClasses();
    }

    void setServerClasses(String[] stringArray) {
        this._context.setServerClasses(stringArray);
    }

    String[] getSystemClasses() {
        return this._context.getSystemClasses();
    }

    void setSystemClasses(String[] stringArray) {
        this._context.setSystemClasses(stringArray);
    }
}

