/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.ChunkingOutputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayPool;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.OutputObserver;
import org.mortbay.util.StringUtil;

public class HttpOutputStream
extends OutputStream
implements OutputObserver,
HttpMessage.HeaderWriter {
    private static Log log = LogFactory.getLog(HttpOutputStream.class);
    static final int __BUFFER_SIZE = 4096;
    static final int __FIRST_RESERVE = 512;
    public static final Class[] __filterArg = new Class[]{OutputStream.class};
    private OutputStream _out;
    private OutputStream _realOut;
    private BufferedOutputStream _bufferedOut;
    private boolean _written = false;
    private ArrayList _observers;
    private int _bufferSize;
    private int _headerReserve;
    private HttpWriter _iso8859writer;
    private HttpWriter _utf8writer;
    private HttpWriter _asciiwriter;
    private boolean _nulled;
    private boolean _closing = false;
    private int _contentLength = -1;
    private int _bytes;
    private boolean _disableFlush;

    public HttpOutputStream(OutputStream outputStream) {
        this(outputStream, 4096, 512);
    }

    public HttpOutputStream(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    public HttpOutputStream(OutputStream outputStream, int n, int n2) {
        this._bufferSize = n;
        this._headerReserve = n2;
        this._out = this._realOut = outputStream;
    }

    public void setContentLength(int n) {
        if (n >= 0 && n < this._bytes) {
            throw new IllegalStateException();
        }
        this._contentLength = n;
    }

    public void setBufferedOutputStream(BufferedOutputStream bufferedOutputStream) {
        this._bufferedOut = bufferedOutputStream;
        this._bufferedOut.setCommitObserver(this);
        if (this._out != null && this._out != this._realOut) {
            this._out = this._bufferedOut;
        }
    }

    public OutputStream getOutputStream() {
        return this._realOut;
    }

    public OutputStream getBufferedOutputStream() {
        return this._out;
    }

    public boolean isWritten() {
        return this._written;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int n) throws IllegalStateException {
        if (n <= this._bufferSize) {
            return;
        }
        if (this._bufferedOut != null && this._bufferedOut.size() > 0) {
            throw new IllegalStateException("Not Reset");
        }
        try {
            this._bufferSize = n;
            if (this._bufferedOut != null) {
                boolean bl = this._bufferedOut.isFixed();
                this._bufferedOut.setFixed(false);
                this._bufferedOut.ensureSize(n);
                this._bufferedOut.setFixed(bl);
            }
        }
        catch (IOException iOException) {
            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
        }
    }

    public int getBytesWritten() {
        return this._bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer() throws IllegalStateException {
        if (this._out != null && this._out != this._realOut) {
            ArrayList arrayList = this._observers;
            this._observers = null;
            this._nulled = true;
            try {
                if (this._bufferedOut != null) {
                    this._bufferedOut.resetStream();
                    if (this._bufferedOut instanceof ChunkingOutputStream) {
                        ((ChunkingOutputStream)this._bufferedOut).setChunking(false);
                    }
                }
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
            }
            finally {
                this._observers = arrayList;
            }
        }
        this._contentLength = -1;
        this._nulled = false;
        this._bytes = 0;
        this._written = false;
        this._out = this._realOut;
        try {
            this.notify(1);
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
    }

    public void addObserver(OutputObserver outputObserver) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(outputObserver);
        this._observers.add(null);
    }

    public void addObserver(OutputObserver outputObserver, Object object) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(outputObserver);
        this._observers.add(object);
    }

    public void resetObservers() {
        this._observers = null;
    }

    public void nullOutput() throws IOException {
        this._nulled = true;
    }

    public boolean isNullOutput() throws IOException {
        return this._nulled;
    }

    public void setChunking() {
        this.checkOutput();
        if (!(this._bufferedOut instanceof ChunkingOutputStream)) {
            throw new IllegalStateException(this._bufferedOut.getClass().toString());
        }
        ((ChunkingOutputStream)this._bufferedOut).setChunking(true);
    }

    public boolean isChunking() {
        return this._bufferedOut instanceof ChunkingOutputStream && ((ChunkingOutputStream)this._bufferedOut).isChunking();
    }

    public void resetStream() throws IOException, IllegalStateException {
        if (this.isChunking()) {
            this.close();
        }
        this._out = null;
        this._nulled = true;
        if (this._bufferedOut != null) {
            this._bufferedOut.resetStream();
            if (this._bufferedOut instanceof ChunkingOutputStream) {
                ((ChunkingOutputStream)this._bufferedOut).setChunking(false);
            }
        }
        if (this._iso8859writer != null) {
            this._iso8859writer.flush();
        }
        if (this._utf8writer != null) {
            this._utf8writer.flush();
        }
        if (this._asciiwriter != null) {
            this._asciiwriter.flush();
        }
        this._bytes = 0;
        this._written = false;
        this._out = this._realOut;
        this._closing = false;
        this._contentLength = -1;
        this._nulled = false;
        if (this._observers != null) {
            this._observers.clear();
        }
    }

    public void destroy() {
        if (this._bufferedOut != null) {
            this._bufferedOut.destroy();
        }
        this._bufferedOut = null;
        if (this._iso8859writer != null) {
            this._iso8859writer.destroy();
        }
        this._iso8859writer = null;
        if (this._utf8writer != null) {
            this._utf8writer.destroy();
        }
        this._utf8writer = null;
        if (this._asciiwriter != null) {
            this._asciiwriter.destroy();
        }
        this._asciiwriter = null;
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        this.checkOutput();
        this._bufferedOut.writeHeader(httpMessage);
    }

    public void write(int n) throws IOException {
        this.prepareOutput(1);
        if (!this._nulled) {
            this._out.write(n);
        }
        if (this._bytes == this._contentLength) {
            this.flush();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        n2 = this.prepareOutput(n2);
        if (!this._nulled) {
            this._out.write(byArray, n, n2);
        }
        if (this._bytes == this._contentLength) {
            this.flush();
        }
    }

    protected void checkOutput() {
        if (this._out == this._realOut) {
            if (this._bufferedOut == null) {
                this._bufferedOut = new ChunkingOutputStream(this._realOut, this._bufferSize, this._headerReserve, false);
                this._bufferedOut.setCommitObserver(this);
                this._bufferedOut.setBypassBuffer(true);
                this._bufferedOut.setFixed(true);
            }
            this._out = this._bufferedOut;
        }
    }

    protected int prepareOutput(int n) throws IOException {
        if (this._out == null) {
            throw new IOException("closed");
        }
        this.checkOutput();
        if (!this._written) {
            this._written = true;
            this.notify(0);
        }
        if (this._contentLength >= 0 && this._bytes + n >= this._contentLength && (n = this._contentLength - this._bytes) == 0) {
            this._nulled = true;
        }
        this._bytes += n;
        return n;
    }

    public void flush() throws IOException {
        if (!this._disableFlush && this._out != null && !this._closing) {
            this._out.flush();
        }
    }

    public boolean isClosed() throws IOException {
        return this._out == null;
    }

    public void close() throws IOException {
        if (this._out == null) {
            return;
        }
        this._closing = true;
        try {
            this.notify(4);
            OutputStream outputStream = this._out;
            this._out = null;
            if (outputStream != this._bufferedOut) {
                outputStream.close();
            } else {
                this._bufferedOut.close();
            }
            this.notify(5);
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
    }

    public void outputNotify(OutputStream outputStream, int n, Object object) throws IOException {
        this.notify(n);
    }

    private void notify(int n) throws IOException {
        if (this._observers != null) {
            int n2 = this._observers.size();
            while (n2-- > 0) {
                Object e = this._observers.get(n2--);
                ((OutputObserver)this._observers.get(n2)).outputNotify(this, n, e);
            }
        }
    }

    public void write(InputStream inputStream, int n) throws IOException {
        IO.copy(inputStream, this, (long)n);
    }

    private Writer getISO8859Writer() throws IOException {
        if (this._iso8859writer == null) {
            this._iso8859writer = new HttpWriter(StringUtil.__ISO_8859_1, this.getBufferSize());
        }
        return this._iso8859writer;
    }

    private Writer getUTF8Writer() throws IOException {
        if (this._utf8writer == null) {
            this._utf8writer = new HttpWriter("UTF-8", this.getBufferSize());
        }
        return this._utf8writer;
    }

    private Writer getASCIIWriter() throws IOException {
        if (this._asciiwriter == null) {
            this._asciiwriter = new HttpWriter("US-ASCII", this.getBufferSize());
        }
        return this._asciiwriter;
    }

    public Writer getWriter(String string) throws IOException {
        if (string == null || StringUtil.__ISO_8859_1.equalsIgnoreCase(string) || "ISO8859_1".equalsIgnoreCase(string)) {
            return this.getISO8859Writer();
        }
        if ("UTF-8".equalsIgnoreCase(string) || "UTF8".equalsIgnoreCase(string)) {
            return this.getUTF8Writer();
        }
        if ("US-ASCII".equalsIgnoreCase(string)) {
            return this.getASCIIWriter();
        }
        return new OutputStreamWriter((OutputStream)this, string);
    }

    public String toString() {
        return super.toString() + "\nout=" + this._out + "\nrealOut=" + this._realOut + "\nbufferedOut=" + this._bufferedOut;
    }

    private class HttpWriter
    extends Writer {
        private OutputStreamWriter _writer = null;
        private boolean _writting = false;
        private byte[] _buf;
        private String _encoding;

        HttpWriter(String string, int n) {
            this._buf = ByteArrayPool.getByteArray(n);
            this._encoding = string;
        }

        public Object getLock() {
            return this.lock;
        }

        public void write(char c) throws IOException {
            HttpOutputStream.this.prepareOutput(1);
            if (!HttpOutputStream.this._nulled) {
                if (this._writting) {
                    this._writer.write(c);
                } else if (c >= '\u0000' && c <= '\u007f') {
                    HttpOutputStream.this.write(c);
                } else {
                    char[] cArray = new char[]{c};
                    this.writeEncoded(cArray, 0, 1);
                }
                if (HttpOutputStream.this._bytes == HttpOutputStream.this._contentLength) {
                    this.flush();
                }
            }
        }

        public void write(char[] cArray) throws IOException {
            this.write(cArray, 0, cArray.length);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (this._writting) {
                this._writer.write(cArray, n, n2);
            } else {
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    char c = cArray[n + i];
                    if (c >= '\u0000' && c <= '\u007f') {
                        this._buf[n3++] = (byte)c;
                        if (n3 != this._buf.length) continue;
                        n3 = HttpOutputStream.this.prepareOutput(n3);
                        if (!HttpOutputStream.this._nulled) {
                            HttpOutputStream.this._out.write(this._buf, 0, n3);
                        }
                        n3 = 0;
                        continue;
                    }
                    if (n3 > 0) {
                        n3 = HttpOutputStream.this.prepareOutput(n3);
                        if (!HttpOutputStream.this._nulled) {
                            HttpOutputStream.this._out.write(this._buf, 0, n3);
                        }
                        n3 = 0;
                    }
                    this.writeEncoded(cArray, n + i, n2 - i);
                    break;
                }
                if (n3 > 0) {
                    n3 = HttpOutputStream.this.prepareOutput(n3);
                    if (!HttpOutputStream.this._nulled) {
                        HttpOutputStream.this._out.write(this._buf, 0, n3);
                    }
                    n3 = 0;
                }
            }
            if (!HttpOutputStream.this._nulled && HttpOutputStream.this._bytes == HttpOutputStream.this._contentLength) {
                this.flush();
            }
        }

        public void write(String string) throws IOException {
            this.write(string, 0, string.length());
        }

        public void write(String string, int n, int n2) throws IOException {
            if (this._writting) {
                this._writer.write(string, n, n2);
            } else {
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(n + i);
                    if (c >= '\u0000' && c <= '\u007f') {
                        this._buf[n3++] = (byte)c;
                        if (n3 != this._buf.length) continue;
                        n3 = HttpOutputStream.this.prepareOutput(n3);
                        if (!HttpOutputStream.this._nulled) {
                            HttpOutputStream.this._out.write(this._buf, 0, n3);
                        }
                        n3 = 0;
                        continue;
                    }
                    if (n3 > 0) {
                        n3 = HttpOutputStream.this.prepareOutput(n3);
                        if (!HttpOutputStream.this._nulled) {
                            HttpOutputStream.this._out.write(this._buf, 0, n3);
                        }
                        n3 = 0;
                    }
                    char[] cArray = string.toCharArray();
                    this.writeEncoded(cArray, n + i, cArray.length - (n + i));
                    break;
                }
                if (n3 > 0) {
                    n3 = HttpOutputStream.this.prepareOutput(n3);
                    if (!HttpOutputStream.this._nulled) {
                        HttpOutputStream.this._out.write(this._buf, 0, n3);
                    }
                    n3 = 0;
                }
            }
            if (HttpOutputStream.this._bytes == HttpOutputStream.this._contentLength) {
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeEncoded(char[] cArray, int n, int n2) throws IOException {
            this._writting = true;
            if (this._writer == null) {
                this._writer = new OutputStreamWriter((OutputStream)HttpOutputStream.this, this._encoding);
            }
            try {
                HttpOutputStream.this._disableFlush = true;
                this._writer.write(cArray, n, n2);
                if (HttpOutputStream.this._contentLength >= 0) {
                    this._writer.flush();
                }
            }
            finally {
                HttpOutputStream.this._disableFlush = false;
            }
        }

        public void flush() throws IOException {
            if (this._writting) {
                this._writer.flush();
            } else {
                HttpOutputStream.this.flush();
            }
            this._writting = false;
        }

        public void close() throws IOException {
            HttpOutputStream.this._closing = true;
            if (this._writting) {
                this._writer.flush();
            }
            HttpOutputStream.this.close();
            this._writting = false;
        }

        public void destroy() {
            ByteArrayPool.returnByteArray(this._buf);
            this._buf = null;
            this._writer = null;
            this._encoding = null;
        }
    }
}

