/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiMap;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class HttpRequest
extends HttpMessage {
    private static Log log = LogFactory.getLog(HttpRequest.class);
    public static final String __GET = "GET";
    public static final String __POST = "POST";
    public static final String __HEAD = "HEAD";
    public static final String __PUT = "PUT";
    public static final String __OPTIONS = "OPTIONS";
    public static final String __DELETE = "DELETE";
    public static final String __TRACE = "TRACE";
    public static final String __CONNECT = "CONNECT";
    public static final String __MOVE = "MOVE";
    public static int __maxFormContentSize = Integer.getInteger("org.mortbay.http.HttpRequest.maxFormContentSize", 200000);
    public static int __maxLineLength = 4096;
    public static final StringMap __methodCache = new StringMap(true);
    public static final StringMap __versionCache = new StringMap(true);
    private static Cookie[] __noCookies;
    private String _method = null;
    private URI _uri = null;
    private String _host;
    private String _hostPort;
    private int _port;
    private List _te;
    private MultiMap _parameters;
    private boolean _paramsExtracted;
    private boolean _handled;
    private Cookie[] _cookies;
    private String[] _lastCookies;
    private boolean _cookiesExtracted;
    private long _timeStamp;
    private String _timeStampStr;
    private Principal _userPrincipal;
    private String _authUser;
    private String _authType;
    private char[] _uriExpanded;
    static Principal __NO_USER;
    static Principal __NOT_CHECKED;

    public HttpRequest() {
    }

    public HttpRequest(HttpConnection httpConnection) {
        super(httpConnection);
    }

    public String getTimeStampStr() {
        if (this._timeStampStr == null && this._timeStamp > 0L) {
            this._timeStampStr = HttpFields.__dateCache.format(this._timeStamp);
        }
        return this._timeStampStr;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public void setTimeStamp(long l) {
        this._timeStamp = l;
    }

    public HttpResponse getResponse() {
        return this.getHttpResponse();
    }

    public HttpResponse getHttpResponse() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getResponse();
    }

    public boolean isHandled() {
        if (this._handled) {
            return true;
        }
        HttpResponse httpResponse = this.getHttpResponse();
        return httpResponse != null && httpResponse.getState() != 0;
    }

    public void setHandled(boolean bl) {
        this._handled = bl;
    }

    public void readHeader(LineInput lineInput) throws IOException {
        LineInput.LineBuffer lineBuffer;
        this._state = 1;
        do {
            if ((lineBuffer = lineInput.readLineBuffer()) != null) continue;
            throw new EOFException();
        } while (lineBuffer.size == 0);
        if (lineBuffer.size >= __maxLineLength) {
            throw new HttpException(414);
        }
        this.decodeRequestLine(lineBuffer.buffer, lineBuffer.size);
        this._timeStamp = System.currentTimeMillis();
        if ("HTTP/1.1".equals(this._version)) {
            this._dotVersion = 1;
            this._version = "HTTP/1.1";
            this._header.read(lineInput);
            this.updateMimeType();
        } else if ("HTTP/0.9".equals(this._version)) {
            this._dotVersion = -1;
            this._version = "HTTP/0.9";
        } else {
            this._dotVersion = 0;
            this._version = "HTTP/1.0";
            this._header.read(lineInput);
            this.updateMimeType();
        }
        this._handled = false;
        this._state = 2;
    }

    public void writeRequestLine(Writer writer) throws IOException {
        writer.write(this._method);
        writer.write(32);
        writer.write(this._uri != null ? this._uri.toString() : "null");
        writer.write(32);
        writer.write(this._version);
    }

    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException("Not MSG_EDITABLE");
        }
        this._state = 1;
        this.writeRequestLine(writer);
        writer.write(HttpFields.__CRLF);
        this._header.write(writer);
        this._state = 3;
    }

    public String getRequestLine() {
        return this._method + " " + this._uri + " " + this._version;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String string) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._method = string;
    }

    public String getVersion() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRootURL() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(48);
        synchronized (stringBuffer2) {
            String string = this.getScheme();
            int n = this.getPort();
            stringBuffer.append(string);
            stringBuffer.append("://");
            if (this._hostPort != null) {
                stringBuffer.append(this._hostPort);
            } else {
                stringBuffer.append(this.getHost());
                if (n > 0 && (string.equalsIgnoreCase("http") && n != 80 || string.equalsIgnoreCase("https") && n != 443)) {
                    stringBuffer.append(':');
                    stringBuffer.append(n);
                }
            }
            return stringBuffer;
        }
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = this.getRootURL();
        stringBuffer.append(this.getPath());
        return stringBuffer;
    }

    public URI getURI() {
        return this._uri;
    }

    public String getScheme() {
        String string = this._uri.getScheme();
        if (string == null && this._connection != null) {
            string = this._connection.getDefaultScheme();
        }
        return string == null ? "http" : string;
    }

    public boolean isIntegral() {
        return this._connection.getListener().isIntegral(this._connection);
    }

    public boolean isConfidential() {
        return this._connection.getListener().isConfidential(this._connection);
    }

    public String getHost() {
        if (this._host != null) {
            return this._host;
        }
        this._host = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._host != null) {
            return this._host;
        }
        this._host = this._hostPort = this._header.get("Host");
        this._port = 0;
        if (this._host != null && this._host.length() > 0) {
            int n = this._host.lastIndexOf(58);
            if (n >= 0) {
                if (n < this._host.length()) {
                    try {
                        this._port = TypeUtil.parseInt(this._host, n + 1, -1, 10);
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                    }
                }
                this._host = this._host.substring(0, n);
            }
            return this._host;
        }
        if (this._connection != null) {
            this._host = this._connection.getServerName();
            this._port = this._connection.getServerPort();
            if (this._host != null && !"0.0.0.0".equals(this._host)) {
                return this._host;
            }
        }
        try {
            this._host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            LogSupport.ignore(log, unknownHostException);
        }
        return this._host;
    }

    public int getPort() {
        if (this._port > 0) {
            return this._port;
        }
        if (this._host != null) {
            return 0;
        }
        if (this._uri.isAbsolute()) {
            this._port = this._uri.getPort();
        } else if (this._connection != null) {
            this._port = this._connection.getServerPort();
        }
        return this._port;
    }

    public String getPath() {
        return this._uri.getPath();
    }

    public void setPath(String string) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        if (this._uri == null) {
            this._uri = new URI(string);
        } else {
            this._uri.setURI(string);
        }
    }

    public String getEncodedPath() {
        return this._uri.getEncodedPath();
    }

    public String getQuery() {
        return this._uri.getQuery();
    }

    public void setQuery(String string) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._uri.setQuery(string);
    }

    public String getRemoteAddr() {
        String string = "127.0.0.1";
        HttpConnection httpConnection = this.getHttpConnection();
        if (httpConnection != null && (string = httpConnection.getRemoteAddr()) == null) {
            string = httpConnection.getRemoteHost();
        }
        return string;
    }

    public String getRemoteHost() {
        String string = "127.0.0.1";
        HttpConnection httpConnection = this.getHttpConnection();
        if (httpConnection != null && (string = httpConnection.getRemoteHost()) == null) {
            string = httpConnection.getRemoteAddr();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    void decodeRequestLine(char[] var1_1, int var2_2) throws IOException {
        var3_3 = -1;
        var4_4 = -1;
        var5_5 = -1;
        var6_6 = 0;
        block12: for (var7_7 = 0; var7_7 < var2_2; ++var7_7) {
            var8_8 = var1_1[var7_7];
            switch (var6_6) {
                case 0: {
                    if (var8_8 == 32) ** GOTO lbl24
                    var6_6 = 1;
                    var3_3 = var7_7;
                }
                case 1: {
                    if (var8_8 == 32) {
                        var6_6 = 2;
                    } else {
                        var4_4 = var7_7;
                        if (var8_8 >= 97 && var8_8 <= 122) {
                            var1_1[var7_7] = (char)(var8_8 - 97 + 65);
                        } else {
                            ** GOTO lbl20
                        }
                    }
                }
                {
lbl20:
                    // 3 sources

                    ** GOTO lbl24
                }
                case 2: {
                    var5_5 = var7_7;
                    if (var8_8 != 32) break block12;
                }
lbl24:
                // 5 sources

                default: {
                    continue block12;
                }
            }
        }
        var7_7 = -1;
        var8_8 = -1;
        var9_9 = -1;
        var6_6 = 0;
        var10_10 = var2_2;
        block13: while (var10_10-- > 0) {
            var11_12 = var1_1[var10_10];
            switch (var6_6) {
                case 0: {
                    if (var11_12 == ' ') continue block13;
                    var6_6 = 1;
                    var7_7 = var10_10;
                }
                case 1: {
                    if (var11_12 == ' ') {
                        var6_6 = 2;
                        continue block13;
                    }
                    var8_8 = var10_10;
                    continue block13;
                }
                case 2: {
                    var9_9 = var10_10;
                    if (var11_12 != ' ') break block13;
                }
                default: {
                    continue block13;
                }
            }
        }
        if (var5_5 < 0 || var7_7 < 0 || var9_9 < var4_4) {
            throw new IOException("Bad Request: " + new String(var1_1, 0, var2_2));
        }
        var10_11 = HttpRequest.__methodCache.getEntry(var1_1, var3_3, var4_4 - var3_3 + 1);
        this._method = var10_11 != null ? (String)var10_11.getKey() : new String(var1_1, var3_3, var4_4 - var3_3 + 1).toUpperCase();
        if (var4_4 != var9_9 || var5_5 != var8_8) {
            var11_13 = HttpRequest.__versionCache.getEntry(var1_1, var8_8, var7_7 - var8_8 + 1);
            if (var11_13 != null) {
                this._version = (String)var11_13.getKey();
            } else {
                for (var12_16 = var8_8; var12_16 <= var7_7; ++var12_16) {
                    if (var1_1[var12_16] < 'a' || var1_1[var12_16] > 'z') continue;
                    var1_1[var12_16] = (char)(var1_1[var12_16] - 97 + 65);
                }
                this._version = new String(var1_1, var8_8, var7_7 - var8_8 + 1);
            }
        } else {
            this._version = "HTTP/0.9";
            var9_9 = var7_7;
        }
        try {
            var11_14 = null;
            if (URI.__CHARSET_IS_DEFAULT) {
                var11_14 = new String(var1_1, var5_5, var9_9 - var5_5 + 1);
            } else {
                var12_16 = var9_9 - var5_5 + 1;
                for (var13_17 = 0; var13_17 < var12_16; ++var13_17) {
                    var14_18 = var1_1[var5_5 + var13_17];
                    if (var14_18 >= '\u0000' && var14_18 < '\u0080') continue;
                    if (this._uriExpanded == null || this._uriExpanded.length < 3 * var12_16) {
                        this._uriExpanded = new char[3 * var12_16];
                    }
                    if (var13_17 > 0) {
                        System.arraycopy(var1_1, var5_5, this._uriExpanded, 0, var13_17);
                    }
                    var15_19 = var13_17;
                    while (var13_17 < var12_16) {
                        var14_18 = var1_1[var5_5 + var13_17];
                        if (var14_18 >= '\u0000' && var14_18 < '\u0080') {
                            this._uriExpanded[var15_19++] = var14_18;
                        } else {
                            this._uriExpanded[var15_19++] = 37;
                            this._uriExpanded[var15_19++] = TypeUtil.toHexChar(15 & var14_18 >> 4);
                            this._uriExpanded[var15_19++] = TypeUtil.toHexChar(15 & var14_18);
                        }
                        ++var13_17;
                    }
                    var11_14 = new String(this._uriExpanded, 0, var15_19);
                }
                if (var11_14 == null) {
                    var11_14 = new String(var1_1, var5_5, var9_9 - var5_5 + 1);
                }
            }
            if (this._uri == null) {
                this._uri = new URI(var11_14);
            } else {
                this._uri.setURI(var11_14);
            }
        }
        catch (IllegalArgumentException var11_15) {
            LogSupport.ignore(HttpRequest.log, var11_15);
            throw new HttpException(400, new String(var1_1, var5_5, var9_9 - var5_5 + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object forceRemoveField(String string) {
        int n = this._state;
        try {
            this._state = 0;
            String string2 = this.removeField(string);
            return string2;
        }
        finally {
            this._state = n;
        }
    }

    public List getAcceptableTransferCodings() {
        if (this._dotVersion < 1) {
            return null;
        }
        if (this._te != null) {
            return this._te;
        }
        Enumeration enumeration = this.getFieldValues("TE", ", \t");
        if (enumeration != null) {
            List list = HttpFields.qualityList(enumeration);
            int n = list.size();
            if (n > 0) {
                Object object = null;
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    String string = StringUtil.asciiToLowerCase(HttpFields.valueParameters(listIterator.next().toString(), null));
                    if ("chunked".equalsIgnoreCase(string)) continue;
                    object = LazyList.ensureSize(object, n);
                    object = LazyList.add(object, string);
                }
                this._te = LazyList.getList(object);
            } else {
                this._te = Collections.EMPTY_LIST;
            }
        } else {
            this._te = Collections.EMPTY_LIST;
        }
        return this._te;
    }

    private void extractParameters() {
        String string;
        String string2;
        if (this._paramsExtracted) {
            return;
        }
        this._paramsExtracted = true;
        if (this._parameters == null) {
            this._parameters = new MultiMap(16);
        }
        if ((string2 = this.getCharacterEncoding()) == null) {
            this._uri.putParametersTo(this._parameters);
        } else {
            string = this._uri.getQuery();
            if (string != null) {
                UrlEncoded.decodeTo(string, this._parameters, string2);
            }
        }
        if (this._state == 2 && (string = this.getField("Content-Type")) != null && string.length() > 0) {
            string = StringUtil.asciiToLowerCase(string);
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(string = HttpFields.valueParameters(string, null)) && __POST.equals(this.getMethod())) {
                int n = this.getIntField("Content-Length");
                if (n == 0) {
                    log.debug((Object)"No form content");
                } else {
                    try {
                        int n2 = n;
                        if (__maxFormContentSize > 0) {
                            if (n2 < 0) {
                                n2 = __maxFormContentSize;
                            } else if (n2 > __maxFormContentSize) {
                                throw new IllegalStateException("Form too large");
                            }
                        }
                        ByteArrayOutputStream2 byteArrayOutputStream2 = new ByteArrayOutputStream2(n2 > 0 ? n2 : 4096);
                        InputStream inputStream = this.getInputStream();
                        IO.copy(inputStream, byteArrayOutputStream2, (long)n2);
                        if (byteArrayOutputStream2.size() == __maxFormContentSize && inputStream.available() > 0) {
                            throw new IllegalStateException("Form too large");
                        }
                        UrlEncoded.decodeTo(byteArrayOutputStream2.getBuf(), 0, byteArrayOutputStream2.getCount(), this._parameters, string2);
                    }
                    catch (EOFException eOFException) {
                        LogSupport.ignore(log, eOFException);
                    }
                    catch (IOException iOException) {
                        if (log.isDebugEnabled()) {
                            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                        }
                        log.warn((Object)iOException.toString());
                    }
                }
            }
        }
    }

    public MultiMap getParameters() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters;
    }

    public Set getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.keySet();
    }

    public String getParameter(String string) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(string, 0);
    }

    public List getParameterValues(String string) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.getValues(string);
    }

    public Map getParameterStringArrayMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.toStringArrayMap();
    }

    public Cookie[] getCookies() {
        if (this._cookies != null && this._cookiesExtracted) {
            return this._cookies;
        }
        try {
            int n;
            Object object;
            if (!this._header.containsKey("Cookie")) {
                this._cookies = __noCookies;
                this._cookiesExtracted = true;
                this._lastCookies = null;
                return this._cookies;
            }
            if (this._lastCookies != null) {
                int n2 = 0;
                object = this._header.getValues("Cookie");
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    if (n2 >= this._lastCookies.length || !string.equals(this._lastCookies[n2])) {
                        this._lastCookies = null;
                        break;
                    }
                    ++n2;
                }
                if (this._lastCookies != null) {
                    this._cookiesExtracted = true;
                    return this._cookies;
                }
            }
            Object object2 = null;
            object = null;
            int n3 = 0;
            Cookie cookie = null;
            Enumeration enumeration = this._header.getValues("Cookie");
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                object = LazyList.add(object, string);
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string, ",;", false, false);
                while (quotedStringTokenizer.hasMoreElements()) {
                    String string2 = (String)quotedStringTokenizer.nextElement();
                    if (string2 == null) continue;
                    string2 = string2.trim();
                    try {
                        String string3;
                        String string4;
                        int n4 = string2.indexOf(61);
                        if (n4 > 0) {
                            string4 = string2.substring(0, n4);
                            string3 = string2.substring(n4 + 1);
                        } else {
                            string4 = string2;
                            string3 = "";
                        }
                        if (n3 > 0) {
                            string3 = StringUtil.unquote(string3);
                        }
                        if (string4.startsWith("$")) {
                            if ("$version".equalsIgnoreCase(string4)) {
                                n3 = Integer.parseInt(StringUtil.unquote(string3));
                                continue;
                            }
                            if ("$path".equalsIgnoreCase(string4) && cookie != null) {
                                cookie.setPath(string3);
                                continue;
                            }
                            if (!"$domain".equalsIgnoreCase(string4) || cookie == null) continue;
                            cookie.setDomain(string3);
                            continue;
                        }
                        string3 = URI.decodePath(string3);
                        cookie = new Cookie(string4, string3);
                        if (n3 > 0) {
                            cookie.setVersion(n3);
                        }
                        object2 = LazyList.add(object2, cookie);
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                    }
                }
            }
            int n5 = LazyList.size(object2);
            if (this._cookies == null || this._cookies.length != n5) {
                this._cookies = new Cookie[n5];
            }
            for (n = 0; n < n5; ++n) {
                this._cookies[n] = (Cookie)LazyList.get(object2, n);
            }
            this._cookiesExtracted = true;
            n5 = LazyList.size(object);
            this._lastCookies = new String[n5];
            for (n = 0; n < n5; ++n) {
                this._lastCookies[n] = (String)LazyList.get(object, n);
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        return this._cookies;
    }

    public boolean isUserInRole(String string) {
        UserRealm userRealm;
        Principal principal = this.getUserPrincipal();
        if (principal != null && (userRealm = this.getHttpResponse().getHttpContext().getRealm()) != null) {
            return userRealm.isUserInRole(principal, string);
        }
        return false;
    }

    public String getAuthType() {
        if (this._authType == null) {
            this.getUserPrincipal();
        }
        return this._authType;
    }

    public void setAuthType(String string) {
        this._authType = string;
    }

    public String getAuthUser() {
        if (this._authUser == null) {
            this.getUserPrincipal();
        }
        return this._authUser;
    }

    public void setAuthUser(String string) {
        this._authUser = string;
    }

    public boolean hasUserPrincipal() {
        if (this._userPrincipal == __NOT_CHECKED) {
            this.getUserPrincipal();
        }
        return this._userPrincipal != null && this._userPrincipal != __NO_USER;
    }

    public Principal getUserPrincipal() {
        if (this._userPrincipal == __NO_USER) {
            return null;
        }
        if (this._userPrincipal == __NOT_CHECKED) {
            this._userPrincipal = __NO_USER;
            HttpContext httpContext = this.getHttpResponse().getHttpContext();
            if (httpContext != null) {
                Authenticator authenticator = httpContext.getAuthenticator();
                UserRealm userRealm = httpContext.getRealm();
                if (userRealm != null && authenticator != null) {
                    try {
                        String string = this.getPath().substring(httpContext.getContextPath().length());
                        authenticator.authenticate(userRealm, string, this, null);
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                    }
                }
            }
            if (this._userPrincipal == __NO_USER) {
                return null;
            }
        }
        return this._userPrincipal;
    }

    public void setUserPrincipal(Principal principal) {
        this._userPrincipal = principal;
    }

    void recycle(HttpConnection httpConnection) {
        this._method = null;
        this._host = null;
        this._hostPort = null;
        this._port = 0;
        this._te = null;
        if (this._parameters != null) {
            this._parameters.clear();
        }
        this._paramsExtracted = false;
        this._handled = false;
        this._cookiesExtracted = false;
        this._timeStamp = 0L;
        this._timeStampStr = null;
        this._authUser = null;
        this._authType = null;
        this._userPrincipal = null;
        super.recycle(httpConnection);
    }

    public void destroy() {
        this._parameters = null;
        this._method = null;
        this._uri = null;
        this._host = null;
        this._hostPort = null;
        this._te = null;
        this._cookies = null;
        this._lastCookies = null;
        this._timeStampStr = null;
        this._userPrincipal = null;
        this._authUser = null;
        this._authUser = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        super.destroy();
    }

    static {
        __methodCache.put(__GET, (Object)null);
        __methodCache.put(__POST, (Object)null);
        __methodCache.put(__HEAD, (Object)null);
        __methodCache.put(__PUT, (Object)null);
        __methodCache.put(__OPTIONS, (Object)null);
        __methodCache.put(__DELETE, (Object)null);
        __methodCache.put(__TRACE, (Object)null);
        __methodCache.put(__CONNECT, (Object)null);
        __methodCache.put(__MOVE, (Object)null);
        __versionCache.put("HTTP/1.1", (Object)null);
        __versionCache.put("HTTP/1.0", (Object)null);
        __versionCache.put("HTTP/0.9", (Object)null);
        __noCookies = new Cookie[0];
        __NO_USER = new Principal(){

            public String getName() {
                return null;
            }
        };
        __NOT_CHECKED = new Principal(){

            public String getName() {
                return null;
            }
        };
    }
}

