/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpResponse;
import org.mortbay.log.LogFactory;
import org.mortbay.util.StringUtil;

public class MultiPartResponse {
    private static Log log = LogFactory.getLog(MultiPartResponse.class);
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private String boundary;
    private byte[] boundaryBytes;
    private OutputStream out = null;
    private boolean inPart = false;

    private MultiPartResponse() {
        try {
            this.boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
            this.boundaryBytes = this.boundary.getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception exception) {
            log.fatal((Object)exception);
            System.exit(1);
        }
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public MultiPartResponse(OutputStream outputStream) throws IOException {
        this();
        this.out = outputStream;
        this.inPart = false;
    }

    public MultiPartResponse(HttpResponse httpResponse) throws IOException {
        this();
        httpResponse.setField("Content-Type", "multipart/mixed;boundary=" + this.boundary);
        this.out = httpResponse.getOutputStream();
        this.inPart = false;
    }

    public void startPart(String string) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + string).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String string, String[] stringArray) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + string).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.out.write(stringArray[i].getBytes(StringUtil.__ISO_8859_1));
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
    }

    static {
        try {
            __CRLF = "\r\n".getBytes(StringUtil.__ISO_8859_1);
            __DASHDASH = "--".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception exception) {
            log.fatal((Object)exception);
            System.exit(1);
        }
    }
}

