/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.logging.Log;
import org.mortbay.http.JsseListener;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Password;

public class SunJsseListener
extends JsseListener {
    private static Log log = LogFactory.getLog(SunJsseListener.class);
    private String _keystore = DEFAULT_KEYSTORE;
    private transient Password _password;
    private transient Password _keypassword;
    private String _keystore_type = DEFAULT_KEYSTORE_TYPE;
    private String _keystore_provider_name = DEFAULT_KEYSTORE_PROVIDER_NAME;
    private String _keystore_provider_class = DEFAULT_KEYSTORE_PROVIDER_CLASS;
    private boolean _useDefaultTrustStore = false;

    public void setKeystore(String string) {
        this._keystore = string;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public void setPassword(String string) {
        this._password = Password.getPassword("jetty.ssl.password", string, null);
    }

    public void setKeyPassword(String string) {
        this._keypassword = Password.getPassword("jetty.ssl.keypassword", string, null);
    }

    public void setKeystoreType(String string) {
        this._keystore_type = string;
    }

    public String getKeystoreType() {
        return this._keystore_type;
    }

    public void setKeystoreProviderName(String string) {
        this._keystore_provider_name = string;
    }

    public String getKeystoreProviderName() {
        return this._keystore_provider_name;
    }

    public String getKeystoreProviderClass() {
        return this._keystore_provider_class;
    }

    public void setKeystoreProviderClass(String string) {
        this._keystore_provider_class = string;
    }

    public boolean getUseDefaultTrustStore() {
        return this._useDefaultTrustStore;
    }

    public void setUseDefaultTrustStore(boolean bl) {
        this._useDefaultTrustStore = bl;
    }

    public SunJsseListener() {
    }

    public SunJsseListener(InetAddrPort inetAddrPort) {
        super(inetAddrPort);
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        KeyManager[] keyManagerArray;
        KeyManagerFactory keyManagerFactory;
        this._keystore = System.getProperty("jetty.ssl.keystore", this._keystore);
        log.info((Object)("jetty.ssl.keystore=" + this._keystore));
        if (this._password == null) {
            this._password = Password.getPassword("jetty.ssl.password", null, null);
        }
        log.info((Object)("jetty.ssl.password=" + this._password.toStarString()));
        if (this._keypassword == null) {
            this._keypassword = Password.getPassword("jetty.ssl.keypassword", null, this._password.toString());
        }
        log.info((Object)("jetty.ssl.keypassword=" + this._keypassword.toStarString()));
        KeyStore keyStore = null;
        log.info((Object)("jetty.ssl.keystore.type=" + this._keystore_type));
        if (this._keystore_provider_class != null) {
            keyManagerFactory = Security.getProviders();
            keyManagerArray = null;
            for (int i = 0; i < ((java.security.Provider[])keyManagerFactory).length; ++i) {
                if (!keyManagerFactory[i].getClass().getName().equals(this._keystore_provider_class)) continue;
                keyManagerArray = keyManagerFactory[i];
                break;
            }
            if (keyManagerArray == null) {
                keyManagerArray = (KeyManager[])Class.forName(this._keystore_provider_class).newInstance();
                Security.addProvider((java.security.Provider)keyManagerArray);
            }
            log.info((Object)("jetty.ssl.keystore.provider.class=" + this._keystore_provider_class));
            keyStore = KeyStore.getInstance(this._keystore_type, keyManagerArray.getName());
        } else if (this._keystore_provider_name != null) {
            log.info((Object)("jetty.ssl.keystore.provider.name=" + this._keystore_provider_name));
            keyStore = KeyStore.getInstance(this._keystore_type, this._keystore_provider_name);
        } else {
            keyStore = KeyStore.getInstance(this._keystore_type);
            log.info((Object)"jetty.ssl.keystore.provider.name=[DEFAULT]");
        }
        keyStore.load(new FileInputStream(new File(this._keystore)), this._password.toString().toCharArray());
        keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509", (String)"SunJSSE");
        keyManagerFactory.init(keyStore, this._keypassword.toString().toCharArray());
        keyManagerArray = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509", (String)"SunJSSE");
        if (this._useDefaultTrustStore) {
            trustManagerFactory.init((KeyStore)null);
        } else {
            trustManagerFactory.init(keyStore);
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
        sSLContext.init(keyManagerArray, trustManagerArray, SecureRandom.getInstance("SHA1PRNG"));
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        log.info((Object)("SSLServerSocketFactory=" + sSLServerSocketFactory));
        return sSLServerSocketFactory;
    }

    static {
        Security.addProvider((java.security.Provider)new Provider());
    }
}

