/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.ByteArrayPool;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public abstract class AJP13Packet {
    private static Log log = LogFactory.getLog(AJP13Packet.class);
    public static final int __MAX_BUF = 8192;
    public static final int __HDR_SIZE = 4;
    public static final int __DATA_HDR = 7;
    public static final int __MAX_DATA = 8185;
    public static final byte __FORWARD_REQUEST = 2;
    public static final byte __SHUTDOWN = 7;
    public static final byte __SEND_BODY_CHUNK = 3;
    public static final byte __SEND_HEADERS = 4;
    public static final byte __END_RESPONSE = 5;
    public static final byte __GET_BODY_CHUNK = 6;
    public static final String[] __method = new String[]{"ERROR", "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH"};
    public String[] __header;
    protected HashMap __headerMap = new HashMap();
    private byte[] _buf;
    private int _bytes;
    private int _pos;
    private ByteArrayISO8859Writer _byteWriter;
    private boolean _ownBuffer;

    public abstract void populateHeaders();

    public AJP13Packet(byte[] byArray, int n) {
        this.populateHeaders();
        this._buf = byArray;
        this._ownBuffer = false;
        this._bytes = n;
    }

    public AJP13Packet(byte[] byArray) {
        this.populateHeaders();
        this._buf = byArray;
        this._ownBuffer = false;
    }

    public AJP13Packet(int n) {
        this.populateHeaders();
        this._buf = ByteArrayPool.getByteArray(n);
        this._ownBuffer = true;
    }

    public void prepare() {
        this._bytes = 0;
        this._pos = 0;
        this.addByte((byte)65);
        this.addByte((byte)66);
        this.addInt(0);
    }

    public void destroy() {
        if (this._ownBuffer) {
            ByteArrayPool.returnByteArray(this._buf);
        }
        this._buf = null;
        this._byteWriter = null;
    }

    public void reset() {
        this._bytes = 0;
        this._pos = 0;
    }

    public byte[] getBuffer() {
        return this._buf;
    }

    public void resetData() {
        this._bytes = 4;
        this._pos = 0;
    }

    public int getMark() {
        return this._bytes;
    }

    public int getBufferSize() {
        return this._buf.length;
    }

    public int unconsumedData() {
        return this._bytes - this._pos;
    }

    public int unconsumedCapacity() {
        return this._buf.length - this._bytes;
    }

    public boolean read(InputStream inputStream) throws IOException {
        int n;
        this._bytes = 0;
        this._pos = 0;
        do {
            if ((n = inputStream.read(this._buf, this._bytes, 4 - this._bytes)) < 0) {
                return false;
            }
            this._bytes += n;
        } while (this._bytes < 4);
        n = this.getInt();
        if (n != 4660) {
            throw new IOException("Bad JSP13 rcv packet:" + n + " " + this);
        }
        int n2 = this.getInt();
        int n3 = 4 + n2;
        if (n3 > this._buf.length) {
            throw new IOException("AJP13 packet (" + n3 + "bytes) too large for buffer (" + this._buf.length + " bytes)");
        }
        do {
            int n4;
            if ((n4 = inputStream.read(this._buf, this._bytes, n3 - this._bytes)) < 0) {
                return false;
            }
            this._bytes += n4;
        } while (this._bytes < n3);
        if (log.isTraceEnabled()) {
            log.trace((Object)("AJP13 rcv: " + this.toString(64)));
        }
        return true;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("AJP13 snd: " + this.toString(64)));
        }
        outputStream.write(this._buf, 0, this._bytes);
    }

    public byte getByte() {
        return this._buf[this._pos++];
    }

    public int getBytes(byte[] byArray, int n, int n2) {
        if (n2 > this.unconsumedData()) {
            n2 = this.unconsumedData();
        }
        System.arraycopy(this._buf, this._pos, byArray, n, n2);
        this._pos += n2;
        return n2;
    }

    public boolean getBoolean() {
        return this._buf[this._pos++] != 0;
    }

    public int getInt() {
        int n = this._buf[this._pos++] & 0xFF;
        n = (n << 8) + (this._buf[this._pos++] & 0xFF);
        return n;
    }

    public String getString() {
        int n = this.getInt();
        if (n == 65535) {
            return null;
        }
        try {
            String string = new String(this._buf, this._pos, n, StringUtil.__ISO_8859_1);
            this._pos += n + 1;
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LogSupport.ignore(log, indexOutOfBoundsException);
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.fatal((Object)unsupportedEncodingException);
            System.exit(1);
            return null;
        }
    }

    public String getMethod() {
        return __method[this.getByte()];
    }

    public String getHeader() {
        if ((0xFF & this._buf[this._pos]) == 160) {
            ++this._pos;
            return this.__header[this._buf[this._pos++]];
        }
        return this.getString();
    }

    public void addByte(byte by) {
        this._buf[this._bytes++] = by;
    }

    public int addBytes(byte[] byArray, int n, int n2) {
        if (n2 > this.unconsumedCapacity()) {
            n2 = this.unconsumedCapacity();
        }
        System.arraycopy(byArray, n, this._buf, this._bytes, n2);
        this._bytes += n2;
        return n2;
    }

    public void addBoolean(boolean bl) {
        this._buf[this._bytes++] = (byte)(bl ? 1 : 0);
    }

    public void addInt(int n) {
        this._buf[this._bytes++] = (byte)(n >> 8 & 0xFF);
        this._buf[this._bytes++] = (byte)(n & 0xFF);
    }

    public void setInt(int n, int n2) {
        this._buf[n] = (byte)(n2 >> 8 & 0xFF);
        this._buf[n + 1] = (byte)(n2 & 0xFF);
    }

    public void addString(String string) throws IOException {
        if (string == null) {
            this.addInt(65535);
            return;
        }
        if (this._byteWriter == null) {
            this._byteWriter = new ByteArrayISO8859Writer(this._buf);
        }
        int n = this._bytes + 2;
        this._byteWriter.setLength(n);
        this._byteWriter.write(string);
        int n2 = this._byteWriter.size() - n;
        this.addInt(n2);
        this._bytes += n2;
        this._buf[this._bytes++] = 0;
    }

    public void addHeader(String string) throws IOException {
        Integer n = (Integer)this.__headerMap.get(string);
        if (n != null) {
            this.addInt(n);
        } else {
            this.addString(string);
        }
    }

    public int getDataSize() {
        return this._bytes - 4;
    }

    public void setDataSize() {
        this.setDataSize(this._bytes - 4);
    }

    public void setDataSize(int n) {
        this._bytes = n + 4;
        this._buf[2] = (byte)(n >> 8 & 0xFF);
        this._buf[3] = (byte)(n & 0xFF);
        if (this._buf[4] == 3) {
            this._buf[5] = (byte)((n -= 3) >> 8 & 0xFF);
            this._buf[6] = (byte)(n & 0xFF);
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(this._bytes);
        stringBuffer.append('/');
        stringBuffer.append(this._buf.length);
        stringBuffer.append('[');
        stringBuffer.append(this._pos);
        stringBuffer.append("]: ");
        switch (this._buf[4]) {
            case 2: {
                stringBuffer.append("FORWARD_REQUEST{:");
                break;
            }
            case 7: {
                stringBuffer.append("SHUTDOWN        :");
                break;
            }
            case 3: {
                stringBuffer.append("SEND_BODY_CHUNK :");
                break;
            }
            case 4: {
                stringBuffer.append("SEND_HEADERS  ( :");
                break;
            }
            case 5: {
                stringBuffer.append("END_RESPONSE  )}:");
                break;
            }
            case 6: {
                stringBuffer.append("GET_BODY_CHUNK  :");
            }
        }
        if (n == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\n");
        for (int i = 0; i < this._bytes; ++i) {
            int n2 = this._buf[i] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n2, 16));
            char c = (char)n2;
            if (Character.isLetterOrDigit(c)) {
                stringBuffer2.append(c);
            } else {
                stringBuffer2.append('.');
            }
            if (i % 32 == 31 || i == this._bytes - 1) {
                stringBuffer.append(" : ");
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2.setLength(0);
                stringBuffer.append("\n");
                if (n <= 0 || i + 1 < n) continue;
                break;
            }
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }
}

