/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;

public class ServletHttpContext
extends HttpContext {
    private HashMap _localeEncodingMap = new HashMap();
    private ServletHandler _servletHandler = null;

    public ServletContext getServletContext() {
        ServletHandler servletHandler = this.getServletHandler();
        if (servletHandler != null) {
            return servletHandler.getServletContext();
        }
        throw new IllegalStateException();
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._servletHandler == null) {
            this._servletHandler = (ServletHandler)this.getHandler(ServletHandler.class);
        }
        if (this._servletHandler == null) {
            this._servletHandler = new ServletHandler();
            this.addHandler(this._servletHandler);
        }
        return this._servletHandler;
    }

    public synchronized ServletHolder addServlet(String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.addServlet(string2, string, string2);
    }

    public synchronized ServletHolder addServlet(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.getServletHandler().addServlet(string, string2, string3, null);
    }

    protected boolean jSecurityCheck(String string, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        return !(this.getAuthenticator() instanceof FormAuthenticator) || !string.endsWith("j_security_check") || this.getAuthenticator().authenticate(this.getRealm(), string, httpRequest, httpResponse) != null;
    }

    public boolean checkSecurityConstraints(String string, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        return super.checkSecurityConstraints(string, httpRequest, httpResponse) && this.jSecurityCheck(string, httpRequest, httpResponse);
    }

    public void addLocaleEncoding(String string, String string2) {
        this._localeEncodingMap.put(string, string2);
    }

    public String getLocaleEncoding(Locale locale) {
        String string = (String)this._localeEncodingMap.get(locale.toString());
        if (string == null) {
            string = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return string;
    }

    public String toString() {
        return "Servlet" + super.toString();
    }

    public void sendError(HttpResponse httpResponse, int n, String string) throws IOException {
        Object object = httpResponse.getWrapper();
        if (object != null && object instanceof HttpServletResponse) {
            ((HttpServletResponse)object).sendError(n, string);
        } else {
            super.sendError(httpResponse, n, string);
        }
    }

    public void destroy() {
        super.destroy();
        if (this._localeEncodingMap != null) {
            this._localeEncodingMap.clear();
        }
        this._localeEncodingMap = null;
    }

    public Object enterContextScope(HttpRequest httpRequest, HttpResponse httpResponse) {
        ServletHttpRequest servletHttpRequest = (ServletHttpRequest)httpRequest.getWrapper();
        ServletHttpResponse servletHttpResponse = (ServletHttpResponse)httpResponse.getWrapper();
        if (servletHttpRequest == null) {
            servletHttpRequest = new ServletHttpRequest(this.getServletHandler(), null, httpRequest);
            servletHttpResponse = new ServletHttpResponse(servletHttpRequest, httpResponse);
            httpRequest.setWrapper(servletHttpRequest);
            httpResponse.setWrapper(servletHttpResponse);
        }
        return super.enterContextScope(httpRequest, httpResponse);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._servletHandler = null;
    }
}

