/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.log.Frame;
import org.mortbay.log.LogSink;
import org.mortbay.util.Loader;

public class LogImpl
implements Log {
    public static final String DEBUG = "DEBUG  ";
    public static final String INFO = "INFO   ";
    public static final String TRACE = "TRACE  ";
    public static final String FAIL = "FAIL!! ";
    public static final String WARN = "WARN!! ";
    public static final String ERROR = "ERROR! ";
    boolean _debugOn = false;
    private ArrayList _debugPatterns = null;
    private boolean _initialized = false;
    private String _patterns = null;
    public LogSink[] _sinks = null;
    private boolean _suppressWarnings = false;
    private int _verbose = 0;
    static /* synthetic */ Class class$org$mortbay$log$LogSink;

    public LogImpl() {
        try {
            this._debugOn = System.getProperty("DEBUG") != null;
            this.setDebugPatterns(System.getProperty("DEBUG_PATTERNS"));
            this.setVerbose(Integer.getInteger("DEBUG_VERBOSE", 0));
        }
        catch (Exception exception) {
            System.err.println("Exception from getProperty!\nProbably running in applet\nUse Code.initParamsFromApplet or Code.setOption to control debug output.");
        }
    }

    public synchronized void add(LogSink logSink) throws Exception {
        logSink.setLogImpl(this);
        if (!logSink.isStarted()) {
            logSink.start();
        }
        if (this._sinks == null) {
            this._sinks = new LogSink[1];
            this._sinks[0] = logSink;
        } else {
            boolean bl = false;
            int n = this._sinks.length;
            while (n-- > 0) {
                if (this._sinks[n] != null) continue;
                bl = true;
                this._sinks[n] = logSink;
                break;
            }
            if (!bl) {
                LogSink[] logSinkArray = new LogSink[this._sinks.length + 1];
                int n2 = this._sinks.length;
                while (n2-- > 0) {
                    logSinkArray[n2] = this._sinks[n2];
                }
                logSinkArray[this._sinks.length] = logSink;
                this._sinks = logSinkArray;
            }
        }
        this._initialized = true;
        this.info("added " + logSink);
    }

    public synchronized void add(String string) {
        try {
            if (string == null || string.length() == 0) {
                string = "org.mortbay.log.OutputStreamLogSink";
            }
            Class clazz = Loader.loadClass(this.getClass(), string);
            LogSink logSink = (LogSink)clazz.newInstance();
            this.add(logSink);
        }
        catch (Exception exception) {
            this.message(WARN, (Object)exception, 2);
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public void debug(Object object) {
        Frame frame;
        if (this._debugOn && this.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            this.message(DEBUG, object, frame);
        }
    }

    public void debug(Object object, Throwable throwable) {
        Frame frame;
        if (this._debugOn && this.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            this.message(DEBUG, (Object)new Object[]{object, throwable}, frame);
        }
    }

    private synchronized void defaultInit() {
        if (!this._initialized) {
            this._initialized = true;
            String string = System.getProperty("LOG_SINKS", "org.mortbay.log.OutputStreamLogSink");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";, ");
            LogSink logSink = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    Class clazz = Loader.loadClass(this.getClass(), string2);
                    if ((class$org$mortbay$log$LogSink == null ? LogImpl.class$("org.mortbay.log.LogSink") : class$org$mortbay$log$LogSink).isAssignableFrom(clazz)) {
                        logSink = (LogSink)clazz.newInstance();
                        logSink.start();
                        this.add(logSink);
                        continue;
                    }
                    System.err.println(clazz + " is not a org.mortbay.log.LogSink");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public synchronized void deleteStoppedLogSinks() {
        if (this._sinks != null) {
            int n = this._sinks.length;
            while (n-- > 0) {
                if (this._sinks[n] == null || this._sinks[n].isStarted()) continue;
                this._sinks[n] = null;
            }
        }
    }

    public synchronized void reset() {
        this.info("reset");
        if (this._sinks != null) {
            int n = this._sinks.length;
            while (n-- > 0) {
                try {
                    if (this._sinks[n] != null) {
                        this._sinks[n].stop();
                    }
                    this._sinks[n] = null;
                }
                catch (InterruptedException interruptedException) {
                    if (!this.getDebug() || this.getVerbose() <= 0) continue;
                    this.message("WARN", interruptedException);
                }
            }
            this._sinks = null;
        }
        this._initialized = true;
    }

    public void error(Object object) {
        this.message(ERROR, object, new Frame(1));
    }

    public void error(Object object, Throwable throwable) {
        this.message(ERROR, (Object)new Object[]{object, throwable}, new Frame(1));
    }

    public void fatal(Object object) {
        this.message(FAIL, object, new Frame(1));
    }

    public void fatal(Object object, Throwable throwable) {
        this.message(FAIL, (Object)new Object[]{object, throwable}, new Frame(1));
    }

    public boolean getDebug() {
        return this._debugOn;
    }

    public String getDebugPatterns() {
        return this._patterns;
    }

    public LogSink[] getLogSinks() {
        return this._sinks;
    }

    public boolean getSuppressWarnings() {
        return this._suppressWarnings;
    }

    public int getVerbose() {
        return this._verbose;
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.message(INFO, object, new Frame(1));
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.message(INFO, (Object)new Object[]{object, throwable}, new Frame(1));
        }
    }

    public boolean isDebugEnabled() {
        return this._debugOn;
    }

    public boolean isErrorEnabled() {
        return !this._suppressWarnings;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return this._verbose >= 0;
    }

    public boolean isTraceEnabled() {
        return this._verbose > 0;
    }

    public boolean isWarnEnabled() {
        return !this._suppressWarnings;
    }

    public void message(String string, Object object, Frame frame) {
        long l = System.currentTimeMillis();
        this.message(string, object, frame, l);
    }

    public synchronized void message(String string, Object object, Frame frame, long l) {
        if (!this._initialized) {
            this.defaultInit();
        }
        boolean bl = false;
        if (this._sinks != null) {
            int n = this._sinks.length;
            while (n-- > 0) {
                if (this._sinks[n] == null || !this._sinks[n].isStarted()) continue;
                bl = true;
                this._sinks[n].log(string, object, frame, l);
            }
        }
        if (!bl) {
            System.err.println(l + ": " + string + ":" + object + " @ " + frame);
        }
    }

    public synchronized void message(String string, Object object) {
        this.message(string, object, new Frame(1), System.currentTimeMillis());
    }

    public synchronized void message(String string, Object object, int n) {
        this.message(string, object, new Frame(n), System.currentTimeMillis());
    }

    public synchronized void setDebug(boolean bl) {
        boolean bl2 = this._debugOn;
        if (this._debugOn && !bl) {
            this.message(DEBUG, "DEBUG OFF");
        }
        this._debugOn = bl;
        if (!bl2 && bl) {
            this.message(DEBUG, "DEBUG ON");
        }
    }

    public void setDebugPatterns(String string) {
        this._patterns = string;
        if (string != null && string.length() > 0) {
            this._debugPatterns = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this._debugPatterns.add(string2);
            }
        } else {
            this._debugPatterns = null;
        }
    }

    public void setSuppressWarnings(boolean bl) {
        this._suppressWarnings = bl;
    }

    public void setVerbose(int n) {
        this._verbose = n;
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.message(TRACE, object, new Frame(1));
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.message(TRACE, (Object)new Object[]{object, throwable}, new Frame(1));
        }
    }

    public void warn(Object object) {
        if (!this._suppressWarnings) {
            this.message(WARN, object, new Frame(1));
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (!this._suppressWarnings) {
            this.message(WARN, (Object)new Object[]{object, throwable}, new Frame(1));
        }
    }

    private boolean isDebugOnFor(Frame frame) {
        if (this._debugOn) {
            if (this._debugPatterns == null) {
                return true;
            }
            int n = this._debugPatterns.size();
            while (--n >= 0) {
                if (frame.getWhere().indexOf((String)this._debugPatterns.get(n)) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

