/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.mortbay.log.Frame;
import org.mortbay.log.LogImpl;
import org.mortbay.log.LogSink;
import org.mortbay.log.LogStream;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.DateCache;
import org.mortbay.util.MultiException;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringBufferWriter;
import org.mortbay.util.StringUtil;

public class OutputStreamLogSink
implements LogSink {
    private static final String __lineSeparator = System.getProperty("line.separator");
    private int _retainDays = 31;
    protected DateCache _dateFormat = new DateCache("HH:mm:ss.SSS");
    protected String _logTimezone;
    protected boolean _logTimeStamps = true;
    protected boolean _logLabels = true;
    protected boolean _logTags = true;
    protected boolean _logStackSize = true;
    protected boolean _logStackTrace = false;
    protected boolean _logOneLine = false;
    protected boolean _suppressStack = false;
    private String _filename;
    private boolean _append = true;
    protected boolean _flushOn = true;
    protected int _bufferSize = 2048;
    protected boolean _reopen = false;
    protected transient LogImpl _logImpl = null;
    protected transient boolean _started;
    protected transient OutputStream _out;
    protected transient ByteArrayISO8859Writer _buffer;
    private static final Class[] __noArgs = new Class[0];
    private static final String[] __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
    private static StringBufferWriter __stringBufferWriter = new StringBufferWriter();
    private static PrintWriter __printWriter = new PrintWriter(__stringBufferWriter);

    public OutputStreamLogSink() throws IOException {
        this._filename = System.getProperty("LOG_FILE");
        if (this._filename == null) {
            this._out = LogStream.STDERR_STREAM;
        }
    }

    public OutputStreamLogSink(String string) {
        this._filename = string;
    }

    public String getLogDateFormat() {
        return this._dateFormat.getFormatString();
    }

    public void setLogDateFormat(String string) {
        this._dateFormat = new DateCache(string);
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimezone() {
        return this._logTimezone;
    }

    public void setLogTimezone(String string) {
        this._logTimezone = string;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimeZone() {
        return this._logTimezone;
    }

    public void setLogTimeZone(String string) {
        this._logTimezone = string;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public boolean isLogTimeStamps() {
        return this._logTimeStamps;
    }

    public void setLogTimeStamps(boolean bl) {
        this._logTimeStamps = bl;
    }

    public boolean isLogLabels() {
        return this._logLabels;
    }

    public void setLogLabels(boolean bl) {
        this._logLabels = bl;
    }

    public boolean isLogTags() {
        return this._logTags;
    }

    public void setLogTags(boolean bl) {
        this._logTags = bl;
    }

    public boolean isLogStackSize() {
        return this._logStackSize;
    }

    public void setLogStackSize(boolean bl) {
        this._logStackSize = bl;
    }

    public boolean isLogStackTrace() {
        return this._logStackTrace;
    }

    public void setLogStackTrace(boolean bl) {
        this._logStackTrace = bl;
    }

    public boolean isLogOneLine() {
        return this._logOneLine;
    }

    public void setLogOneLine(boolean bl) {
        this._logOneLine = bl;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean bl) {
        this._append = bl;
    }

    public boolean isSuppressStack() {
        return this._suppressStack;
    }

    public void setSuppressStack(boolean bl) {
        this._suppressStack = bl;
    }

    public synchronized void setOutputStream(OutputStream outputStream) {
        this._reopen = this.isStarted() && outputStream != outputStream;
        this._filename = null;
        if (this._buffer != null) {
            this._buffer.resetWriter();
        }
        this._out = outputStream;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public synchronized void setFilename(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (this.isStarted() && this._filename != null && string == null) {
            this._out = null;
        }
        this._reopen = this.isStarted() && (this._filename == null && string != null || this._filename != null && !this._filename.equals(string));
        this._filename = string;
        if (!this.isStarted() && this._filename != null) {
            this._out = null;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._filename == null) {
            return null;
        }
        if (this._out == null || !(this._out instanceof RolloverFileOutputStream)) {
            return null;
        }
        return ((RolloverFileOutputStream)this._out).getDatedFilename();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int n) {
        this._reopen = this.isStarted() && this._retainDays != n;
        this._retainDays = n;
    }

    public void setFlushOn(boolean bl) {
        this._flushOn = bl;
        if (bl && this._out != null) {
            try {
                this._out.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean getFlushOn() {
        return this._flushOn;
    }

    public synchronized void log(String string, Object object, Frame frame, long l) {
        StringBuffer stringBuffer = new StringBuffer(160);
        if (this._logTimeStamps) {
            stringBuffer.append(this._dateFormat.format(l));
            stringBuffer.append(' ');
        }
        if (this._logTags) {
            stringBuffer.append(string);
        }
        if (this._logLabels && frame != null) {
            stringBuffer.append(frame.toString());
        }
        if (this._logStackSize && frame != null) {
            stringBuffer.append(" >");
            if (frame.getDepth() < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(frame.getDepth()));
            stringBuffer.append("> ");
        }
        String string2 = __lineSeparator;
        if (this._logLabels && !this._logOneLine && this._buffer.size() > 0) {
            stringBuffer.append(string2);
        }
        this.formatObject(stringBuffer, object);
        if (this._logStackTrace && frame != null) {
            stringBuffer.append(string2);
            stringBuffer.append(frame.getStack());
        }
        this.log(stringBuffer.toString());
    }

    public synchronized void log(String string) {
        if (this._reopen || this._out == null) {
            this.stop();
            this.start();
        }
        try {
            this._buffer.write(string);
            this._buffer.write(StringUtil.__LINE_SEPARATOR);
            if (this._flushOn || this._buffer.size() > this._bufferSize) {
                this._buffer.writeTo(this._out);
                this._buffer.resetWriter();
                this._out.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void start() {
        this._buffer = new ByteArrayISO8859Writer(this._bufferSize);
        this._reopen = false;
        if (this._started) {
            return;
        }
        if (this._out == null && this._filename != null) {
            try {
                RolloverFileOutputStream rolloverFileOutputStream = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
                this._out = rolloverFileOutputStream;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this._out == null) {
            this._out = LogStream.STDERR_STREAM;
        }
        this._started = true;
    }

    public synchronized void stop() {
        block9: {
            this._started = false;
            if (this._out != null) {
                block8: {
                    try {
                        if (this._buffer.size() > 0) {
                            this._buffer.writeTo(this._out);
                        }
                        this._out.flush();
                        this._buffer = null;
                    }
                    catch (Exception exception) {
                        if (this._logImpl == null || !this._logImpl.getDebug()) break block8;
                        exception.printStackTrace();
                    }
                }
                Thread.yield();
            }
            if (this._out != null && this._out != LogStream.STDERR_STREAM) {
                try {
                    this._out.close();
                }
                catch (Exception exception) {
                    if (this._logImpl == null || !this._logImpl.getDebug()) break block9;
                    exception.printStackTrace();
                }
            }
        }
        if (this._filename != null) {
            this._out = null;
        }
    }

    public boolean isStarted() {
        return this._started;
    }

    public void setLogImpl(LogImpl logImpl) {
        this._logImpl = logImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatObject(StringBuffer stringBuffer, Object object) {
        int n;
        int n2;
        int n3 = stringBuffer.length();
        if (object == null) {
            stringBuffer.append("null");
        } else if (object.getClass().isArray()) {
            n2 = Array.getLength(object);
            for (n = 0; n < n2; ++n) {
                this.formatObject(stringBuffer, Array.get(object, n));
            }
        } else if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            stringBuffer.append('\n');
            if (this._suppressStack) {
                stringBuffer.append(throwable.toString());
                stringBuffer.append("\nNo stack available\n--");
            } else {
                PrintWriter printWriter = __printWriter;
                synchronized (printWriter) {
                    __stringBufferWriter.setStringBuffer(stringBuffer);
                    OutputStreamLogSink.expandThrowable(throwable);
                    __printWriter.flush();
                }
            }
        } else {
            stringBuffer.append(object.toString());
        }
        n2 = stringBuffer.length();
        if (this._logOneLine) {
            for (n = n3; n < n2; ++n) {
                char c = stringBuffer.charAt(n);
                if (c == '\n') {
                    stringBuffer.setCharAt(n, '|');
                    continue;
                }
                if (c != '\r') continue;
                stringBuffer.setCharAt(n, '<');
            }
        }
    }

    private static void expandThrowable(Throwable throwable) {
        throwable.printStackTrace(__printWriter);
        if (throwable instanceof MultiException) {
            MultiException multiException = (MultiException)throwable;
            for (int i = 0; i < multiException.size(); ++i) {
                __printWriter.print("[" + i + "]=");
                Exception exception = multiException.getException(i);
                OutputStreamLogSink.expandThrowable(exception);
            }
        } else {
            for (int i = 0; i < __nestedEx.length; ++i) {
                try {
                    Method method = throwable.getClass().getMethod(__nestedEx[i], __noArgs);
                    Throwable throwable2 = (Throwable)method.invoke((Object)throwable, (Object[])null);
                    if (throwable2 == null) continue;
                    __printWriter.println(__nestedEx[i] + "():");
                    OutputStreamLogSink.expandThrowable(throwable2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

