/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PostFileFilter
implements Filter {
    ServletContext _context;
    int _bufferSize = 8092;
    String _response = "nocontent";

    public void init(FilterConfig filterConfig) throws ServletException {
        this._context = filterConfig.getServletContext();
        String string = filterConfig.getInitParameter("bufferSize");
        if (string != null) {
            this._bufferSize = Integer.parseInt(string);
        }
        if ((string = filterConfig.getInitParameter("response")) != null) {
            this._response = string;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if ("POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
            int n;
            String string = httpServletRequest.getPathTranslated();
            if (string == null) {
                string = httpServletRequest.getPathInfo() == null ? this._context.getRealPath(httpServletRequest.getServletPath()) : this._context.getRealPath(httpServletRequest.getServletPath() + httpServletRequest.getPathInfo());
            }
            if (string == null) {
                httpServletResponse.sendError(404);
                return;
            }
            if (httpServletRequest.getContentLength() == 0) {
                httpServletResponse.sendError(411);
                return;
            }
            File file = new File(string);
            if (!((!file.exists() || file.canWrite() && !file.isDirectory()) && (file.exists() || file.getParentFile().exists() && file.getParentFile().isDirectory() && file.getParentFile().canWrite()))) {
                httpServletResponse.sendError(403, "No write permission");
                return;
            }
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            byte[] byArray = new byte[this._bufferSize];
            while ((n = servletInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            if ("redirect".equalsIgnoreCase(this._response)) {
                httpServletResponse.sendRedirect(httpServletRequest.getRequestURI());
            } else if ("chain".equalsIgnoreCase(this._response)) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else if ("ok".equalsIgnoreCase(this._response)) {
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.setStatus(204);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

